/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.operator;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;

public abstract class OperatorBase
implements IOperator {
    private final String symbol;
    private final String operatorName;
    private final IValueType[] inputTypes;
    private final IValueType outputType;
    private final IFunction function;
    @Nullable
    private final IConfigRenderPattern renderPattern;
    private String translationKey = null;
    private int recursiveInvocations;

    protected OperatorBase(String symbol, String operatorName, IValueType[] inputTypes, IValueType outputType, IFunction function, @Nullable IConfigRenderPattern renderPattern) {
        this.symbol = symbol;
        this.operatorName = operatorName;
        this.inputTypes = inputTypes;
        this.outputType = outputType;
        this.function = function;
        this.renderPattern = renderPattern;
        if (renderPattern != null && renderPattern.getSlotPositions().length != inputTypes.length) {
            throw new IllegalArgumentException(String.format("The given config render pattern with %s slots is not compatible with the number of input types %s for %s", renderPattern.getSlotPositions().length, inputTypes.length, symbol));
        }
    }

    public static IValueType[] constructInputVariables(int length, IValueType defaultType) {
        Object[] values = new IValueType[length];
        Arrays.fill(values, defaultType);
        return values;
    }

    protected abstract String getUnlocalizedType();

    protected IFunction getFunction() {
        return this.function;
    }

    @Override
    public ResourceLocation getUniqueName() {
        return new ResourceLocation(this.getModId(), this.getUnlocalizedType().replaceAll("\\.", "_") + "_" + this.getOperatorName());
    }

    @Override
    public String getTranslationKey() {
        return this.translationKey != null ? this.translationKey : (this.translationKey = this.getUnlocalizedPrefix());
    }

    @Override
    public String getUnlocalizedCategoryName() {
        return this.getUnlocalizedCategoryPrefix();
    }

    @Override
    public IFormattableTextComponent getLocalizedNameFull() {
        return new TranslationTextComponent(this.getUnlocalizedCategoryPrefix() + ".basename", new Object[]{new TranslationTextComponent(this.getTranslationKey())});
    }

    protected String getUnlocalizedPrefix() {
        return "operator." + this.getModId() + "." + this.getUnlocalizedType() + "." + this.getOperatorName();
    }

    protected String getUnlocalizedCategoryPrefix() {
        return "operator." + this.getModId() + "." + this.getUnlocalizedType();
    }

    protected String getOperatorName() {
        return this.operatorName;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public void loadTooltip(List<ITextComponent> lines, boolean appendOptionalInfo) {
        TranslationTextComponent operatorName = new TranslationTextComponent(this.getTranslationKey());
        TranslationTextComponent categoryName = new TranslationTextComponent(this.getUnlocalizedCategoryName());
        String symbol = this.getSymbol();
        String outputTypeName = L10NHelpers.localize((String)this.getOutputType().getTranslationKey(), (Object[])new Object[0]);
        lines.add((ITextComponent)new TranslationTextComponent("operator.integrateddynamics.tooltip.operator_name", new Object[]{operatorName, symbol}));
        lines.add((ITextComponent)new TranslationTextComponent("operator.integrateddynamics.tooltip.operator_category", new Object[]{categoryName}));
        IValueType[] inputTypes = this.getInputTypes();
        for (int i = 0; i < inputTypes.length; ++i) {
            lines.add((ITextComponent)new TranslationTextComponent("operator.integrateddynamics.tooltip.input_type_name", new Object[]{i + 1}).func_240699_a_(inputTypes[i].getDisplayColorFormat()).func_230529_a_((ITextComponent)new TranslationTextComponent(inputTypes[i].getTranslationKey())));
        }
        lines.add((ITextComponent)new TranslationTextComponent("operator.integrateddynamics.tooltip.output_type_name", new Object[]{this.getOutputType().getDisplayColorFormat() + outputTypeName}));
        if (appendOptionalInfo) {
            L10NHelpers.addOptionalInfo(lines, (String)this.getUnlocalizedPrefix());
        }
    }

    @Override
    public IValueType[] getInputTypes() {
        return this.inputTypes;
    }

    @Override
    public IValueType getOutputType() {
        return this.outputType;
    }

    @Override
    public IValueType getConditionalOutputType(IVariable[] input) {
        return this.outputType;
    }

    @Override
    public IValue evaluate(IVariable ... input) throws EvaluationException {
        if (this.recursiveInvocations++ > GeneralConfig.operatorRecursionLimit) {
            this.recursiveInvocations = 0;
            throw new EvaluationException((IFormattableTextComponent)new TranslationTextComponent("operator.integrateddynamics.error.operator_recursion_limit", new Object[]{GeneralConfig.operatorRecursionLimit, new TranslationTextComponent(this.getTranslationKey())}));
        }
        IFormattableTextComponent error = this.validateTypes(ValueHelpers.from(input));
        if (error != null) {
            --this.recursiveInvocations;
            throw new EvaluationException(error);
        }
        IValue res = this.function.evaluate(new SafeVariablesGetter(input));
        --this.recursiveInvocations;
        return res;
    }

    @Override
    public int getRequiredInputLength() {
        return this.getInputTypes().length;
    }

    @Override
    public IFormattableTextComponent validateTypes(IValueType[] input) {
        int requiredInputLength = this.getRequiredInputLength();
        if (input.length != requiredInputLength) {
            return new TranslationTextComponent("operator.integrateddynamics.error.wrong_input_length", new Object[]{this.getOperatorName(), input.length, requiredInputLength});
        }
        for (int i = 0; i < requiredInputLength; ++i) {
            IValueType inputType = input[i];
            if (inputType == null) {
                return new TranslationTextComponent("operator.integrateddynamics.error.null_type", new Object[]{this.getOperatorName(), Integer.toString(i)});
            }
            if (ValueHelpers.correspondsTo(this.getInputTypes()[i], inputType)) continue;
            return new TranslationTextComponent("operator.integrateddynamics.error.wrong_type", new Object[]{this.getOperatorName(), new TranslationTextComponent(inputType.getTranslationKey()), Integer.toString(i + 1), new TranslationTextComponent(this.getInputTypes()[i].getTranslationKey())});
        }
        return null;
    }

    public String toString() {
        return "[Operator: " + this.getOperatorName() + "]";
    }

    protected String getModId() {
        return "integrateddynamics";
    }

    @Override
    @Nullable
    public IConfigRenderPattern getRenderPattern() {
        return this.renderPattern;
    }

    @Override
    public IOperator materialize() throws EvaluationException {
        return this;
    }

    public static interface IFunction {
        public IValue evaluate(SafeVariablesGetter var1) throws EvaluationException;
    }

    public static class SafeVariablesGetter {
        private final IVariable[] variables;

        public SafeVariablesGetter(IVariable ... variables) {
            this.variables = variables;
        }

        public IValue getValue(int i) throws EvaluationException {
            return this.variables[i].getValue();
        }

        public <V extends IValue> V getValue(int i, IValueType<V> valueType) throws EvaluationException {
            return valueType.cast(this.getValue(i));
        }

        public IVariable[] getVariables() {
            return this.variables;
        }

        public static class Shifted
        extends SafeVariablesGetter {
            public Shifted(int start, IVariable ... variables) {
                super(Arrays.copyOfRange(variables, start, variables.length));
            }
        }
    }
}

