/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.integrateddynamics.api.advancement.criterion.ValuePredicate;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNamed;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNullable;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeUniquelyNamed;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeLPElementBase;

public class ValueObjectTypeEntity
extends ValueObjectTypeBase<ValueEntity>
implements IValueTypeNamed<ValueEntity>,
IValueTypeUniquelyNamed<ValueEntity>,
IValueTypeNullable<ValueEntity> {
    public ValueObjectTypeEntity() {
        super("entity", ValueEntity.class);
    }

    @Override
    public ValueEntity getDefault() {
        return ValueEntity.of((UUID)null);
    }

    @Override
    public IFormattableTextComponent toCompactString(ValueEntity value) {
        Optional<UUID> uuid = value.getUuid();
        if (uuid.isPresent()) {
            Optional<Entity> entity = value.getRawValue();
            if (entity.isPresent()) {
                Entity e = entity.get();
                if (e instanceof ItemEntity) {
                    return (IFormattableTextComponent)((ItemEntity)e).func_92059_d().func_200301_q();
                }
                return (IFormattableTextComponent)e.func_200200_C_();
            }
            return new StringTextComponent("unknown");
        }
        return new StringTextComponent("");
    }

    @Override
    public INBT serialize(ValueEntity value) {
        Optional<UUID> uuid = value.getUuid();
        if (uuid.isPresent()) {
            return StringNBT.func_229705_a_((String)uuid.get().toString());
        }
        return StringNBT.func_229705_a_((String)"");
    }

    @Override
    public ValueEntity deserialize(INBT value) {
        try {
            return ValueEntity.of(UUID.fromString(value.func_150285_a_()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return ValueEntity.of((UUID)null);
        }
    }

    @Override
    public String getName(ValueEntity a) {
        return this.toCompactString(a).getString();
    }

    @Override
    public boolean isNull(ValueEntity a) {
        return !a.getRawValue().isPresent();
    }

    @Override
    public ValueTypeLPElementBase createLogicProgrammerElement() {
        return null;
    }

    @Override
    public ValuePredicate<ValueEntity> deserializeValuePredicate(JsonObject element, @Nullable IValue value) {
        JsonElement jsonElement = element.get("entity");
        String entityTypeName = jsonElement != null && !jsonElement.isJsonNull() ? jsonElement.getAsString() : null;
        EntityType entityType = null;
        if (entityTypeName != null) {
            try {
                entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(entityTypeName));
            }
            catch (ResourceLocationException e) {
                throw new JsonSyntaxException("Invalid entity type name '" + entityTypeName + "'");
            }
            if (entityType == null) {
                throw new JsonSyntaxException("Could not find the entity type '" + entityTypeName + "'");
            }
        }
        return new ValueEntityPredicate(this, value, entityType);
    }

    @Override
    public String getUniqueName(ValueEntity value) {
        Optional<UUID> uuid = value.getUuid();
        if (uuid.isPresent()) {
            UUID id = uuid.get();
            String entityName = value.getRawValue().map(entity -> entity.func_200600_R().getRegistryName().toString()).orElse("unknown");
            return id.toString() + " (" + entityName + ")";
        }
        return "";
    }

    public static class ValueEntityPredicate
    extends ValuePredicate<ValueEntity> {
        private final EntityType<? extends Entity> entityType;

        public ValueEntityPredicate(@Nullable IValueType valueType, @Nullable IValue value, @Nullable EntityType<? extends Entity> entityType) {
            super(valueType, value);
            this.entityType = entityType;
        }

        @Override
        protected boolean testTyped(ValueEntity value) {
            return super.testTyped(value) && (this.entityType == null || value.getRawValue().isPresent() && value.getRawValue().get().func_200600_R() == this.entityType);
        }
    }

    public static class ValueEntity
    extends ValueBase {
        private final Optional<UUID> value;

        protected ValueEntity(@Nullable Entity value) {
            super(ValueTypes.OBJECT_ENTITY);
            this.value = value == null ? Optional.empty() : Optional.of(value.func_110124_au());
        }

        private ValueEntity(@Nullable UUID entityUuid) {
            super(ValueTypes.OBJECT_ENTITY);
            this.value = Optional.ofNullable(entityUuid);
        }

        public Optional<Entity> getRawValue() {
            Optional<UUID> uuid = this.getUuid();
            if (uuid.isPresent()) {
                Optional optionalEntity = (Optional)DistExecutor.callWhenOn((Dist)Dist.CLIENT, () -> () -> {
                    if (MinecraftHelpers.isClientSideThread()) {
                        for (Entity entity : Minecraft.func_71410_x().field_71441_e.func_217416_b()) {
                            if (!entity.func_110124_au().equals(uuid.get())) continue;
                            return Optional.of(entity);
                        }
                        return Optional.empty();
                    }
                    return null;
                });
                if (optionalEntity == null) {
                    for (ServerWorld world : ServerLifecycleHooks.getCurrentServer().func_212370_w()) {
                        Entity entity = world.func_217461_a(uuid.get());
                        if (entity == null) continue;
                        return Optional.of(entity);
                    }
                } else {
                    return optionalEntity;
                }
            }
            return Optional.empty();
        }

        public Optional<UUID> getUuid() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o instanceof ValueEntity) {
                if (((ValueEntity)o).value.isPresent() && this.value.isPresent()) {
                    return ((ValueEntity)o).value.get().equals(this.value.get());
                }
                if (!((ValueEntity)o).value.isPresent() && !this.value.isPresent()) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.getType().hashCode() + (this.getRawValue().isPresent() ? this.getRawValue().get().hashCode() : 0);
        }

        public static ValueEntity of(@Nullable Entity entity) {
            return new ValueEntity(entity);
        }

        public static ValueEntity of(@Nullable UUID entityUuid) {
            return new ValueEntity(entityUuid);
        }

        @Override
        public String toString() {
            return "ValueObjectTypeEntity.ValueEntity(value=" + this.value + ")";
        }
    }
}

