/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxy;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxyFactoryTypeRegistry;

public class ValueTypeListProxyFactoryTypeRegistry
implements IValueTypeListProxyFactoryTypeRegistry {
    private static ValueTypeListProxyFactoryTypeRegistry INSTANCE = new ValueTypeListProxyFactoryTypeRegistry();
    private final Map<String, IValueTypeListProxyFactoryTypeRegistry.IProxyFactory> factories = Maps.newHashMap();

    private ValueTypeListProxyFactoryTypeRegistry() {
    }

    public static ValueTypeListProxyFactoryTypeRegistry getInstance() {
        return INSTANCE;
    }

    @Override
    public <T extends IValueType<V>, V extends IValue, P extends IValueTypeListProxy<T, V>, F extends IValueTypeListProxyFactoryTypeRegistry.IProxyFactory<T, V, P>> F register(F proxyFactory) {
        if (this.factories.containsKey(proxyFactory.getName())) {
            throw new RuntimeException(String.format("A list proxy factory by name '%s' already exists.", proxyFactory.getName()));
        }
        this.factories.put(proxyFactory.getName().toString(), proxyFactory);
        return proxyFactory;
    }

    @Override
    public <T extends IValueType<V>, V extends IValue, P extends IValueTypeListProxy<T, V>> IValueTypeListProxyFactoryTypeRegistry.IProxyFactory<T, V, P> getFactory(ResourceLocation name) {
        return this.factories.get(name.toString());
    }

    @Override
    public <T extends IValueType<V>, V extends IValue, P extends IValueTypeListProxy<T, V>> INBT serialize(P proxy) throws IValueTypeListProxyFactoryTypeRegistry.SerializationException {
        IValueTypeListProxyFactoryTypeRegistry.IProxyFactory<T, V, P> factory = this.getFactory(proxy.getName());
        if (factory == null) {
            throw new IValueTypeListProxyFactoryTypeRegistry.SerializationException(String.format("No serialization factory exists for the list proxy type name '%s'.", proxy.getName()));
        }
        INBT serialized = factory.serialize(proxy);
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("proxyName", proxy.getName().toString());
        tag.func_218657_a("serialized", serialized);
        return tag;
    }

    @Override
    public <T extends IValueType<V>, V extends IValue, P extends IValueTypeListProxy<T, V>> P deserialize(INBT value) throws IValueTypeListProxyFactoryTypeRegistry.SerializationException {
        if (!(value instanceof CompoundNBT)) {
            throw new IValueTypeListProxyFactoryTypeRegistry.SerializationException(String.format("Could not deserialize the serialized list proxy value '%s' as it is not a CompoundNBT.", value));
        }
        CompoundNBT tag = (CompoundNBT)value;
        if (!tag.func_150297_b("proxyName", 8)) {
            throw new IValueTypeListProxyFactoryTypeRegistry.SerializationException(String.format("Could not deserialize the serialized list proxy value '%s' as it is missing a proxyName.", value));
        }
        if (!tag.func_74764_b("serialized")) {
            throw new IValueTypeListProxyFactoryTypeRegistry.SerializationException(String.format("Could not deserialize the serialized list proxy value '%s' as it is missing a serialized value.", value));
        }
        String name = tag.func_74779_i("proxyName");
        INBT actualValue = tag.func_74781_a("serialized");
        IValueTypeListProxyFactoryTypeRegistry.IProxyFactory<T, V, P> factory = this.getFactory(new ResourceLocation(name));
        if (factory == null) {
            throw new IValueTypeListProxyFactoryTypeRegistry.SerializationException(String.format("No deserialization factory exists for the list proxy type name '%s'.", name));
        }
        return factory.deserialize(actualValue);
    }
}

