/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.ingredient;

import com.google.common.collect.Sets;
import java.util.AbstractList;
import java.util.List;
import java.util.Set;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.integrateddynamics.core.ingredient.WrappedIngredients;

public class ExtendedIngredientsSingle<T, M>
extends WrappedIngredients {
    private final int targetIndex;
    private final IngredientComponent<T, M> component;
    private final T instance;

    public ExtendedIngredientsSingle(IMixedIngredients base, int targetIndex, IngredientComponent<T, M> component, T instance) {
        super(base);
        this.targetIndex = targetIndex;
        this.component = component;
        this.instance = instance;
    }

    protected boolean forComponent(IngredientComponent<?, ?> component) {
        return component == this.component;
    }

    @Override
    public Set<IngredientComponent<?, ?>> getComponents() {
        Set components = Sets.newIdentityHashSet();
        components.addAll(super.getComponents());
        components.add(this.component);
        return components;
    }

    public <T2> List<T2> getInstances(IngredientComponent<T2, ?> ingredientComponent) {
        final AbstractList superList = super.getInstances(ingredientComponent);
        return this.forComponent(ingredientComponent) ? new AbstractList<T2>(){

            @Override
            public T2 get(int index) {
                if (index == ExtendedIngredientsSingle.this.targetIndex) {
                    return ExtendedIngredientsSingle.this.instance;
                }
                if (index < ExtendedIngredientsSingle.this.targetIndex && index >= superList.size()) {
                    return ExtendedIngredientsSingle.this.component.getMatcher().getEmptyInstance();
                }
                return superList.get(index);
            }

            @Override
            public int size() {
                int superSize = superList.size();
                if (ExtendedIngredientsSingle.this.targetIndex >= superSize) {
                    return ExtendedIngredientsSingle.this.targetIndex + 1;
                }
                return superSize;
            }
        } : superList;
    }
}

