/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.tileentity;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.datastructure.SingleCache;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.helper.CraftingHelpers;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.integrateddynamics.Capabilities;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.block.BlockMechanicalSqueezer;
import org.cyclops.integrateddynamics.block.BlockMechanicalSqueezerConfig;
import org.cyclops.integrateddynamics.core.recipe.handler.RecipeHandlerSqueezer;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeMechanicalSqueezer;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeSqueezer;
import org.cyclops.integrateddynamics.core.tileentity.TileMechanicalMachine;
import org.cyclops.integrateddynamics.inventory.container.ContainerMechanicalSqueezer;

public class TileMechanicalSqueezer
extends TileMechanicalMachine<ItemStack, RecipeMechanicalSqueezer>
implements INamedContainerProvider {
    public static final int INVENTORY_SIZE = 5;
    private static final int SLOT_INPUT = 0;
    private static final int[] SLOTS_OUTPUT = new int[]{1, 2, 3, 4};
    private static final int TANK_SIZE = 100000;
    @NBTPersist
    private boolean autoEjectFluids = false;
    private final SingleUseTank tank = new SingleUseTank(100000);

    public TileMechanicalSqueezer() {
        super(RegistryEntries.TILE_ENTITY_MECHANICAL_SQUEEZER, 5);
        this.addCapabilityInternal(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, LazyOptional.of(() -> this.tank));
        this.addCapabilityInternal(Capabilities.RECIPE_HANDLER, LazyOptional.of(() -> new RecipeHandlerSqueezer(() -> ((TileMechanicalSqueezer)this).func_145831_w())));
        this.tank.addDirtyMarkListener(this::onTankChanged);
    }

    @Override
    protected SingleCache.ICacheUpdater<ItemStack, Optional<RecipeMechanicalSqueezer>> createCacheUpdater() {
        return new SingleCache.ICacheUpdater<ItemStack, Optional<RecipeMechanicalSqueezer>>(){

            public Optional<RecipeMechanicalSqueezer> getNewValue(ItemStack key) {
                Inventory recipeInput = new Inventory(new ItemStack[]{key});
                return CraftingHelpers.findServerRecipe(TileMechanicalSqueezer.this.getRecipeRegistry(), (IInventory)recipeInput, (World)TileMechanicalSqueezer.this.func_145831_w());
            }

            public boolean isKeyEqual(ItemStack cacheKey, ItemStack newKey) {
                return ItemStack.func_77989_b((ItemStack)cacheKey, (ItemStack)newKey);
            }
        };
    }

    @Override
    public int[] getInputSlots() {
        return new int[]{0};
    }

    @Override
    public int[] getOutputSlots() {
        return SLOTS_OUTPUT;
    }

    @Override
    public boolean wasWorking() {
        return (Boolean)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b((Property)BlockMechanicalSqueezer.LIT);
    }

    @Override
    public void setWorking(boolean working) {
        this.func_145831_w().func_175656_a(this.func_174877_v(), (BlockState)this.func_145831_w().func_180495_p(this.func_174877_v()).func_206870_a((Property)BlockMechanicalSqueezer.LIT, (Comparable)Boolean.valueOf(working)));
    }

    public SingleUseTank getTank() {
        return this.tank;
    }

    @Override
    public void read(CompoundNBT tag) {
        super.read(tag);
        this.getTank().readFromNBT(tag.func_74775_l("tank"));
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_218657_a("tank", (INBT)this.getTank().writeToNBT(new CompoundNBT()));
        return super.func_189515_b(tag);
    }

    @Override
    protected IRecipeType<RecipeMechanicalSqueezer> getRecipeRegistry() {
        return RegistryEntries.RECIPETYPE_MECHANICAL_SQUEEZER;
    }

    @Override
    protected ItemStack getCurrentRecipeCacheKey() {
        return this.getInventory().func_70301_a(0).func_77946_l();
    }

    @Override
    public int getRecipeDuration(RecipeMechanicalSqueezer recipe) {
        return recipe.getDuration();
    }

    @Override
    protected boolean finalizeRecipe(RecipeMechanicalSqueezer recipe, boolean simulate) {
        NonNullList outputStacks = NonNullList.func_191196_a();
        for (RecipeSqueezer.ItemStackChance itemStackChance : recipe.getOutputItems()) {
            ItemStack outputStack = itemStackChance.getItemStack().func_77946_l();
            if (outputStack.func_190926_b() || !simulate && itemStackChance.getChance() != 1.0f && !(itemStackChance.getChance() >= this.func_145831_w().field_73012_v.nextFloat())) continue;
            InventoryHelpers.addStackToList((NonNullList)outputStacks, (ItemStack)outputStack);
        }
        if (!InventoryHelpers.addToInventory((IInventory)this.getInventory(), (int[])SLOTS_OUTPUT, (NonNullList)outputStacks, (boolean)simulate).isEmpty()) {
            return false;
        }
        FluidStack outputFluid = recipe.getOutputFluid();
        if (outputFluid != null && this.getTank().fill(outputFluid.copy(), FluidHelpers.simulateBooleanToAction((boolean)simulate)) != outputFluid.getAmount()) {
            return false;
        }
        if (!simulate) {
            this.getInventory().func_70298_a(0, 1);
        }
        return true;
    }

    @Override
    public int getEnergyConsumptionRate() {
        return BlockMechanicalSqueezerConfig.consumptionRate;
    }

    public int getMaxEnergyStored() {
        return BlockMechanicalSqueezerConfig.capacity;
    }

    @Override
    protected void updateTileEntity() {
        super.updateTileEntity();
        if (!this.field_145850_b.func_201670_d() && this.isAutoEjectFluids() && !this.getTank().isEmpty()) {
            for (Direction side : Direction.values()) {
                IFluidHandler handler = (IFluidHandler)TileHelpers.getCapability((IBlockReader)this.func_145831_w(), (BlockPos)this.func_174877_v().func_177972_a(side), (Direction)side.func_176734_d(), (Capability)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).orElse(null);
                if (handler == null) continue;
                FluidStack fluidStack = this.getTank().getFluid().copy();
                fluidStack.setAmount(Math.min(BlockMechanicalSqueezerConfig.autoEjectFluidRate, fluidStack.getAmount()));
                if (handler.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE) <= 0) continue;
                this.getTank().drain(handler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                break;
            }
        }
    }

    public boolean isAutoEjectFluids() {
        return this.autoEjectFluids;
    }

    public void setAutoEjectFluids(boolean autoEjectFluids) {
        this.autoEjectFluids = autoEjectFluids;
        this.sendUpdate();
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerMechanicalSqueezer(id, playerInventory, (IInventory)this.getInventory(), Optional.of(this));
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("block.integrateddynamics.mechanical_squeezer");
    }
}

