/*
 * Decompiled with CFR 0.152.
 */
package vice.magnesium_extras.mixins.performance;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.time.Duration;
import java.time.Instant;
import me.jellysquid.mods.sodium.client.gl.buffer.GlBuffer;
import me.jellysquid.mods.sodium.client.gl.buffer.GlBufferTarget;
import me.jellysquid.mods.sodium.client.gl.buffer.GlMutableBuffer;
import me.jellysquid.mods.sodium.client.gl.device.CommandList;
import me.jellysquid.mods.sodium.client.gl.device.DrawCommandList;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkCameraContext;
import me.jellysquid.mods.sodium.client.render.chunk.backends.multidraw.ChunkDrawCallBatcher;
import me.jellysquid.mods.sodium.client.render.chunk.backends.multidraw.IndirectCommandBufferVector;
import me.jellysquid.mods.sodium.client.render.chunk.backends.multidraw.MultidrawChunkRenderBackend;
import me.jellysquid.mods.sodium.client.render.chunk.backends.multidraw.MultidrawGraphicsState;
import me.jellysquid.mods.sodium.client.render.chunk.lists.ChunkRenderListIterator;
import me.jellysquid.mods.sodium.client.render.chunk.region.ChunkRegion;
import me.jellysquid.mods.sodium.client.render.chunk.region.ChunkRegionManager;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={MultidrawChunkRenderBackend.class})
public abstract class MultiDrawChunkRenderBackendMixin {
    @Shadow
    @Final
    private ChunkRegionManager<MultidrawGraphicsState> bufferManager;
    @Shadow
    @Final
    private GlMutableBuffer commandBuffer;
    @Shadow
    @Final
    private IndirectCommandBufferVector commandClientBufferBuilder;
    @Shadow
    @Final
    private ObjectArrayList<ChunkRegion<MultidrawGraphicsState>> pendingBatches;

    @Shadow
    protected abstract void setupDrawBatches(CommandList var1, ChunkRenderListIterator<MultidrawGraphicsState> var2, ChunkCameraContext var3);

    @Shadow
    protected abstract void buildCommandBuffer();

    @Overwrite(remap=false)
    public void render(CommandList commandList, ChunkRenderListIterator<MultidrawGraphicsState> renders, ChunkCameraContext camera) {
        this.bufferManager.cleanup();
        this.setupDrawBatches(commandList, renders, camera);
        this.buildCommandBuffer();
        if (this.commandBuffer != null) {
            commandList.bindBuffer(GlBufferTarget.DRAW_INDIRECT_BUFFER, (GlBuffer)this.commandBuffer);
            commandList.uploadData(this.commandBuffer, this.commandClientBufferBuilder.getBuffer());
        }
        long pointer = this.commandBuffer == null ? this.commandClientBufferBuilder.getBufferAddress() : 0L;
        Instant startedRender = Instant.now();
        for (ChunkRegion region : this.pendingBatches) {
            ChunkDrawCallBatcher batch = region.getDrawBatcher();
            try (DrawCommandList drawCommandList = commandList.beginTessellating(region.getTessellation());){
                drawCommandList.multiDrawArraysIndirect(pointer, batch.getCount(), 0);
            }
            pointer += (long)batch.getArrayLength();
            if (Duration.between(startedRender, Instant.now()).toMillis() <= 10L) continue;
            return;
        }
        this.pendingBatches.clear();
    }
}

