/*
 * Decompiled with CFR 0.152.
 */
package vice.magnesium_extras.util;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public abstract class DistanceUtility {
    public static boolean isNearPlayer(World world, BlockPos pos, int maxHeight, int maxDistanceSquare) {
        return DistanceUtility.isNearPlayerInternal(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), maxHeight, maxDistanceSquare, false);
    }

    private static boolean isNearPlayerInternal(World world, double posx, double posy, double posz, int maxHeight, int maxDistanceSquare, boolean allowNullPlayers) {
        List closest = world.func_217369_A();
        for (PlayerEntity player : closest) {
            double z;
            double x;
            boolean nearPlayer;
            if (player == null) {
                return allowNullPlayers;
            }
            if (!(Math.abs(player.func_226278_cu_() - posy) < (double)maxHeight) || !(nearPlayer = (x = player.func_226277_ct_() - posx) * x + (z = player.func_226281_cx_() - posz) * z < (double)maxDistanceSquare)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEntityWithinDistance(Entity player, Entity entity, int maxHeight, int maxDistanceSquare) {
        if (Math.abs(player.func_226278_cu_() - entity.func_226278_cu_() - 4.0) < (double)maxHeight) {
            double z;
            double x = player.func_226277_ct_() - entity.func_226277_ct_();
            return x * x + (z = player.func_226281_cx_() - entity.func_226281_cx_()) * z < (double)maxDistanceSquare;
        }
        return false;
    }

    public static boolean isEntityWithinDistance(BlockPos player, Vector3d entity, int maxHeight, int maxDistanceSquare) {
        if (Math.abs((double)player.func_177956_o() - entity.field_72448_b - 4.0) < (double)maxHeight) {
            double z;
            double x = (double)player.func_177958_n() - entity.field_72450_a;
            return x * x + (z = (double)player.func_177952_p() - entity.field_72449_c) * z < (double)maxDistanceSquare;
        }
        return false;
    }

    public static boolean isEntityWithinDistance(Entity player, double cameraX, double cameraY, double cameraZ, int maxHeight, int maxDistanceSquare) {
        if (Math.abs(player.func_226278_cu_() - cameraY - 4.0) < (double)maxHeight) {
            double z;
            double x = player.func_226277_ct_() - cameraX;
            return x * x + (z = player.func_226281_cx_() - cameraZ) * z < (double)maxDistanceSquare;
        }
        return false;
    }
}

