/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.starlight.common.light;

import ca.spottedleaf.starlight.common.blockstate.ExtendedAbstractBlockState;
import ca.spottedleaf.starlight.common.chunk.ExtendedChunk;
import ca.spottedleaf.starlight.common.chunk.ExtendedChunkSection;
import ca.spottedleaf.starlight.common.light.SWMRNibbleArray;
import ca.spottedleaf.starlight.common.light.StarLightEngine;
import ca.spottedleaf.starlight.common.light.VariableBlockLightHandler;
import ca.spottedleaf.starlight.common.util.WorldUtil;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import java.util.Arrays;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.IChunkLightProvider;

public final class SkyStarLightEngine
extends StarLightEngine {
    protected final int[] heightMapBlockChange = new int[256];
    protected final boolean[] nullPropagationCheckCache;
    protected final BlockPos.Mutable recalcCenterPos;
    protected final BlockPos.Mutable recalcNeighbourPos;
    protected final int[] heightMapGen;

    public SkyStarLightEngine(World world) {
        super(true, world);
        Arrays.fill(this.heightMapBlockChange, Integer.MIN_VALUE);
        this.recalcCenterPos = new BlockPos.Mutable();
        this.recalcNeighbourPos = new BlockPos.Mutable();
        this.heightMapGen = new int[1024];
        this.nullPropagationCheckCache = new boolean[WorldUtil.getTotalLightSections(world)];
    }

    @Override
    protected void initNibble(int chunkX, int chunkY, int chunkZ, boolean extrude, boolean initRemovedNibbles) {
        if (chunkY < this.minLightSection || chunkY > this.maxLightSection || this.getChunkInCache(chunkX, chunkZ) == null) {
            return;
        }
        SWMRNibbleArray nibble = this.getNibbleFromCache(chunkX, chunkY, chunkZ);
        if (nibble == null) {
            if (!initRemovedNibbles) {
                throw new IllegalStateException();
            }
            nibble = new SWMRNibbleArray(null, true);
            this.setNibbleInCache(chunkX, chunkY, chunkZ, nibble);
        }
        this.initNibble(nibble, chunkX, chunkY, chunkZ, extrude);
    }

    @Override
    protected void setNibbleNull(int chunkX, int chunkY, int chunkZ) {
        SWMRNibbleArray nibble = this.getNibbleFromCache(chunkX, chunkY, chunkZ);
        if (nibble != null) {
            nibble.setNull();
        }
    }

    protected final void initNibble(SWMRNibbleArray currNibble, int chunkX, int chunkY, int chunkZ, boolean extrude) {
        int currY;
        if (!currNibble.isNullNibbleUpdating()) {
            return;
        }
        boolean[] emptinessMap = this.getEmptinessMap(chunkX, chunkZ);
        int lowestY = this.minLightSection - 1;
        for (currY = this.maxSection; currY >= this.minSection; --currY) {
            ChunkSection current;
            if (emptinessMap == null ? (current = this.getChunkSection(chunkX, currY, chunkZ)) == null || current == EMPTY_CHUNK_SECTION : emptinessMap[currY - this.minSection]) continue;
            lowestY = currY;
            break;
        }
        if (chunkY > lowestY) {
            SWMRNibbleArray nibble = this.getNibbleFromCache(chunkX, chunkY, chunkZ);
            nibble.setNonNull();
            nibble.setFull();
            return;
        }
        if (extrude) {
            for (currY = chunkY + 1; currY <= this.maxLightSection; ++currY) {
                SWMRNibbleArray nibble = this.getNibbleFromCache(chunkX, currY, chunkZ);
                if (nibble == null || nibble.isNullNibbleUpdating()) continue;
                currNibble.setNonNull();
                currNibble.extrudeLower(nibble);
                break;
            }
        } else {
            currNibble.setNonNull();
        }
    }

    protected final void rewriteNibbleCacheForSkylight(IChunk chunk) {
        for (SWMRNibbleArray nibble : this.nibbleCache) {
            if (nibble == null || !nibble.isNullNibbleUpdating()) continue;
            this.nibbleCache[index] = null;
            nibble.updateVisible();
        }
    }

    protected final boolean checkNullSection(int chunkX, int chunkY, int chunkZ, boolean extrudeInitialised) {
        int dx;
        int dz;
        if (chunkY < this.minLightSection || chunkY > this.maxLightSection || this.nullPropagationCheckCache[chunkY - this.minLightSection]) {
            return false;
        }
        this.nullPropagationCheckCache[chunkY - this.minLightSection] = true;
        boolean needInitNeighbours = false;
        block0: for (dz = -1; dz <= 1; ++dz) {
            for (dx = -1; dx <= 1; ++dx) {
                SWMRNibbleArray nibble = this.getNibbleFromCache(dx + chunkX, chunkY, dz + chunkZ);
                if (nibble == null || nibble.isNullNibbleUpdating()) continue;
                needInitNeighbours = true;
                break block0;
            }
        }
        if (needInitNeighbours) {
            for (dz = -1; dz <= 1; ++dz) {
                for (dx = -1; dx <= 1; ++dx) {
                    this.initNibble(dx + chunkX, chunkY, dz + chunkZ, (dx | dz) == 0 ? extrudeInitialised : true, true);
                }
            }
        }
        return needInitNeighbours;
    }

    protected final int getLightLevelExtruded(int worldX, int worldY, int worldZ) {
        int chunkX = worldX >> 4;
        int chunkY = worldY >> 4;
        int chunkZ = worldZ >> 4;
        SWMRNibbleArray nibble = this.getNibbleFromCache(chunkX, chunkY, chunkZ);
        if (nibble != null) {
            return nibble.getUpdating(worldX, worldY, worldZ);
        }
        do {
            if (++chunkY <= this.maxLightSection) continue;
            return 15;
        } while ((nibble = this.getNibbleFromCache(chunkX, chunkY, chunkZ)) == null);
        return nibble.getUpdating(worldX, 0, worldZ);
    }

    @Override
    protected boolean[] getEmptinessMap(IChunk chunk) {
        return ((ExtendedChunk)chunk).getSkyEmptinessMap();
    }

    @Override
    protected void setEmptinessMap(IChunk chunk, boolean[] to) {
        ((ExtendedChunk)chunk).setSkyEmptinessMap(to);
    }

    @Override
    protected SWMRNibbleArray[] getNibblesOnChunk(IChunk chunk) {
        return ((ExtendedChunk)chunk).getSkyNibbles();
    }

    @Override
    protected void setNibbles(IChunk chunk, SWMRNibbleArray[] to) {
        ((ExtendedChunk)chunk).setSkyNibbles(to);
    }

    @Override
    protected boolean canUseChunk(IChunk chunk) {
        return chunk.func_201589_g().func_209003_a(ChunkStatus.field_222614_j) && (this.isClientSide || chunk.func_217310_r());
    }

    @Override
    protected void checkChunkEdges(IChunkLightProvider lightAccess, IChunk chunk, int fromSection, int toSection) {
        Arrays.fill(this.nullPropagationCheckCache, false);
        this.rewriteNibbleCacheForSkylight(chunk);
        int chunkX = chunk.func_76632_l().field_77276_a;
        int chunkZ = chunk.func_76632_l().field_77275_b;
        for (int y = toSection; y >= fromSection; --y) {
            this.checkNullSection(chunkX, y, chunkZ, true);
        }
        super.checkChunkEdges(lightAccess, chunk, fromSection, toSection);
    }

    @Override
    protected void checkChunkEdges(IChunkLightProvider lightAccess, IChunk chunk, ShortCollection sections) {
        Arrays.fill(this.nullPropagationCheckCache, false);
        this.rewriteNibbleCacheForSkylight(chunk);
        int chunkX = chunk.func_76632_l().field_77276_a;
        int chunkZ = chunk.func_76632_l().field_77275_b;
        ShortIterator iterator = sections.iterator();
        while (iterator.hasNext()) {
            short y = iterator.nextShort();
            this.checkNullSection(chunkX, y, chunkZ, true);
        }
        super.checkChunkEdges(lightAccess, chunk, sections);
    }

    @Override
    protected void checkBlock(IChunkLightProvider lightAccess, int worldX, int worldY, int worldZ) {
        int encodeOffset = this.coordinateOffset;
        int currentLevel = this.getLightLevel(worldX, worldY, worldZ);
        if (currentLevel == 15) {
            this.appendToIncreaseQueue((long)(worldX + (worldZ << 6) + (worldY << 12) + encodeOffset) & 0xFFFFFFFL | ((long)currentLevel & 0xFL) << 28 | 0x3F00000000L | Long.MIN_VALUE);
        } else {
            this.setLightLevel(worldX, worldY, worldZ, 0);
        }
        this.appendToDecreaseQueue((long)(worldX + (worldZ << 6) + (worldY << 12) + encodeOffset) & 0xFFFFFFFL | ((long)currentLevel & 0xFL) << 28 | 0x3F00000000L);
    }

    @Override
    protected int calculateLightValue(IChunkLightProvider lightAccess, int worldX, int worldY, int worldZ, int expect, VariableBlockLightHandler customBlockLight) {
        Object conditionallyOpaqueState;
        int opacity;
        if (expect == 15) {
            return expect;
        }
        int sectionOffset = this.chunkSectionIndexOffset;
        switch ((int)this.getKnownTransparency(worldX, worldY, worldZ)) {
            case 0: {
                opacity = 1;
                conditionallyOpaqueState = null;
                break;
            }
            case 1: {
                return 0;
            }
            case 2: {
                opacity = Math.max(1, ((ExtendedAbstractBlockState)this.getBlockState(worldX, worldY, worldZ)).getOpacityIfCached());
                conditionallyOpaqueState = null;
                if (opacity < 15) break;
                return 0;
            }
            default: {
                this.recalcCenterPos.func_181079_c(worldX, worldY, worldZ);
                BlockState state = this.getBlockState(worldX, worldY, worldZ);
                opacity = Math.max(1, state.func_200016_a(lightAccess.func_212864_k_(), (BlockPos)this.recalcCenterPos));
                conditionallyOpaqueState = ((ExtendedAbstractBlockState)state).isConditionallyFullOpaque() ? state : null;
            }
        }
        int level = 0;
        for (StarLightEngine.AxisDirection direction : AXIS_DIRECTIONS) {
            int calculated;
            int offX = worldX + direction.x;
            int offZ = worldZ + direction.z;
            int offY = worldY + direction.y;
            int sectionIndex = (offX >> 4) + 5 * (offZ >> 4) + 25 * (offY >> 4) + sectionOffset;
            int neighbourLevel = this.getLightLevel(sectionIndex, offX & 0xF | (offZ & 0xF) << 4 | (offY & 0xF) << 8);
            if (neighbourLevel - 1 <= level) continue;
            long neighbourOpacity = this.getKnownTransparency(sectionIndex, offY & 0xF | (offX & 0xF) << 4 | (offZ & 0xF) << 8);
            if (neighbourOpacity == 3L) {
                VoxelShape thisFace;
                BlockState neighbourState = this.getBlockState(offX, offY, offZ);
                this.recalcNeighbourPos.func_181079_c(offX, offY, offZ);
                VoxelShape neighbourFace = neighbourState.func_215702_a(lightAccess.func_212864_k_(), (BlockPos)this.recalcNeighbourPos, direction.opposite.nms);
                VoxelShape voxelShape = thisFace = conditionallyOpaqueState == null ? VoxelShapes.func_197880_a() : conditionallyOpaqueState.func_215702_a(lightAccess.func_212864_k_(), (BlockPos)this.recalcCenterPos, direction.nms);
                if (VoxelShapes.func_223416_b((VoxelShape)thisFace, (VoxelShape)neighbourFace)) continue;
            }
            if ((level = Math.max(calculated = neighbourLevel - opacity, level)) <= expect) continue;
            return level;
        }
        return level;
    }

    @Override
    protected void propagateBlockChanges(IChunkLightProvider lightAccess, IChunk atChunk, Set<BlockPos> positions) {
        this.rewriteNibbleCacheForSkylight(atChunk);
        Arrays.fill(this.nullPropagationCheckCache, false);
        IBlockReader world = lightAccess.func_212864_k_();
        int chunkX = atChunk.func_76632_l().field_77276_a;
        int chunkZ = atChunk.func_76632_l().field_77275_b;
        int heightMapOffset = chunkX * -16 + chunkZ * -256;
        for (BlockPos pos : positions) {
            int index = pos.func_177958_n() + (pos.func_177952_p() << 4) + heightMapOffset;
            int curr = this.heightMapBlockChange[index];
            if (pos.func_177956_o() <= curr) continue;
            this.heightMapBlockChange[index] = pos.func_177956_o();
        }
        block1: for (int index = 0; index < 256; ++index) {
            int maxY = this.heightMapBlockChange[index];
            if (maxY == Integer.MIN_VALUE) continue;
            this.heightMapBlockChange[index] = Integer.MIN_VALUE;
            int columnX = index & 0xF | chunkX << 4;
            int columnZ = index >>> 4 | chunkZ << 4;
            int maxPropagationY = this.tryPropagateSkylight(world, columnX, maxY, columnZ, true, true);
            long propagateDirection = StarLightEngine.AxisDirection.POSITIVE_Y.everythingButThisDirection;
            int encodeOffset = this.coordinateOffset;
            if (this.getLightLevelExtruded(columnX, maxPropagationY, columnZ) != 15) continue;
            this.checkNullSection(columnX >> 4, maxPropagationY >> 4, columnZ >> 4, true);
            for (int currY = maxPropagationY; currY >= this.minLightSection << 4; --currY) {
                SWMRNibbleArray nibble;
                if ((currY & 0xF) == 15) {
                    this.checkNullSection(columnX >> 4, currY >> 4, columnZ >> 4, true);
                }
                if ((nibble = this.getNibbleFromCache(columnX >> 4, currY >> 4, columnZ >> 4)) == null) {
                    currY &= 0xFFFFFFF0;
                    continue;
                }
                if (nibble.getUpdating(columnX, currY, columnZ) != 15) continue block1;
                this.appendToDecreaseQueue((long)(columnX + (columnZ << 6) + (currY << 12) + encodeOffset) & 0xFFFFFFFL | 0xF0000000L | propagateDirection << 32);
            }
        }
        this.processDelayedIncreases();
        this.processDelayedDecreases();
        for (BlockPos pos : positions) {
            this.checkBlock(lightAccess, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        this.performLightDecrease(lightAccess);
    }

    @Override
    protected void lightChunk(IChunkLightProvider lightAccess, IChunk chunk, boolean needsEdgeChecks) {
        this.rewriteNibbleCacheForSkylight(chunk);
        Arrays.fill(this.nullPropagationCheckCache, false);
        IBlockReader world = lightAccess.func_212864_k_();
        ChunkPos chunkPos = chunk.func_76632_l();
        int chunkX = chunkPos.field_77276_a;
        int chunkZ = chunkPos.field_77275_b;
        ChunkSection[] sections = chunk.func_76587_i();
        int highestNonEmptySection = this.maxSection;
        while (highestNonEmptySection == this.minSection - 1 || sections[highestNonEmptySection - this.minSection] == null || sections[highestNonEmptySection - this.minSection].func_76663_a()) {
            this.checkNullSection(chunkX, highestNonEmptySection, chunkZ, false);
            for (StarLightEngine.AxisDirection direction : ONLY_HORIZONTAL_DIRECTIONS) {
                int currY;
                int startZ;
                int startX;
                int incZ;
                int incX;
                int neighbourX = chunkX + direction.x;
                int neighbourZ = chunkZ + direction.z;
                SWMRNibbleArray neighbourNibble = this.getNibbleFromCache(neighbourX, highestNonEmptySection, neighbourZ);
                if (neighbourNibble == null) continue;
                if (direction.x != 0) {
                    incX = 0;
                    incZ = 1;
                    startX = direction.x < 0 ? chunkX << 4 : chunkX << 4 | 0xF;
                    startZ = chunkZ << 4;
                } else {
                    incX = 1;
                    incZ = 0;
                    startZ = direction.z < 0 ? chunkZ << 4 : chunkZ << 4 | 0xF;
                    startX = chunkX << 4;
                }
                int encodeOffset = this.coordinateOffset;
                long propagateDirection = 1L << direction.ordinal();
                int maxY = currY | 0xF;
                for (currY = highestNonEmptySection << 4; currY <= maxY; ++currY) {
                    int i = 0;
                    int currX = startX;
                    int currZ = startZ;
                    while (i < 16) {
                        this.appendToIncreaseQueue((long)(currX + (currZ << 6) + (currY << 12) + encodeOffset) & 0xFFFFFFFL | 0xF0000000L | propagateDirection << 32);
                        ++i;
                        currX += incX;
                        currZ += incZ;
                    }
                }
            }
            if (highestNonEmptySection-- != this.minSection - 1) continue;
        }
        if (highestNonEmptySection >= this.minSection) {
            int[] heightMap = this.heightMapGen;
            int worldChunkX = chunkPos.field_77276_a << 4;
            int worldChunkZ = chunkPos.field_77275_b << 4;
            int minX = worldChunkX - 1;
            int maxX = worldChunkX + 16;
            int minZ = worldChunkZ - 1;
            int maxZ = worldChunkZ + 16;
            for (int currZ = minZ; currZ <= maxZ; ++currZ) {
                for (int currX = minX; currX <= maxX; ++currX) {
                    int maxY = this.minLightSection - 1 << 4;
                    this.checkNullSection(currX >> 4, highestNonEmptySection, currZ >> 4, false);
                    this.checkNullSection(currX >> 4, highestNonEmptySection - 1, currZ >> 4, false);
                    for (int sectionY = highestNonEmptySection; sectionY >= 0; --sectionY) {
                        ChunkSection section = this.getChunkSection(currX >> 4, sectionY, currZ >> 4);
                        if (section == null) continue;
                        this.checkNullSection(currX >> 4, sectionY - 1, currZ >> 4, false);
                        long bitset = ((ExtendedChunkSection)section).getBitsetForColumn(currX & 0xF, currZ & 0xF);
                        if (bitset == 0L) continue;
                        int highestBitSet = 0x3F ^ Long.numberOfLeadingZeros(bitset);
                        int highestYValue = highestBitSet >>> 1;
                        maxY = highestYValue | sectionY << 4;
                        break;
                    }
                    heightMap[currX - worldChunkX + 1 | currZ - worldChunkZ + 1 << 5] = maxY;
                }
            }
            int encodeOffset = this.coordinateOffset;
            for (int currZ = 0; currZ <= 15; ++currZ) {
                for (int currX = 0; currX <= 15; ++currX) {
                    int worldX = currX | worldChunkX;
                    int worldZ = currZ | worldChunkZ;
                    int heightMapC = heightMap[currX + 1 | currZ + 1 << 5];
                    int heightMapNX = heightMap[currX - 1 + 1 | currZ + 1 << 5];
                    int heightMapPX = heightMap[currX + 1 + 1 | currZ + 1 << 5];
                    int heightMapNZ = heightMap[currX + 1 | currZ - 1 + 1 << 5];
                    int heightMapPZ = heightMap[currX + 1 | currZ + 1 + 1 << 5];
                    int currY = (highestNonEmptySection << 4) + 16;
                    while (currY > heightMapC) {
                        SWMRNibbleArray nibble = this.getNibbleFromCache(chunkX, currY >> 4, chunkZ);
                        if (nibble == null) {
                            currY = currY - 16 & 0xFFFFFFF0;
                            continue;
                        }
                        long propagateDirectionBitset = 0L;
                        propagateDirectionBitset |= (currY <= heightMapPX ? 1L : 0L) << StarLightEngine.AxisDirection.POSITIVE_X.ordinal();
                        propagateDirectionBitset |= (currY <= heightMapNX ? 1L : 0L) << StarLightEngine.AxisDirection.NEGATIVE_X.ordinal();
                        propagateDirectionBitset |= (currY <= heightMapPZ ? 1L : 0L) << StarLightEngine.AxisDirection.POSITIVE_Z.ordinal();
                        propagateDirectionBitset |= (currY <= heightMapNZ ? 1L : 0L) << StarLightEngine.AxisDirection.NEGATIVE_Z.ordinal();
                        long l = currY == heightMapC + 1 ? 1L : 0L;
                        nibble.set(worldX & 0xF | (worldZ & 0xF) << 4 | (currY & 0xF) << 8, 15);
                        if ((propagateDirectionBitset |= l << StarLightEngine.AxisDirection.NEGATIVE_Y.ordinal()) != 0L) {
                            this.appendToIncreaseQueue((long)(worldX + (worldZ << 6) + (currY << 12) + encodeOffset) & 0xFFFFFFFL | 0xF0000000L | propagateDirectionBitset << 32);
                        }
                        --currY;
                    }
                    this.tryPropagateSkylight(world, worldX, heightMapC, worldZ, false, false);
                }
            }
        }
        if (needsEdgeChecks) {
            this.performLightIncrease(lightAccess);
            for (int y = highestNonEmptySection; y >= this.minLightSection; --y) {
                this.checkNullSection(chunkX, y, chunkZ, false);
            }
            super.checkChunkEdges(lightAccess, chunk, this.minLightSection, highestNonEmptySection);
        } else {
            for (int y = highestNonEmptySection; y >= this.minLightSection; --y) {
                this.checkNullSection(chunkX, y, chunkZ, false);
            }
            this.propagateNeighbourLevels(lightAccess, chunk, this.minLightSection, highestNonEmptySection);
            this.performLightIncrease(lightAccess);
        }
    }

    protected final void processDelayedIncreases() {
        long[] queue = this.increaseQueue;
        int decodeOffsetX = -this.encodeOffsetX;
        int decodeOffsetY = -this.encodeOffsetY;
        int decodeOffsetZ = -this.encodeOffsetZ;
        int len = this.increaseQueueInitialLength;
        for (int i = 0; i < len; ++i) {
            long queueValue = queue[i];
            int posX = ((int)queueValue & 0x3F) + decodeOffsetX;
            int posZ = ((int)queueValue >>> 6 & 0x3F) + decodeOffsetZ;
            int posY = ((int)queueValue >>> 12 & 0xFFFF) + decodeOffsetY;
            int propagatedLightLevel = (int)(queueValue >>> 28 & 0xFL);
            this.setLightLevel(posX, posY, posZ, propagatedLightLevel);
        }
    }

    protected final void processDelayedDecreases() {
        long[] queue = this.decreaseQueue;
        int decodeOffsetX = -this.encodeOffsetX;
        int decodeOffsetY = -this.encodeOffsetY;
        int decodeOffsetZ = -this.encodeOffsetZ;
        int len = this.decreaseQueueInitialLength;
        for (int i = 0; i < len; ++i) {
            long queueValue = queue[i];
            int posX = ((int)queueValue & 0x3F) + decodeOffsetX;
            int posZ = ((int)queueValue >>> 6 & 0x3F) + decodeOffsetZ;
            int posY = ((int)queueValue >>> 12 & 0xFFFF) + decodeOffsetY;
            this.setLightLevel(posX, posY, posZ, 0);
        }
    }

    protected final int tryPropagateSkylight(IBlockReader world, int worldX, int startY, int worldZ, boolean extrudeInitialised, boolean delayLightSet) {
        BlockPos.Mutable mutablePos = this.mutablePos3;
        int encodeOffset = this.coordinateOffset;
        long propagateDirection = StarLightEngine.AxisDirection.POSITIVE_Y.everythingButThisDirection;
        if (this.getLightLevelExtruded(worldX, startY + 1, worldZ) != 15) {
            return startY;
        }
        this.checkNullSection(worldX >> 4, startY >> 4, worldZ >> 4, extrudeInitialised);
        BlockState above = this.getBlockState(worldX, startY + 1, worldZ);
        if (above == null) {
            above = AIR_BLOCK_STATE;
        }
        while (startY >= this.minLightSection << 4) {
            int opacityIfCached;
            VoxelShape fromShape;
            BlockState current;
            if ((startY & 0xF) == 15) {
                this.checkNullSection(worldX >> 4, startY >> 4, worldZ >> 4, extrudeInitialised);
            }
            if ((current = this.getBlockState(worldX, startY, worldZ)) == null) {
                current = AIR_BLOCK_STATE;
            }
            if (((ExtendedAbstractBlockState)above).isConditionallyFullOpaque()) {
                this.mutablePos2.func_181079_c(worldX, startY + 1, worldZ);
                fromShape = above.func_215702_a(world, (BlockPos)this.mutablePos2, StarLightEngine.AxisDirection.NEGATIVE_Y.nms);
                if (VoxelShapes.func_223416_b((VoxelShape)VoxelShapes.func_197880_a(), (VoxelShape)fromShape)) {
                    break;
                }
            } else {
                fromShape = VoxelShapes.func_197880_a();
            }
            if ((opacityIfCached = ((ExtendedAbstractBlockState)current).getOpacityIfCached()) != -1) {
                if (opacityIfCached != 0) break;
                this.appendToIncreaseQueue((long)(worldX + (worldZ << 6) + (startY << 12) + encodeOffset) & 0xFFFFFFFL | 0xF0000000L | propagateDirection << 32);
            } else {
                int opacity;
                mutablePos.func_181079_c(worldX, startY, worldZ);
                long flags = 0L;
                if (((ExtendedAbstractBlockState)current).isConditionallyFullOpaque()) {
                    VoxelShape cullingFace = current.func_215702_a(world, (BlockPos)mutablePos, StarLightEngine.AxisDirection.POSITIVE_Y.nms);
                    if (VoxelShapes.func_223416_b((VoxelShape)fromShape, (VoxelShape)cullingFace)) break;
                    flags |= Long.MIN_VALUE;
                }
                if ((opacity = current.func_200016_a(world, (BlockPos)mutablePos)) > 0) break;
                this.appendToIncreaseQueue((long)(worldX + (worldZ << 6) + (startY << 12) + encodeOffset) & 0xFFFFFFFL | 0xF0000000L | propagateDirection << 32 | flags);
            }
            above = current;
            if (this.getNibbleFromCache(worldX >> 4, startY >> 4, worldZ >> 4) == null) {
                --this.increaseQueueInitialLength;
                startY &= 0xFFFFFFF0;
                above = AIR_BLOCK_STATE;
            } else if (!delayLightSet) {
                this.setLightLevel(worldX, startY, worldZ, 15);
            }
            --startY;
        }
        return startY;
    }
}

