/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.starlight.common.light;

import ca.spottedleaf.starlight.common.light.VariableBlockLightHandler;
import ca.spottedleaf.starlight.common.util.CoordinateUtils;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.StampedLock;
import net.minecraft.util.math.BlockPos;

public class VariableBlockLightHandlerImpl
implements VariableBlockLightHandler {
    protected final Long2ObjectOpenHashMap<Set<BlockPos>> positionsByChunk = new Long2ObjectOpenHashMap();
    protected final Long2IntOpenHashMap lightValuesByPosition = new Long2IntOpenHashMap();
    protected final StampedLock seqlock = new StampedLock();

    public VariableBlockLightHandlerImpl() {
        this.lightValuesByPosition.defaultReturnValue(-1);
        this.positionsByChunk.defaultReturnValue(Collections.emptySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLightLevel(int x, int y, int z) {
        long key = CoordinateUtils.getBlockKey(x, y, z);
        try {
            long attempt = this.seqlock.tryOptimisticRead();
            if (attempt != 0L) {
                int ret = this.lightValuesByPosition.get(key);
                if (this.seqlock.validate(attempt)) {
                    return ret;
                }
            }
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.seqlock.readLock();
        try {
            int n = this.lightValuesByPosition.get(key);
            return n;
        }
        finally {
            this.seqlock.tryUnlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<BlockPos> getCustomLightPositions(int chunkX, int chunkZ) {
        long key = CoordinateUtils.getChunkKey(chunkX, chunkZ);
        try {
            long attempt = this.seqlock.tryOptimisticRead();
            if (attempt != 0L) {
                HashSet<BlockPos> ret = new HashSet<BlockPos>((Collection)this.positionsByChunk.get(key));
                if (this.seqlock.validate(attempt)) {
                    return ret;
                }
            }
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.seqlock.readLock();
        try {
            HashSet<BlockPos> hashSet = new HashSet<BlockPos>((Collection)this.positionsByChunk.get(key));
            return hashSet;
        }
        finally {
            this.seqlock.tryUnlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSource(int x, int y, int z, int to) {
        if (to < 0 || to > 15) {
            throw new IllegalArgumentException();
        }
        this.seqlock.writeLock();
        try {
            if (this.lightValuesByPosition.put(CoordinateUtils.getBlockKey(x, y, z), to) == -1) {
                ((Set)this.positionsByChunk.computeIfAbsent(CoordinateUtils.getChunkKey(x >> 4, z >> 4), keyInMap -> new HashSet())).add(new BlockPos(x, y, z));
            }
        }
        finally {
            this.seqlock.tryUnlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeSource(int x, int y, int z) {
        this.seqlock.writeLock();
        try {
            int ret = this.lightValuesByPosition.remove(CoordinateUtils.getBlockKey(x, y, z));
            if (ret != -1) {
                long chunkKey = CoordinateUtils.getChunkKey(x >> 4, z >> 4);
                Set positions = (Set)this.positionsByChunk.get(chunkKey);
                positions.remove(new BlockPos(x, y, z));
                if (positions.isEmpty()) {
                    this.positionsByChunk.remove(chunkKey);
                }
            }
            int n = ret;
            return n;
        }
        finally {
            this.seqlock.tryUnlockWrite();
        }
    }
}

