/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.basemod;

import com.github.lehjr.numina.basemod.NuminaObjects;
import com.github.lehjr.numina.client.gui.ArmorStandGui;
import com.github.lehjr.numina.client.gui.ChargingBaseGui;
import com.github.lehjr.numina.config.ConfigHelper;
import com.github.lehjr.numina.config.NuminaSettings;
import com.github.lehjr.numina.entity.NuminaArmorStandEntity;
import com.github.lehjr.numina.event.EventBusHelper;
import com.github.lehjr.numina.event.LogoutEventHandler;
import com.github.lehjr.numina.event.PlayerUpdateHandler;
import com.github.lehjr.numina.network.NuminaPackets;
import com.github.lehjr.numina.recipe.RecipeSerializersRegistry;
import com.github.lehjr.numina.util.capabilities.heat.HeatCapability;
import com.github.lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import com.github.lehjr.numina.util.capabilities.player.CapabilityPlayerKeyStates;
import com.github.lehjr.numina.util.capabilities.render.ModelSpecNBTCapability;
import com.github.lehjr.numina.util.capabilities.render.colour.ColourCapability;
import com.github.lehjr.numina.util.client.NuminaSpriteUploader;
import com.github.lehjr.numina.util.client.event.ArmorLayerSetup;
import com.github.lehjr.numina.util.client.event.FOVUpdateEventHandler;
import com.github.lehjr.numina.util.client.event.ToolTipEvent;
import com.github.lehjr.numina.util.client.gui.GuiIcon;
import com.github.lehjr.numina.util.client.render.MuseIconUtils;
import com.github.lehjr.numina.util.client.render.RenderGameOverlayEventHandler;
import forge.NuminaOBJLoader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="numina")
public class Numina {
    public Numina() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, NuminaSettings.CLIENT_SPEC, ConfigHelper.setupConfigFile("numina-client-only.toml", "numina").getAbsolutePath());
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, NuminaSettings.SERVER_SPEC);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::doClientStuff);
        MinecraftForge.EVENT_BUS.register((Object)this);
        NuminaObjects.ITEMS.register(modEventBus);
        NuminaObjects.BLOCKS.register(modEventBus);
        NuminaObjects.TILE_TYPES.register(modEventBus);
        NuminaObjects.ENTITY_TYPES.register(modEventBus);
        NuminaObjects.CONTAINER_TYPES.register(modEventBus);
        RecipeSerializersRegistry.RECIPE_SERIALIZERS.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)new LogoutEventHandler());
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> Numina.clientStart(modEventBus));
        modEventBus.addListener(event -> {
            new RuntimeException("Got config " + event.getConfig() + " name " + event.getConfig().getModId() + ":" + event.getConfig().getFileName());
            ModConfig config = event.getConfig();
            if (config.getSpec() == NuminaSettings.SERVER_SPEC) {
                NuminaSettings.getModuleConfig().setServerConfig(config);
            }
        });
    }

    private static void clientStart(IEventBus modEventBus) {
        if (Minecraft.func_71410_x() != null) {
            ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("numina", "obj"), (IModelLoader)NuminaOBJLoader.INSTANCE);
        }
        EventBusHelper.addListener(Numina.class, modEventBus, ColorHandlerEvent.Block.class, setupEvent -> {
            NuminaSpriteUploader iconUploader = new NuminaSpriteUploader();
            GuiIcon icons = new GuiIcon(iconUploader);
            IResourceManager resourceManager = Minecraft.func_71410_x().func_195551_G();
            if (resourceManager instanceof IReloadableResourceManager) {
                IReloadableResourceManager reloadableResourceManager = (IReloadableResourceManager)resourceManager;
                reloadableResourceManager.func_219534_a((IFutureReloadListener)iconUploader);
            }
            EventBusHelper.addLifecycleListener(Numina.class, modEventBus, FMLLoadCompleteEvent.class, loadCompleteEvent -> MuseIconUtils.setIconInstance(icons));
        });
    }

    private void setup(FMLCommonSetupEvent event) {
        NuminaPackets.registerNuminaPackets();
        HeatCapability.register();
        ColourCapability.register();
        PowerModuleCapability.register();
        ModelSpecNBTCapability.register();
        CapabilityPlayerKeyStates.register();
        MinecraftForge.EVENT_BUS.register((Object)new PlayerUpdateHandler());
        DeferredWorkQueue.runLater(() -> GlobalEntityTypeAttributes.put((EntityType)((EntityType)NuminaObjects.ARMOR_WORKSTATION__ENTITY_TYPE.get()), (AttributeModifierMap)NuminaArmorStandEntity.setCustomAttributes().func_233813_a_()));
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new FOVUpdateEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new RenderGameOverlayEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ToolTipEvent());
        ScreenManager.func_216911_a((ContainerType)((ContainerType)NuminaObjects.CHARGING_BASE_CONTAINER_TYPE.get()), ChargingBaseGui::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)NuminaObjects.ARMOR_STAND_CONTAINER_TYPE.get()), ArmorStandGui::new);
    }

    @SubscribeEvent
    public void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (!(event.getObject() instanceof PlayerEntity)) {
            return;
        }
        event.addCapability(new ResourceLocation("numina", "player_keystates"), (ICapabilityProvider)new CapabilityPlayerKeyStates());
    }

    @Mod.EventBusSubscriber(modid="numina", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class MyStaticClientOnlyEventHandler {
        @SubscribeEvent
        public static void loadComplete(FMLLoadCompleteEvent evt) {
            ArmorLayerSetup.loadComplete(evt);
        }
    }
}

