/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.client.model.item.armor;

import com.github.lehjr.numina.client.model.item.armor.ArmorModelInstance;
import com.github.lehjr.numina.util.capabilities.render.modelspec.ModelPartSpec;
import com.github.lehjr.numina.util.capabilities.render.modelspec.ModelRegistry;
import com.github.lehjr.numina.util.capabilities.render.modelspec.ModelSpec;
import com.github.lehjr.numina.util.capabilities.render.modelspec.PartSpecBase;
import com.github.lehjr.numina.util.math.Colour;
import com.github.lehjr.numina.util.nbt.NBTTagAccessor;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.model.TransformationHelper;
import org.lwjgl.system.MemoryStack;

@OnlyIn(value=Dist.CLIENT)
public class RenderPart
extends ModelRenderer {
    final float div255 = 0.003921569f;
    ModelRenderer parent;

    public RenderPart(Model base, ModelRenderer parent) {
        super(base);
        this.parent = parent;
    }

    public void func_228309_a_(MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (this.field_78806_j) {
            matrixStackIn.func_227860_a_();
            this.func_228307_a_(matrixStackIn);
            this.doRendering(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            matrixStackIn.func_227865_b_();
        }
    }

    public void func_228307_a_(MatrixStack matrixStackIn) {
        matrixStackIn.func_227861_a_((double)(this.field_78800_c * 0.0625f), (double)(this.field_78797_d * 0.0625f), (double)(this.field_78798_e * 0.0625f));
        if (this.field_78808_h != 0.0f) {
            matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229193_c_(this.field_78808_h));
        }
        if (this.field_78796_g != 0.0f) {
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(this.field_78796_g));
        }
        if (this.field_78795_f != 0.0f) {
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_(this.field_78795_f));
        }
        matrixStackIn.func_227863_a_(TransformationHelper.quatFromXYZ((Vector3f)new Vector3f(180.0f, 0.0f, 0.0f), (boolean)true));
    }

    private void doRendering(MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        CompoundNBT renderSpec = ArmorModelInstance.getInstance().getRenderSpec();
        if (renderSpec != null) {
            MatrixStack.Entry entry = matrixStackIn.func_227866_c_();
            int[] colours = renderSpec.func_74759_k("colours");
            if (colours.length == 0) {
                colours = new int[]{Colour.WHITE.getInt()};
            }
            for (CompoundNBT nbt : NBTTagAccessor.getValues(renderSpec)) {
                PartSpecBase part = ModelRegistry.getInstance().getPart(nbt);
                if (part == null || !(part instanceof ModelPartSpec) || part.getBinding().getSlot() != ArmorModelInstance.getInstance().getVisibleSection() || part.getBinding().getTarget().apply(ArmorModelInstance.getInstance()) != this.parent) continue;
                int ix = part.getColourIndex(nbt);
                int partColor = ix < colours.length && ix >= 0 ? colours[ix] : -1;
                TransformationMatrix transform = ((ModelSpec)part.spec).getTransform(ItemCameraTransforms.TransformType.NONE);
                if (transform != TransformationMatrix.func_227983_a_()) {
                    MatrixStack stack = new MatrixStack();
                    transform.push(stack);
                    Matrix4f tMat = stack.func_227866_c_().func_227870_a_();
                    Matrix3f nMat = stack.func_227866_c_().func_227872_b_();
                    matrixStackIn.func_227866_c_().func_227870_a_().func_226595_a_(tMat);
                    matrixStackIn.func_227866_c_().func_227872_b_().func_226118_b_(nMat);
                }
                ImmutableList.Builder builder = ImmutableList.builder();
                Random random = new Random();
                long i = 42L;
                random.setSeed(i);
                builder.addAll((Iterable)((ModelPartSpec)part).getPart().func_200117_a(null, null, random));
                this.renderQuads(entry, bufferIn, (List<BakedQuad>)builder.build(), ((ModelPartSpec)part).getGlow() ? 0xF000F0 : packedLightIn, OverlayTexture.field_229196_a_, partColor);
            }
        }
    }

    public void renderQuads(MatrixStack.Entry entry, IVertexBuilder bufferIn, List<BakedQuad> quadsIn, int combinedLightIn, int combinedOverlayIn, int colour) {
        float a = (float)(colour >> 24 & 0xFF) * 0.003921569f;
        float r = (float)(colour >> 16 & 0xFF) * 0.003921569f;
        float g = (float)(colour >> 8 & 0xFF) * 0.003921569f;
        float b = (float)(colour & 0xFF) * 0.003921569f;
        for (BakedQuad bakedquad : quadsIn) {
            this.addVertexData(bufferIn, entry, bakedquad, combinedLightIn, combinedOverlayIn, r, g, b, a);
        }
    }

    void addVertexData(IVertexBuilder bufferIn, MatrixStack.Entry matrixEntry, BakedQuad bakedQuad, int lightmapCoordIn, int overlayCoords, float red, float green, float blue, float alpha) {
        int[] aint = bakedQuad.func_178209_a();
        Vector3i faceNormal = bakedQuad.func_178210_d().func_176730_m();
        Vector3f normal = new Vector3f((float)faceNormal.func_177958_n(), (float)faceNormal.func_177956_o(), (float)faceNormal.func_177952_p());
        Matrix4f matrix4f = matrixEntry.func_227870_a_();
        normal.func_229188_a_(matrixEntry.func_227872_b_());
        int intSize = DefaultVertexFormats.field_176600_a.func_181719_f();
        int vertexCount = aint.length / intSize;
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            ByteBuffer bytebuffer = memorystack.malloc(DefaultVertexFormats.field_176600_a.func_177338_f());
            IntBuffer intbuffer = bytebuffer.asIntBuffer();
            for (int v = 0; v < vertexCount; ++v) {
                ((Buffer)intbuffer).clear();
                intbuffer.put(aint, v * 8, 8);
                float f = bytebuffer.getFloat(0);
                float f1 = bytebuffer.getFloat(4);
                float f2 = bytebuffer.getFloat(8);
                int lightmapCoord = bufferIn.applyBakedLighting(lightmapCoordIn, bytebuffer);
                float f9 = bytebuffer.getFloat(16);
                float f10 = bytebuffer.getFloat(20);
                Vector4f pos = new Vector4f(f * 0.0625f, f1 * 0.0625f, f2 * 0.0625f, 1.0f);
                pos.func_229372_a_(matrix4f);
                bufferIn.applyBakedNormals(normal, bytebuffer, matrixEntry.func_227872_b_());
                bufferIn.func_225588_a_(pos.func_195910_a(), pos.func_195913_b(), pos.func_195914_c(), red, green, blue, alpha, f9, f10, overlayCoords, lightmapCoord, normal.func_195899_a(), normal.func_195900_b(), normal.func_195902_c());
            }
        }
    }
}

