/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.client.render.item;

import com.github.lehjr.numina.constants.NuminaConstants;
import com.github.lehjr.numina.util.client.model.helper.ModelHelper;
import com.github.lehjr.numina.util.client.model.obj.OBJBakedCompositeModel;
import com.github.lehjr.numina.util.client.render.MuseIconUtils;
import com.github.lehjr.numina.util.math.Colour;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.util.NonNullLazy;

public class PlasmaBallTestRenderer
extends ItemStackTileEntityRenderer {
    static final Colour colour1 = new Colour(0.3f, 0.3f, 1.0f, 0.3f);
    static final Colour colour2 = new Colour(0.4f, 0.4f, 1.0f, 0.5f);
    static final Colour colour3 = new Colour(0.8f, 0.8f, 1.0f, 0.7f);
    static final Colour colour4 = new Colour(1.0f, 1.0f, 1.0f, 0.9f);
    static final ResourceLocation modelLocation = new ResourceLocation("numina", "models/item/test/sphere.obj");
    public static final NonNullLazy<OBJBakedCompositeModel> modelSphere = NonNullLazy.of(() -> ModelHelper.loadBakedModel((IModelTransform)ModelRotation.X0_Y0, null, modelLocation));
    protected final Random rand = new Random();
    float size = 50.0f;

    public void func_239207_a_(ItemStack stack, ItemCameraTransforms.TransformType transformType, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLight, int combinedOverlay) {
        this.renderAsItem(matrixStackIn, bufferIn, this.size, transformType);
    }

    public void renderAsItem(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, float boltSizeIn, ItemCameraTransforms.TransformType cameraTransformTypeIn) {
        if (boltSizeIn != 0.0f) {
            matrixStackIn.func_227860_a_();
            if (cameraTransformTypeIn == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND || cameraTransformTypeIn == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND) {
                matrixStackIn.func_227862_a_(0.0625f, 0.0625f, 0.0625f);
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-182.0f));
            } else {
                matrixStackIn.func_227862_a_(0.0625f, 0.0625f, 0.0625f);
                matrixStackIn.func_227861_a_(0.0, 0.0, (double)20.3f);
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-196.0f));
            }
            matrixStackIn.func_227861_a_(-1.0, 1.0, 16.0);
            matrixStackIn.func_227860_a_();
            this.renderPlasma(matrixStackIn, bufferIn, boltSizeIn);
            matrixStackIn.func_227865_b_();
            matrixStackIn.func_227865_b_();
        }
    }

    public void renderPlasma(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, float size) {
        matrixStackIn.func_227860_a_();
        float scalFactor = 3.0f;
        float scale = size / 16.0f;
        matrixStackIn.func_227862_a_(scale, scale, scale);
        for (int i = 0; i < 9; ++i) {
            double angle1 = Math.random() * 2.0 * Math.PI;
            double angle2 = Math.random() * 2.0 * Math.PI;
            double angle3 = Math.random() * 2.0 * Math.PI;
            MuseIconUtils.getIcon().lightning.drawLightning(bufferIn, matrixStackIn, (float)(Math.cos(angle1) * 0.5), (float)(Math.sin(angle1) * 0.5), (float)(Math.cos(angle3) * 0.5), (float)(Math.cos(angle2) * 5.0), (float)(Math.sin(angle2) * 5.0), (float)(Math.sin(angle3) * 5.0), new Colour(1.0f, 1.0f, 1.0f, 0.9f));
        }
        int millisPerCycle = 500;
        double timeScale = Math.cos((double)(System.currentTimeMillis() % (long)millisPerCycle) * 2.0 / (double)millisPerCycle - 1.0);
        this.renderPlasmaBall(matrixStackIn, bufferIn, 4.0f * scalFactor, colour1.withAlpha(0.15f));
        this.renderPlasmaBall(matrixStackIn, bufferIn, (float)(3.0 + timeScale / 2.0) * scalFactor, colour2.withAlpha(0.25f));
        this.renderPlasmaBall(matrixStackIn, bufferIn, (float)(2.0 + timeScale) * scalFactor, colour3.withAlpha(0.4f));
        this.renderPlasmaBall(matrixStackIn, bufferIn, (float)(1.0 + timeScale) * scalFactor, colour4.withAlpha(0.75f));
        matrixStackIn.func_227865_b_();
    }

    private RenderType getSphereRenderType() {
        return RenderType.func_228642_d_((ResourceLocation)NuminaConstants.TEXTURE_WHITE);
    }

    void renderPlasmaBall(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, float scale, Colour colour) {
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.5, 0.5, 0.5);
        matrixStackIn.func_227862_a_(scale, scale, scale);
        this.renderSphere(bufferIn, this.getSphereRenderType(), matrixStackIn, 0xF000F0, colour);
        matrixStackIn.func_227865_b_();
    }

    public void renderSphere(IRenderTypeBuffer bufferIn, RenderType rt, MatrixStack matrixStackIn, int packedLightIn, Colour colour) {
        this.renderSphere(bufferIn, rt, matrixStackIn, packedLightIn, OverlayTexture.field_229196_a_, colour);
    }

    public void renderSphere(IRenderTypeBuffer bufferIn, RenderType rt, MatrixStack matrixStackIn, int packedLightIn, int overlay, Colour colour) {
        IVertexBuilder bb = bufferIn.getBuffer(rt);
        for (BakedQuad quad : ((OBJBakedCompositeModel)modelSphere.get()).getQuads(null, null, this.rand, (IModelData)EmptyModelData.INSTANCE)) {
            bb.addVertexData(matrixStackIn.func_227866_c_(), quad, colour.r, colour.g, colour.b, colour.a, packedLightIn, overlay, true);
        }
    }
}

