/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.container;

import com.github.lehjr.numina.basemod.NuminaObjects;
import com.github.lehjr.numina.capabilities.TileEnergyStorage;
import com.github.lehjr.numina.tileentity.ChargingBaseTileEntity;
import com.github.lehjr.numina.util.client.gui.slot.IIConProvider;
import com.github.lehjr.numina.util.client.render.MuseIconUtils;
import com.github.lehjr.numina.util.math.Colour;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class ChargingBaseContainer
extends Container {
    private TileEntity tileEntity;
    private PlayerEntity playerEntity;
    private IItemHandler playerInventory;

    public ChargingBaseContainer(int windowId, World world, BlockPos pos, PlayerInventory playerInventory, PlayerEntity player) {
        super((ContainerType)NuminaObjects.CHARGING_BASE_CONTAINER_TYPE.get(), windowId);
        int col;
        this.tileEntity = world.func_175625_s(pos);
        this.playerEntity = player;
        this.playerInventory = new InvWrapper((IInventory)playerInventory);
        if (this.tileEntity != null) {
            this.tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> this.func_75146_a((Slot)new IconSlot((IItemHandler)h, 0, 64, 24){

                @Override
                public void drawIconAt(MatrixStack matrixStack, double posX, double posY, Colour colour) {
                    MuseIconUtils.getIcon().energyStorageBackground.renderIconScaledWithColour(matrixStack, posX, posY, 16.0, 16.0, Colour.WHITE);
                }
            }));
        }
        for (int row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)playerInventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (col = 0; col < 9; ++col) {
            this.func_75146_a(new Slot((IInventory)playerInventory, col, 8 + col * 180, 142));
        }
        this.trackPower();
    }

    private void trackPower() {
        this.func_216958_a(new IntReferenceHolder(){

            public int func_221495_b() {
                return ChargingBaseContainer.this.getTileEnergy() & 0xFFFF;
            }

            public void func_221494_a(int value) {
                if (ChargingBaseContainer.this.tileEntity instanceof ChargingBaseTileEntity) {
                    ((ChargingBaseTileEntity)ChargingBaseContainer.this.tileEntity).getTileEnergyHandler().ifPresent(h -> {
                        int energyStored = h.getEnergyStored() & 0xFFFF0000;
                        ((TileEnergyStorage)((Object)h)).setEnergy(energyStored + (value & 0xFFFF));
                    });
                }
            }
        });
        this.func_216958_a(new IntReferenceHolder(){

            public int func_221495_b() {
                return ChargingBaseContainer.this.getTileEnergy() >> 16 & 0xFFFF;
            }

            public void func_221494_a(int value) {
                if (ChargingBaseContainer.this.tileEntity instanceof ChargingBaseTileEntity) {
                    ((ChargingBaseTileEntity)ChargingBaseContainer.this.tileEntity).getTileEnergyHandler().ifPresent(h -> {
                        int energyStored = h.getEnergyStored() & 0xFFFF;
                        ((TileEnergyStorage)((Object)h)).setEnergy(energyStored | value << 16);
                    });
                }
            }
        });
    }

    public int getEnergy() {
        return this.tileEntity.getCapability(CapabilityEnergy.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0);
    }

    public int getMaxEnergy() {
        return this.tileEntity.getCapability(CapabilityEnergy.ENERGY).map(IEnergyStorage::getMaxEnergyStored).orElse(0);
    }

    public float getEnergyForMeter() {
        return this.tileEntity.getCapability(CapabilityEnergy.ENERGY).map(energy -> Float.valueOf((float)energy.getEnergyStored() / (float)energy.getMaxEnergyStored())).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public int getTileEnergy() {
        return this.tileEntity instanceof ChargingBaseTileEntity ? ((ChargingBaseTileEntity)this.tileEntity).getTileEnergyHandler().map(IEnergyStorage::getEnergyStored).orElse(0) : 0;
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return ChargingBaseContainer.func_216963_a((IWorldPosCallable)IWorldPosCallable.func_221488_a((World)this.tileEntity.func_145831_w(), (BlockPos)this.tileEntity.func_174877_v()), (PlayerEntity)this.playerEntity, (Block)((Block)NuminaObjects.CHARGING_BASE_BLOCK.get()));
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            itemstack = stack.func_77946_l();
            if (index == 0) {
                if (!this.func_75135_a(stack, 1, 37, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(stack, itemstack);
            } else if (this.tileEntity != null && this.tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(h -> h.isItemValid(0, stack)).orElse(false) != false ? !this.func_75135_a(stack, 0, 1, false) : (index < 28 ? !this.func_75135_a(stack, 28, 37, false) : index < 37 && !this.func_75135_a(stack, 1, 28, false))) {
                return ItemStack.field_190927_a;
            }
            if (stack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (stack.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, stack);
        }
        return itemstack;
    }

    abstract class IconSlot
    extends SlotItemHandler
    implements IIConProvider {
        public IconSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }
    }
}

