/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.event;

import com.github.lehjr.numina.basemod.MuseLogger;
import com.github.lehjr.numina.util.capabilities.inventory.modechanging.IModeChangingItem;
import com.github.lehjr.numina.util.capabilities.inventory.modularitem.IModularItem;
import com.github.lehjr.numina.util.heat.MuseHeatUtils;
import com.github.lehjr.numina.util.player.PlayerUtils;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.NonNullList;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.CapabilityItemHandler;

public class PlayerUpdateHandler {
    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onPlayerUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity() instanceof PlayerEntity) {
            double currHeat;
            PlayerEntity player = (PlayerEntity)event.getEntity();
            NonNullList modularItems = NonNullList.func_191196_a();
            block6: for (EquipmentSlotType slot : EquipmentSlotType.values()) {
                if (player.func_184582_a(slot).func_190926_b()) continue;
                switch (slot.func_188453_a()) {
                    case HAND: {
                        player.func_184582_a(slot).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModeChangingItem.class::isInstance).map(IModeChangingItem.class::cast).ifPresent(i -> {
                            i.tick(player);
                            modularItems.add((Object)i.getModularItemStack());
                        });
                        continue block6;
                    }
                    case ARMOR: {
                        try {
                            player.func_184582_a(slot).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModularItem.class::isInstance).map(IModularItem.class::cast).ifPresent(i -> {
                                i.tick(player);
                                modularItems.add((Object)i.getModularItemStack());
                            });
                            continue block6;
                        }
                        catch (Exception exception) {
                            MuseLogger.logException(player.func_184582_a(slot).toString(), exception);
                        }
                    }
                }
            }
            if (modularItems.size() > 0 && (currHeat = MuseHeatUtils.getPlayerHeat((LivingEntity)player)) >= 0.0 && !player.field_70170_p.field_72995_K) {
                double maxHeat;
                double coolPlayerAmount = (double)PlayerUtils.getPlayerCoolingBasedOnMaterial(player) * 0.55;
                if (coolPlayerAmount > 0.0) {
                    MuseHeatUtils.coolPlayer((LivingEntity)player, coolPlayerAmount);
                }
                if (currHeat < (maxHeat = MuseHeatUtils.getPlayerMaxHeat((LivingEntity)player)) * 0.95) {
                    player.func_70066_B();
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void entityAttackEventHandler(LivingAttackEvent event) {
        if (event.getSource() == MuseHeatUtils.overheatDamage) {
            return;
        }
        if (event.getSource().func_76347_k()) {
            MuseHeatUtils.heatEntity(event);
        }
    }
}

