/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.network.packets;

import com.github.lehjr.numina.util.capabilities.render.ModelSpecNBTCapability;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class CosmeticInfoPacket {
    protected EquipmentSlotType slotType;
    protected String tagName;
    protected CompoundNBT tagData;

    public CosmeticInfoPacket() {
    }

    public CosmeticInfoPacket(EquipmentSlotType slotType, String tagName, CompoundNBT tagData) {
        this.slotType = slotType;
        this.tagName = tagName;
        this.tagData = tagData;
    }

    public static void encode(CosmeticInfoPacket msg, PacketBuffer packetBuffer) {
        packetBuffer.func_179249_a((Enum)msg.slotType);
        packetBuffer.func_180714_a(msg.tagName);
        packetBuffer.func_150786_a(msg.tagData);
    }

    public static CosmeticInfoPacket decode(PacketBuffer packetBuffer) {
        return new CosmeticInfoPacket((EquipmentSlotType)packetBuffer.func_179257_a(EquipmentSlotType.class), packetBuffer.func_150789_c(500), packetBuffer.func_150793_b());
    }

    public static void handle(CosmeticInfoPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            EquipmentSlotType slotType = message.slotType;
            String tagName = message.tagName;
            CompoundNBT tagData = message.tagData;
            player.func_184582_a(slotType).getCapability(ModelSpecNBTCapability.RENDER).ifPresent(render -> render.setRenderTag(tagData, tagName));
            player.field_71071_by.func_70296_d();
        });
        ctx.get().setPacketHandled(true);
    }
}

