/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.network.packets;

import com.github.lehjr.numina.util.capabilities.inventory.modularitem.IModularItem;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.items.CapabilityItemHandler;

public class ToggleRequestPacket {
    ResourceLocation registryName;
    boolean toggleval;

    public ToggleRequestPacket(ResourceLocation registryName, boolean active) {
        this.registryName = registryName;
        this.toggleval = active;
    }

    public static void encode(ToggleRequestPacket msg, PacketBuffer packetBuffer) {
        packetBuffer.func_180714_a(msg.registryName.toString());
        packetBuffer.writeBoolean(msg.toggleval);
    }

    public static ToggleRequestPacket decode(PacketBuffer packetBuffer) {
        return new ToggleRequestPacket(new ResourceLocation(packetBuffer.func_150789_c(500)), packetBuffer.readBoolean());
    }

    public static void handle(ToggleRequestPacket message, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayerEntity player = ctx.get().getSender();
        if (player == null || player.func_184102_h() == null) {
            return;
        }
        ctx.get().enqueueWork(() -> {
            ResourceLocation registryName = message.registryName;
            boolean toggleval = message.toggleval;
            if (player == null) {
                return;
            }
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                player.field_71071_by.func_70301_a(i).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModularItem.class::isInstance).map(IModularItem.class::cast).ifPresent(handler -> handler.toggleModule(registryName, toggleval));
            }
            player.field_71071_by.func_70296_d();
        });
        ctx.get().setPacketHandled(true);
    }
}

