/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.capabilities.energy;

import com.github.lehjr.numina.util.capabilities.energy.IEnergyWrapper;
import com.github.lehjr.numina.util.nbt.MuseNBTUtils;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;

public class ForgeEnergyModuleWrapper
extends EnergyStorage
implements IEnergyWrapper,
INBTSerializable<IntNBT> {
    private static final String TAG_ENERGY = "energy";
    protected ItemStack stack;

    public ForgeEnergyModuleWrapper(@Nonnull ItemStack stack, int maxEnergy, int maxTransfer) {
        super(maxEnergy, maxTransfer);
        this.stack = stack;
    }

    @Override
    public void updateFromNBT() {
        CompoundNBT nbt = MuseNBTUtils.getModuleTag(this.stack);
        if (nbt != null && nbt.func_150297_b(TAG_ENERGY, 3)) {
            this.deserializeNBT((IntNBT)nbt.func_74781_a(TAG_ENERGY));
        }
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int energyReceived = super.receiveEnergy(maxReceive, simulate);
        if (!simulate && energyReceived != 0) {
            MuseNBTUtils.setModuleIntOrRemove(this.stack, TAG_ENERGY, this.energy);
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int energyExtracted = super.extractEnergy(maxExtract, simulate);
        if (!simulate && energyExtracted != 0) {
            MuseNBTUtils.setModuleIntOrRemove(this.stack, TAG_ENERGY, this.energy);
        }
        return energyExtracted;
    }

    public IntNBT serializeNBT() {
        return (IntNBT)CapabilityEnergy.ENERGY.writeNBT((Object)this, null);
    }

    public void deserializeNBT(IntNBT nbt) {
        CapabilityEnergy.ENERGY.readNBT((Object)this, null, (INBT)nbt);
    }
}

