/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.capabilities.heat;

import com.github.lehjr.numina.util.capabilities.heat.HeatCapability;
import com.github.lehjr.numina.util.capabilities.heat.HeatStorage;
import com.github.lehjr.numina.util.capabilities.heat.IHeatStorage;
import com.github.lehjr.numina.util.capabilities.heat.IHeatWrapper;
import com.github.lehjr.numina.util.capabilities.module.powermodule.IPowerModule;
import com.github.lehjr.numina.util.nbt.MuseNBTUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class HeatItemWrapper
extends HeatStorage
implements ICapabilityProvider,
IHeatWrapper,
INBTSerializable<DoubleNBT> {
    ItemStack stack;
    private final LazyOptional<IHeatStorage> holder = LazyOptional.of(() -> this);

    public HeatItemWrapper(@Nonnull ItemStack stack, double baseMax, LazyOptional<IPowerModule> moduleCap) {
        this(stack, baseMax + moduleCap.map(cap -> cap.applyPropertyModifiers("maxHeat")).orElse(0.0));
    }

    public HeatItemWrapper(@Nonnull ItemStack stack, double capacity) {
        this(stack, capacity, capacity, capacity);
    }

    public HeatItemWrapper(@Nonnull ItemStack stack, double capacity, double maxTransfer) {
        this(stack, capacity, maxTransfer, maxTransfer);
    }

    public HeatItemWrapper(@Nonnull ItemStack stack, double capacity, double maxReceive, double maxExtract) {
        super(capacity, maxReceive, maxExtract, 0.0);
        this.stack = stack;
    }

    @Override
    public void updateFromNBT() {
        this.heat = Math.min(this.capacity, MuseNBTUtils.getModularItemDoubleOrZero(this.stack, "curHeat"));
    }

    @Override
    public double receiveHeat(double heatProvided, boolean simulate) {
        double heatReceived = super.receiveHeat(heatProvided, simulate);
        if (!simulate && heatReceived > 0.0) {
            MuseNBTUtils.setModularItemDoubleOrRemove(this.stack, "curHeat", this.heat);
        }
        return heatReceived;
    }

    @Override
    public double extractHeat(double heatRequested, boolean simulate) {
        double heatExtracted = super.extractHeat(heatRequested, simulate);
        if (!simulate && heatExtracted > 0.0) {
            MuseNBTUtils.setModularItemDoubleOrRemove(this.stack, "curHeat", this.heat);
        }
        return heatExtracted;
    }

    public DoubleNBT serializeNBT() {
        return (DoubleNBT)HeatCapability.HEAT.writeNBT((Object)this, null);
    }

    public void deserializeNBT(DoubleNBT nbt) {
        HeatCapability.HEAT.readNBT((Object)this, null, (INBT)nbt);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return HeatCapability.HEAT.orEmpty(cap, this.holder);
    }
}

