/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.capabilities.module.powermodule;

import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleCategory;
import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleTarget;
import com.github.lehjr.numina.util.capabilities.module.powermodule.IConfig;
import com.github.lehjr.numina.util.capabilities.module.powermodule.IPowerModule;
import com.github.lehjr.numina.util.nbt.MuseNBTUtils;
import com.github.lehjr.numina.util.nbt.propertymodifier.IPropertyModifier;
import com.github.lehjr.numina.util.nbt.propertymodifier.PropertyModifierFlatAdditive;
import com.github.lehjr.numina.util.nbt.propertymodifier.PropertyModifierIntLinearAdditive;
import com.github.lehjr.numina.util.nbt.propertymodifier.PropertyModifierLinearAdditive;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PowerModule
implements IPowerModule {
    protected static Map<String, String> units;
    protected ItemStack module;
    protected final EnumModuleCategory category;
    protected final EnumModuleTarget target;
    protected Map<String, List<IPropertyModifier>> propertyModifiers = new HashMap<String, List<IPropertyModifier>>();
    Callable<IConfig> moduleConfigGetter;

    public PowerModule(@Nonnull ItemStack module, EnumModuleCategory category, EnumModuleTarget target, Callable<IConfig> moduleConfigGetterIn) {
        units = new HashMap<String, String>();
        this.module = module;
        this.category = category;
        this.target = target;
        this.moduleConfigGetter = moduleConfigGetterIn;
    }

    @Override
    public ItemStack getModuleStack() {
        return this.module;
    }

    @Override
    public EnumModuleTarget getTarget() {
        return this.target;
    }

    @Override
    public EnumModuleCategory getCategory() {
        return this.category;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getUnit(String propertyName) {
        String unit = units.get(propertyName);
        if (unit != null && unit.startsWith("module.tradeoff.")) {
            unit = I18n.func_135052_a((String)unit, (Object[])new Object[0]);
        }
        return unit == null ? "" : unit;
    }

    Optional<IConfig> getConfig() {
        try {
            return Optional.ofNullable(this.moduleConfigGetter.call());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void addTradeoffProperty(String tradeoffName, String propertyName, double multiplier) {
        double propFromConfig = this.getConfig().map(config -> config.getTradeoffPropertyDoubleOrDefault(this.category, this.module, tradeoffName, propertyName, multiplier)).orElse(multiplier);
        this.addPropertyModifier(propertyName, new PropertyModifierLinearAdditive(tradeoffName, propFromConfig));
    }

    @Override
    public void addPropertyModifier(String propertyName, IPropertyModifier modifier) {
        List<IPropertyModifier> modifiers = this.propertyModifiers.get(propertyName);
        if (modifiers == null) {
            modifiers = new LinkedList<IPropertyModifier>();
        }
        modifiers.add(modifier);
        this.propertyModifiers.put(propertyName, modifiers);
    }

    @Override
    public void addTradeoffProperty(String tradeoffName, String propertyName, double multiplier, String unit) {
        units.put(propertyName, unit);
        this.addTradeoffProperty(tradeoffName, propertyName, multiplier);
    }

    public void addSimpleTradeoff(String tradeoffName, String firstPropertyName, String firstUnits, double firstPropertyBase, double firstPropertyMultiplier, String secondPropertyName, String secondUnits, double secondPropertyBase, double secondPropertyMultiplier) {
        this.addBaseProperty(firstPropertyName, firstPropertyBase, firstUnits);
        this.addTradeoffProperty(tradeoffName, firstPropertyName, firstPropertyMultiplier);
        this.addBaseProperty(secondPropertyName, secondPropertyBase, secondUnits);
        this.addTradeoffProperty(tradeoffName, secondPropertyName, secondPropertyMultiplier);
    }

    @Override
    public void addBaseProperty(String propertyName, double baseVal) {
        double propFromConfig = this.getConfig().map(config -> config.getBasePropertyDoubleOrDefault(this.category, this.module, propertyName, baseVal)).orElse(baseVal);
        this.addPropertyModifier(propertyName, new PropertyModifierFlatAdditive(propFromConfig));
    }

    @Override
    public void addBaseProperty(String propertyName, double baseVal, String unit) {
        units.put(propertyName, unit);
        this.addBaseProperty(propertyName, baseVal);
    }

    @Override
    public double applyPropertyModifiers(String propertyName) {
        return this.applyPropertyModifiers(propertyName, MuseNBTUtils.getModuleTag(this.module));
    }

    @Override
    public double applyPropertyModifiers(String propertyName, CompoundNBT moduleTag) {
        double propertyValue = 0.0;
        if (this.propertyModifiers.containsKey(propertyName)) {
            Iterable propertyModifiersIterable = this.propertyModifiers.get(propertyName);
            for (IPropertyModifier modifier : propertyModifiersIterable) {
                propertyValue = modifier.applyModifier(moduleTag, propertyValue);
            }
        }
        return propertyValue;
    }

    @Override
    public Map<String, List<IPropertyModifier>> getPropertyModifiers() {
        return this.propertyModifiers;
    }

    @Override
    public void addIntTradeoffProperty(String tradeoffName, String propertyName, int multiplier, String unit, int roundTo, int offset) {
        units.put(propertyName, unit);
        int propFromConfig = this.getConfig().map(config -> config.getTradeoffPropertyIntegerOrDefault(this.category, this.module, tradeoffName, propertyName, multiplier)).orElse(multiplier);
        this.addPropertyModifier(propertyName, new PropertyModifierIntLinearAdditive(tradeoffName, propFromConfig, roundTo, offset));
    }

    @Override
    public boolean isAllowed() {
        return this.getConfig().map(config -> config.isModuleAllowed(this.category, this.module)).orElse(true);
    }
}

