/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.capabilities.render.modelspec;

import java.util.Arrays;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.inventory.EquipmentSlotType;

public enum MorphTarget {
    Head("HEAD", EquipmentSlotType.HEAD),
    Body("BODY", EquipmentSlotType.CHEST),
    RightArm("RIGHTARM", EquipmentSlotType.CHEST),
    LeftArm("LEFTARM", EquipmentSlotType.CHEST),
    RightLeg("RIGHTLEG", EquipmentSlotType.LEGS),
    LeftLeg("LEFTLEG", EquipmentSlotType.LEGS),
    RightFoot("RIGHTFOOT", EquipmentSlotType.FEET),
    LeftFoot("LEFTFOOT", EquipmentSlotType.FEET),
    RightHand("RIGHTHAND", EquipmentSlotType.MAINHAND),
    Lefthand("LEFTHAND", EquipmentSlotType.OFFHAND);

    String name;
    EquipmentSlotType slot;

    private MorphTarget(String name, EquipmentSlotType slot) {
        this.name = name;
        this.slot = slot;
    }

    public static MorphTarget getMorph(String name) {
        return Arrays.stream(MorphTarget.values()).filter(morph -> name.toUpperCase().equals(morph.name)).findAny().orElseGet(null);
    }

    public ModelRenderer apply(BipedModel m) {
        switch (this) {
            case Head: {
                return m.field_78116_c;
            }
            case Body: {
                return m.field_78115_e;
            }
            case RightHand: 
            case RightArm: {
                return m.field_178723_h;
            }
            case Lefthand: 
            case LeftArm: {
                return m.field_178724_i;
            }
            case RightFoot: 
            case RightLeg: {
                return m.field_178721_j;
            }
            case LeftFoot: 
            case LeftLeg: {
                return m.field_178722_k;
            }
        }
        return null;
    }
}

