/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.client.control;

import com.github.lehjr.numina.util.capabilities.player.CapabilityPlayerKeyStates;
import com.github.lehjr.numina.util.capabilities.player.IPlayerKeyStates;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.entity.player.RemoteClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.common.util.LazyOptional;

public class PlayerMovementInputWrapper {
    public static PlayerMovementInput get(PlayerEntity player) {
        if (player.field_70170_p.field_72995_K) {
            if (player instanceof RemoteClientPlayerEntity) {
                return PlayerMovementInputWrapper.fromServer(player);
            }
            return PlayerMovementInputWrapper.fromClient(player);
        }
        return PlayerMovementInputWrapper.fromServer(player);
    }

    static LazyOptional<IPlayerKeyStates> getCapability(PlayerEntity player) {
        return player.getCapability(CapabilityPlayerKeyStates.PLAYER_KEYSTATES, null);
    }

    static PlayerMovementInput fromServer(PlayerEntity player) {
        boolean jumpKey = false;
        boolean downKey = false;
        LazyOptional<IPlayerKeyStates> playerCap = PlayerMovementInputWrapper.getCapability(player);
        if (playerCap.isPresent()) {
            jumpKey = playerCap.map(m -> m.getJumpKeyState()).orElse(false);
            downKey = playerCap.map(m -> m.getDownKeyState()).orElse(false);
        }
        return new PlayerMovementInput(player.field_70702_br, player.field_191988_bg, jumpKey, downKey, player.func_213453_ef());
    }

    static PlayerMovementInput fromClient(PlayerEntity player) {
        boolean jumpKey = false;
        boolean downKey = false;
        ClientPlayerEntity clientPlayer = (ClientPlayerEntity)player;
        LazyOptional<IPlayerKeyStates> playerCap = PlayerMovementInputWrapper.getCapability(player);
        if (playerCap.isPresent()) {
            jumpKey = playerCap.map(m -> m.getJumpKeyState()).orElse(false);
            downKey = playerCap.map(m -> m.getDownKeyState()).orElse(false);
        }
        return new PlayerMovementInput(clientPlayer.field_71158_b.field_78902_a, clientPlayer.field_71158_b.field_192832_b, jumpKey, downKey, clientPlayer.func_213453_ef());
    }

    public static class PlayerMovementInput {
        public float moveStrafe;
        public float moveForward;
        public boolean jumpKey;
        public boolean downKey;
        public boolean sneakKey;

        public PlayerMovementInput(float moveStrafe, float moveForward, boolean jumpKey, boolean downKey, boolean sneakKey) {
            this.moveStrafe = Math.signum(moveStrafe);
            this.moveForward = Math.signum(moveForward);
            this.jumpKey = jumpKey;
            this.downKey = downKey;
            this.sneakKey = sneakKey;
        }
    }
}

