/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.client.gui;

import com.github.lehjr.numina.util.client.gui.frame.IGuiFrame;
import com.github.lehjr.numina.util.client.gui.gemoetry.DrawableRelativeRect;
import com.github.lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import com.github.lehjr.numina.util.math.Colour;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;

public class ContainerlessGui
extends Screen {
    protected DrawableRelativeRect backgroundRect;
    protected long creationTime;
    public int imageWidth = 176;
    public int imageHeight = 166;
    public int guiLeft;
    public int guiTop;
    private List<IGuiFrame> frames = new ArrayList<IGuiFrame>();

    public ContainerlessGui(ITextComponent titleIn, boolean growFromMiddle) {
        super(titleIn);
        this.backgroundRect = new DrawableRelativeRect(0.0, 0.0, 0.0, 0.0, growFromMiddle, Colour.GREY_GUI_BACKGROUND, Colour.BLACK);
    }

    public ContainerlessGui(ITextComponent titleIn, int guiWidth, int guiHeight, boolean growFromMiddle) {
        this(titleIn, growFromMiddle);
        this.imageWidth = guiWidth;
        this.imageHeight = guiHeight;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.creationTime = System.currentTimeMillis();
        this.backgroundRect.init(this.absX(-1.0), this.absY(-1.0), this.absX(1.0), this.absY(1.0));
    }

    public void addFrame(IGuiFrame frame) {
        this.frames.add(frame);
    }

    public void func_230446_a_(MatrixStack matrixStack) {
        super.func_230446_a_(matrixStack);
    }

    public void renderBackgroundRect(MatrixStack matrixStack, int mouseX, int mouseY, float frameTime) {
        this.backgroundRect.func_230430_a_(matrixStack, mouseX, mouseY, frameTime);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float frameTime) {
        this.func_230446_a_(matrixStack);
        this.renderBackgroundRect(matrixStack, mouseX, mouseY, frameTime);
        this.update(mouseX, mouseY);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, 10.0);
        this.renderFrames(matrixStack, mouseX, mouseY, frameTime);
        matrixStack.func_227861_a_(0.0, 0.0, 10.0);
        super.func_230430_a_(matrixStack, mouseX, mouseY, frameTime);
        matrixStack.func_227861_a_(0.0, 0.0, 100.0);
        this.renderLabels(matrixStack, mouseX, mouseY);
        matrixStack.func_227865_b_();
    }

    public void update(double x, double y) {
        for (IGuiFrame frame : this.frames) {
            frame.update(x, y);
        }
    }

    public void renderFrames(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        for (IGuiFrame frame : this.frames) {
            frame.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    public void renderLabels(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.renderFrameLabels(matrixStack, mouseX, mouseY);
    }

    public void renderFrameLabels(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.frames.forEach(frame -> frame.renderLabels(matrixStack, mouseX, mouseY));
    }

    public boolean func_231177_au__() {
        return false;
    }

    public int absX(double relx) {
        int absx = (int)((relx + 1.0) * (double)this.getImageWidth() / 2.0);
        int xpadding = (this.field_230708_k_ - this.getImageWidth()) / 2;
        return absx + xpadding;
    }

    public int relX(double absx) {
        int padding = (this.field_230708_k_ - this.getImageWidth()) / 2;
        return (int)((absx - (double)padding) * 2.0 / (double)this.getImageWidth() - 1.0);
    }

    public int absY(double rely) {
        int absy = (int)((rely + 1.0) * (double)this.imageHeight / 2.0);
        int ypadding = (this.field_230709_l_ - this.imageHeight) / 2;
        return absy + ypadding;
    }

    public int relY(float absy) {
        int padding = (this.field_230709_l_ - this.getYSize()) / 2;
        return (int)((absy - (float)padding) * 2.0f / (float)this.getYSize() - 1.0f);
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public void setImageWidth(int imageWidth) {
        this.imageWidth = imageWidth;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public void setImageHeight(int imageHeight) {
        this.imageHeight = imageHeight;
    }

    public MusePoint2D center() {
        return new MusePoint2D(this.getGuiLeft(), this.getGuiTop()).plus((double)this.getXSize() * 0.5, (double)this.getYSize() * 0.5);
    }

    public int getGuiLeft() {
        return this.guiLeft;
    }

    public int getGuiTop() {
        return this.guiTop;
    }

    public int getXSize() {
        return this.imageWidth;
    }

    public void setXSize(int xSize) {
        this.imageWidth = xSize;
        this.guiLeft = (this.field_230708_k_ - this.getXSize()) / 2;
    }

    public int getYSize() {
        return this.imageHeight;
    }

    public void setYSize(int ySize) {
        this.imageHeight = ySize;
        this.guiTop = (this.field_230709_l_ - this.getYSize()) / 2;
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double dWheel) {
        for (IGuiFrame frame : this.frames) {
            if (!frame.mouseScrolled(mouseX, mouseY, dWheel)) continue;
            return true;
        }
        return false;
    }

    public boolean func_231044_a_(double x, double y, int button) {
        for (IGuiFrame frame : this.frames) {
            frame.mouseClicked(x, y, button);
        }
        return true;
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int which) {
        for (IGuiFrame frame : this.frames) {
            if (!frame.mouseReleased(mouseX, mouseY, which)) continue;
            return true;
        }
        return false;
    }

    public void drawToolTip(MatrixStack matrixStack, int mouseX, int mouseY) {
        List<ITextComponent> tooltip = this.getToolTip(mouseX, mouseY);
        if (tooltip != null) {
            this.func_243308_b(matrixStack, tooltip, mouseX, mouseY);
        }
    }

    public List<ITextComponent> getToolTip(int x, int y) {
        for (IGuiFrame frame : this.frames) {
            List<ITextComponent> hitTip = frame.getToolTip(x, y);
            if (hitTip == null) continue;
            return hitTip;
        }
        return null;
    }

    public Minecraft getMinecraft() {
        this.field_230706_i_ = Minecraft.func_71410_x();
        return this.field_230706_i_;
    }
}

