/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.client.gui.clickable;

import com.github.lehjr.numina.util.client.gui.clickable.IClickable;
import com.github.lehjr.numina.util.client.gui.gemoetry.DrawableRelativeRect;
import com.github.lehjr.numina.util.client.gui.gemoetry.IDrawable;
import com.github.lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import com.github.lehjr.numina.util.client.render.MuseRenderer;
import com.github.lehjr.numina.util.math.Colour;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.util.text.ITextComponent;

public class ClickableButton
extends DrawableRelativeRect
implements IClickable {
    boolean isVisible = true;
    boolean isEnabled = true;
    protected ITextComponent label;
    protected MusePoint2D radius;
    private Colour enabledBorder = new Colour(0.3f, 0.3f, 0.3f, 1.0f);
    private Colour enabledBackground = new Colour(0.5f, 0.6f, 0.8f, 1.0f);
    private Colour disabledBorder = new Colour(0.8f, 0.6f, 0.6f, 1.0f);
    private Colour disabledBackground = new Colour(0.8f, 0.3f, 0.3f, 1.0f);
    private IClickable.IPressable onPressed;
    private IClickable.IReleasable onReleased;

    public ClickableButton(ITextComponent label, MusePoint2D position, boolean enabled) {
        super(0.0, 0.0, 0.0, 0.0, Colour.BLACK, Colour.BLACK);
        this.label = label;
        this.setPosition(position);
        if (label.getString().contains("\n")) {
            String[] x = label.getString().split("\n");
            int longestIndex = 0;
            for (int i = 0; i < x.length; ++i) {
                if (x[i].length() <= x[longestIndex].length()) continue;
                longestIndex = i;
            }
            this.radius = new MusePoint2D((float)(MuseRenderer.getStringWidth(x[longestIndex]) / 2.0 + 2.0), 6 * x.length);
        } else {
            this.radius = new MusePoint2D((float)(MuseRenderer.getStringWidth(label.getString()) / 2.0 + 2.0), 6.0);
        }
        this.setLeft(position.getX() - this.radius.getX());
        this.setTop(position.getY() - this.radius.getY());
        this.setWidth(this.radius.getX() * 2.0);
        this.setHeight(this.radius.getY() * 2.0);
        this.setBorderColour(this.enabledBorder);
        this.setBackgroundColour(this.enabledBackground);
        this.setEnabled(enabled);
    }

    public ClickableButton setEnabledBorder(Colour enabledBorder) {
        this.enabledBorder = enabledBorder;
        return this;
    }

    public ClickableButton setEnabledBackground(Colour enabledBackground) {
        this.enabledBackground = enabledBackground;
        return this;
    }

    public ClickableButton setDisabledBorder(Colour disabledBorder) {
        this.disabledBorder = disabledBorder;
        return this;
    }

    public ClickableButton setDisabledBackground(Colour disabledBackground) {
        this.disabledBackground = disabledBackground;
        return this;
    }

    void setBackgroundColour(Colour backgroundColour, boolean hovered) {
        super.setBackgroundColour(hovered ? backgroundColour.copy().lighten(0.1f) : backgroundColour);
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.renderButton(matrixStack, mouseX, mouseY, partialTicks);
        this.renderText(matrixStack, mouseX, mouseY);
    }

    @Override
    public float getZLevel() {
        return 0.0f;
    }

    @Override
    public IDrawable setZLevel(float zLevel) {
        return null;
    }

    public void renderButton(MatrixStack matrixStack, int mouseX, int mouseY, float frameTIme) {
        if (this.isVisible) {
            this.setBackgroundColour(this.isEnabled() ? this.enabledBackground : this.disabledBackground, this.containsPoint(mouseX, mouseY));
            this.setBorderColour(this.isEnabled() ? this.enabledBorder : this.disabledBorder);
            super.func_230430_a_(matrixStack, mouseX, mouseY, frameTIme);
        }
    }

    public void renderText(MatrixStack matrixStack, int mouseX, int mouseY) {
        if (this.isVisible()) {
            if (this.label.getString().contains("\n")) {
                String[] s = this.label.getString().split("\n");
                for (int i = 0; i < s.length; ++i) {
                    MuseRenderer.drawShadowedStringCentered(matrixStack, s[i], this.getPosition().getX(), this.getPosition().getY() + ((double)i * MuseRenderer.getStringHeight() + 2.0));
                }
            } else {
                MuseRenderer.drawShadowedStringCentered(matrixStack, this.label.getString(), this.getPosition().getX(), this.getPosition().getY());
            }
        }
    }

    public MusePoint2D getRadius() {
        return this.radius.copy();
    }

    @Override
    public boolean hitBox(double x, double y) {
        return this.containsPoint(x, y);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public void setOnPressed(IClickable.IPressable onPressed) {
        this.onPressed = onPressed;
    }

    @Override
    public void setOnReleased(IClickable.IReleasable onReleased) {
        this.onReleased = onReleased;
    }

    @Override
    public void onPressed() {
        if (this.isVisible() && this.isEnabled() && this.onPressed != null) {
            this.onPressed.onPressed(this);
        }
    }

    @Override
    public void onReleased() {
        if (this.isVisible() && this.isEnabled() && this.onReleased != null) {
            this.onReleased.onReleased(this);
        }
    }

    public ClickableButton setLable(ITextComponent label) {
        this.label = label;
        return this;
    }

    public ITextComponent getLabel() {
        return this.label;
    }
}

