/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.client.gui.clickable;

import com.github.lehjr.numina.util.client.gui.clickable.Clickable;
import com.github.lehjr.numina.util.client.gui.clickable.IClickable;
import com.github.lehjr.numina.util.client.gui.gemoetry.IDrawable;
import com.github.lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import com.github.lehjr.numina.util.client.render.MuseRenderer;
import com.github.lehjr.numina.util.math.Colour;
import com.mojang.blaze3d.matrix.MatrixStack;

public class ClickableLabel
extends Clickable {
    protected IClickable.IPressable onPressed;
    protected IClickable.IReleasable onReleased;
    Colour colour = Colour.WHITE;
    boolean shadowed = true;
    protected String label;
    protected JustifyMode mode;

    public ClickableLabel(String label, MusePoint2D position) {
        this.label = label;
        this.mode = JustifyMode.CENTERED;
        super.setWidth(MuseRenderer.getStringWidth(label));
        super.setHeight(MuseRenderer.getStringHeight());
        super.setPosition(position);
    }

    public ClickableLabel(String label, MusePoint2D position, JustifyMode mode) {
        this.label = label;
        super.setWidth(MuseRenderer.getStringWidth(label));
        super.setHeight(MuseRenderer.getStringHeight());
        super.setPosition(position);
        this.mode = mode;
    }

    public ClickableLabel setMode(JustifyMode mode) {
        this.mode = mode;
        return this;
    }

    public void setColour(Colour colour) {
        this.colour = colour;
    }

    public void setShadowed(boolean shadowed) {
        this.shadowed = shadowed;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, 100.0);
        if (this.shadowed) {
            switch (this.mode) {
                case LEFT: {
                    MuseRenderer.drawLeftAlignedShadowedString(matrixStack, this.label, this.centerx(), this.centery(), this.colour);
                    break;
                }
                case CENTERED: {
                    MuseRenderer.drawShadowedStringCentered(matrixStack, this.label, this.centerx(), this.centery(), this.colour);
                    break;
                }
                case RIGHT: {
                    MuseRenderer.drawRightAlignedShadowedString(matrixStack, this.label, this.centerx(), this.centery(), this.colour);
                }
            }
        } else {
            switch (this.mode) {
                case LEFT: {
                    MuseRenderer.drawLeftAlignedText(matrixStack, this.label, this.centerx(), this.centery(), this.colour);
                    break;
                }
                case CENTERED: {
                    MuseRenderer.drawCenteredText(matrixStack, this.label, this.centerx(), this.centery(), this.colour);
                    break;
                }
                case RIGHT: {
                    MuseRenderer.drawRightAlignedText(matrixStack, this.label, this.centerx(), this.centery(), this.colour);
                }
            }
        }
        matrixStack.func_227865_b_();
    }

    @Override
    public float getZLevel() {
        return 0.0f;
    }

    @Override
    public IDrawable setZLevel(float zLevel) {
        return null;
    }

    @Override
    public boolean hitBox(double x, double y) {
        if (this.label == null || this.label.isEmpty()) {
            return false;
        }
        MusePoint2D radius = new MusePoint2D(MuseRenderer.getStringWidth(this.label) / 2.0 + 2.0, MuseRenderer.getStringHeight());
        return Math.abs(this.centerx() - x) < radius.getX() && Math.abs(this.centery() - y) < radius.getY();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public void setOnPressed(IClickable.IPressable onPressed) {
        this.onPressed = onPressed;
    }

    @Override
    public void setOnReleased(IClickable.IReleasable onReleased) {
        this.onReleased = onReleased;
    }

    @Override
    public void onReleased() {
        if (this.isVisible && this.isEnabled && this.onReleased != null) {
            this.onReleased.onReleased(this);
        }
    }

    @Override
    public void onPressed() {
        if (this.isVisible && this.isEnabled && this.onPressed != null) {
            this.onPressed.onPressed(this);
        }
    }

    public static enum JustifyMode {
        LEFT,
        CENTERED,
        RIGHT;

    }
}

