/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.client.gui.clickable;

import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleCategory;
import com.github.lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import com.github.lehjr.numina.util.client.gui.clickable.Clickable;
import com.github.lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import com.github.lehjr.numina.util.client.render.MuseIconUtils;
import com.github.lehjr.numina.util.client.render.MuseRenderer;
import com.github.lehjr.numina.util.math.Colour;
import com.github.lehjr.numina.util.string.AdditionalInfo;
import com.github.lehjr.numina.util.string.MuseStringUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;

public class ClickableModule
extends Clickable {
    final Colour checkmarkcolour = new Colour(0.0f, 0.667f, 0.0f, 1.0f);
    boolean allowed = true;
    boolean installed = false;
    boolean isEnabled = true;
    boolean isVisible = true;
    ItemStack module;
    int inventorySlot;
    public final EnumModuleCategory category;
    Integer tier;

    public ClickableModule(@Nonnull ItemStack module, MusePoint2D position, int inventorySlot, EnumModuleCategory category) {
        this.setWH(new MusePoint2D(16.0, 16.0));
        super.setPosition(position);
        this.module = module;
        this.inventorySlot = inventorySlot;
        this.category = category;
        this.allowed = module.getCapability(PowerModuleCapability.POWER_MODULE).map(pm -> pm.isAllowed()).orElse(false);
        this.tier = module.getCapability(PowerModuleCapability.POWER_MODULE).map(pm -> pm.getTier()).orElse(null);
    }

    @Nullable
    public Integer getTier() {
        return this.tier;
    }

    public int getInventorySlot() {
        return this.inventorySlot;
    }

    @Override
    public List<ITextComponent> getToolTip(int x, int y) {
        if (this.hitBox(x, y)) {
            return this.module.func_82840_a((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)(AdditionalInfo.doAdditionalInfo() ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
        }
        return null;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (!this.getModule().func_190926_b()) {
            MuseRenderer.drawModuleAt(matrixStack, this.left(), this.top(), this.getModule(), true);
            if (!this.allowed) {
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_(0.0, 0.0, 250.0);
                String string = MuseStringUtils.wrapMultipleFormatTags("X", new Object[]{MuseStringUtils.FormatCodes.Bold, MuseStringUtils.FormatCodes.DarkRed});
                MuseRenderer.drawShadowedString(matrixStack, string, this.getPosition().getX() + 3.0, this.getPosition().getY() + 1.0);
                matrixStack.func_227865_b_();
            } else if (this.installed) {
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_(0.0, 0.0, 250.0);
                MuseIconUtils.getIcon().checkmark.draw(matrixStack, this.left() + 1.0, this.top() + 1.0, this.checkmarkcolour.withAlpha(0.6f));
                matrixStack.func_227865_b_();
            }
        }
    }

    @Override
    public boolean hitBox(double x, double y) {
        return this.containsPoint(x, y);
    }

    @Nonnull
    public ItemStack getModule() {
        return this.module;
    }

    public boolean equals(ClickableModule other) {
        return this.module == other.getModule();
    }

    public void setInstalled(boolean installed) {
        this.installed = installed;
    }

    public boolean isInstalled() {
        return this.installed;
    }
}

