/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.client.gui.frame;

import com.github.lehjr.numina.util.client.gui.clickable.IClickable;
import com.github.lehjr.numina.util.client.gui.frame.GUISpacer;
import com.github.lehjr.numina.util.client.gui.frame.IGuiFrame;
import com.github.lehjr.numina.util.client.gui.gemoetry.IDrawable;
import com.github.lehjr.numina.util.client.gui.gemoetry.IDrawableRect;
import com.github.lehjr.numina.util.client.gui.gemoetry.IRect;
import com.github.lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;

public class MultiRectHolderFrame<T extends Map<Integer, IRect>>
extends GUISpacer {
    protected double margin;
    protected double maxHeight = -1.0;
    protected double maxWidth = -1.0;
    float zLevel;
    boolean isEnabled = true;
    boolean isVisible = true;
    @Nullable
    IDrawableRect background = null;
    Map<Integer, IRect> rects = new HashMap<Integer, IRect>();
    boolean horizontalLayout;
    boolean startTopLeft;

    public MultiRectHolderFrame(boolean horizontalLayout, boolean startTopLeft, double minWidth, double minHeight) {
        super(minWidth, minHeight);
        this.horizontalLayout = horizontalLayout;
        this.startTopLeft = startTopLeft;
    }

    public MultiRectHolderFrame(boolean horizontalLayout, boolean startTopLeft, double minWidth, double minHeight, double maxWidth, double maxHeight) {
        super(minWidth, minHeight);
        this.horizontalLayout = horizontalLayout;
        this.startTopLeft = startTopLeft;
        this.maxHeight = maxHeight;
        this.maxWidth = maxWidth;
    }

    public void setMargin(double margin) {
        this.margin = margin;
    }

    public MultiRectHolderFrame addRect(IRect rect) {
        if (this.rects.size() > 0) {
            if (this.horizontalLayout) {
                if (this.startTopLeft) {
                    rect.setMeRightOf(this.rects.get(this.rects.size() - 1));
                } else {
                    rect.setMeLeftOf(this.rects.get(this.rects.size() - 1));
                }
            } else if (this.startTopLeft) {
                rect.setMeBelow(this.rects.get(this.rects.size() - 1));
            } else {
                rect.setMeAbove(this.rects.get(this.rects.size() - 1));
            }
        }
        this.rects.put(this.rects.size(), rect);
        return this;
    }

    public MultiRectHolderFrame setMaxHeight(double maxHeight) {
        this.maxHeight = maxHeight;
        return this;
    }

    public MultiRectHolderFrame setMaxWidth(double maxWidth) {
        this.maxWidth = maxWidth;
        return this;
    }

    public MultiRectHolderFrame setMinHeight(double minHeight) {
        super.setHeight(minHeight);
        return this;
    }

    public MultiRectHolderFrame setMinWidth(double minWidth) {
        super.setWidth(minWidth);
        return this;
    }

    public Optional<IRect> getLast() {
        return Optional.ofNullable(this.rects.size() > 0 ? this.rects.get(this.rects.size() - 1) : null);
    }

    public void setRects(Map<Integer, IRect> rects) {
        this.rects = rects;
    }

    public Map<Integer, IRect> getRects() {
        return this.rects;
    }

    public void doneAdding() {
        double finalVal = 0.0;
        double highestVal = 0.0;
        for (IRect rect : this.rects.values()) {
            if (this.horizontalLayout) {
                finalVal += rect.finalWidth();
                if (!(rect.finalHeight() > highestVal)) continue;
                highestVal = rect.finalHeight();
                continue;
            }
            finalVal += rect.finalHeight();
            if (!(rect.finalWidth() > highestVal)) continue;
            highestVal = rect.finalWidth();
        }
        highestVal += this.margin * 2.0;
        if (this.horizontalLayout) {
            if (this.maxWidth > 0.0) {
                super.setWidth(Math.min(Math.max(finalVal, super.finalWidth()), this.maxWidth));
            } else {
                super.setWidth(Math.max(finalVal, super.finalWidth()));
            }
            if (this.maxHeight > 0.0) {
                super.setHeight(Math.min(Math.max(highestVal, super.finalHeight()), this.maxHeight));
            } else {
                super.setHeight(Math.max(highestVal, super.finalHeight()));
            }
        } else {
            if (this.maxWidth > 0.0) {
                super.setWidth(Math.min(Math.max(highestVal, super.finalWidth()), this.maxWidth));
            } else {
                super.setWidth(Math.max(highestVal, super.finalWidth()));
            }
            if (this.maxHeight > 0.0) {
                super.setHeight(Math.min(Math.max(finalVal, super.finalHeight()), this.maxHeight));
            } else {
                super.setHeight(Math.max(finalVal, super.finalHeight()));
            }
        }
    }

    public MultiRectHolderFrame setBackground(IDrawableRect background) {
        this.background = background;
        return this;
    }

    Optional<IDrawableRect> getBackground() {
        return Optional.ofNullable(this.background);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        for (IRect rect : this.rects.values()) {
            if (!(rect instanceof IGuiFrame) || !((IGuiFrame)rect).mouseClicked(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        for (IRect rect : this.rects.values()) {
            if (!(rect instanceof IGuiFrame) || !((IGuiFrame)rect).mouseReleased(mouseX, mouseY, button)) continue;
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double dWheel) {
        for (IRect rect : this.rects.values()) {
            if (!(rect instanceof IGuiFrame) || !((IGuiFrame)rect).mouseScrolled(mouseX, mouseY, dWheel)) continue;
            return true;
        }
        return false;
    }

    public void renderRects(MatrixStack matrixStack, int mouseX, int mouseY, float frameTime) {
        if (this.isVisible()) {
            for (IRect rect : this.rects.values()) {
                if (!(rect instanceof IDrawable)) continue;
                ((IDrawable)((Object)rect)).func_230430_a_(matrixStack, mouseX, mouseY, frameTime);
            }
        }
    }

    public void renderBackground(MatrixStack matrixStack, int mouseX, int mouseY, float frameTime) {
        this.getBackground().ifPresent(background -> background.func_230430_a_(matrixStack, mouseX, mouseY, frameTime));
    }

    public void superRender(MatrixStack matrixStack, int mouseX, int mouseY, float frameTime) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, frameTime);
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float frameTime) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, frameTime);
        if (this.isVisible()) {
            this.renderBackground(matrixStack, mouseX, mouseY, frameTime);
            this.preRender(matrixStack, mouseX, mouseY, frameTime);
            this.renderRects(matrixStack, mouseX, mouseY, frameTime);
            this.postRender(mouseX, mouseY, frameTime);
        }
    }

    @Override
    public List<ITextComponent> getToolTip(int x, int y) {
        List<ITextComponent> toolTip = null;
        for (IRect rect : this.rects.values()) {
            if (rect instanceof IDrawableRect) {
                toolTip = ((IDrawableRect)rect).getToolTip(x, y);
            }
            if (toolTip == null) continue;
            return toolTip;
        }
        return null;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
        for (IRect rect : this.rects.values()) {
            if (rect instanceof IClickable) {
                ((IClickable)rect).setEnabled(enabled);
            }
            if (!(rect instanceof IGuiFrame)) continue;
            ((IGuiFrame)rect).setEnabled(enabled);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setVisible(boolean visible) {
        this.isVisible = visible;
        for (IRect rect : this.rects.values()) {
            if (rect instanceof IClickable) {
                ((IClickable)rect).setVisible(visible);
            }
            if (!(rect instanceof IGuiFrame)) continue;
            ((IGuiFrame)rect).setVisible(visible);
        }
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public float getZLevel() {
        return this.zLevel;
    }

    @Override
    public IDrawable setZLevel(float zLevel) {
        this.zLevel = zLevel;
        for (IRect rect : this.rects.values()) {
            if (!(rect instanceof IDrawable)) continue;
            ((IDrawable)((Object)rect)).setZLevel(zLevel);
        }
        return this;
    }

    @Override
    public void initGrowth() {
        super.initGrowth();
        for (IRect rect : this.rects.values()) {
            rect.initGrowth();
        }
        this.refreshRects();
    }

    public void refreshRects() {
        if (this.rects.size() > 0) {
            if (this.horizontalLayout) {
                if (this.startTopLeft) {
                    this.rects.get(0).setLeft(this.finalLeft());
                } else {
                    this.rects.get(this.rects.size() - 1).setRight(this.finalRight());
                }
                for (int i = 0; i < this.rects.size(); ++i) {
                    this.rects.get(i).setTop(this.centery() - this.rects.get(i).finalHeight() * 0.5);
                    this.rects.get(i).setLeft(this.rects.get(i).finalLeft());
                }
            } else {
                if (this.startTopLeft) {
                    this.rects.get(0).setTop(this.finalTop());
                } else {
                    this.rects.get(this.rects.size() - 1).setBottom(this.finalBottom());
                }
                for (int i = 0; i < this.rects.size(); ++i) {
                    this.rects.get(i).setTop(this.rects.get(i).finalTop());
                    this.rects.get(i).setLeft(this.centerx() - this.rects.get(i).finalWidth() * 0.5);
                }
            }
        }
        this.getBackground().ifPresent(rect -> {
            rect.setPosition(this.getPosition());
            rect.setWidth(this.finalWidth());
            rect.setHeight(this.finalHeight());
        });
    }

    @Override
    public void update(double mouseX, double mouseY) {
        for (IRect rect : this.rects.values()) {
            if (!(rect instanceof IGuiFrame)) continue;
            ((IGuiFrame)rect).update(mouseX, mouseY);
        }
    }

    @Override
    public IRect setWH(MusePoint2D wh) {
        return this;
    }

    @Override
    public void doThisOnChange() {
        this.refreshRects();
        super.doThisOnChange();
    }
}

