/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.client.gui.frame;

import com.github.lehjr.numina.util.client.gui.frame.IScrollable;
import com.github.lehjr.numina.util.client.gui.gemoetry.DrawableTile;
import com.github.lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import com.github.lehjr.numina.util.client.gui.gemoetry.RelativeRect;
import com.github.lehjr.numina.util.math.Colour;
import com.github.lehjr.numina.util.math.MuseMathUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.util.text.ITextComponent;

public class ScrollableFrame
extends DrawableTile
implements IScrollable {
    protected int buttonSize = 5;
    protected int totalSize;
    protected int currentScrollPixels;
    protected boolean visible = true;
    protected boolean enabled = true;
    protected float zLevel;
    boolean drawBackground = false;
    boolean drawBorder = false;

    public ScrollableFrame() {
        super(0.0, 0.0, 0.0, 0.0);
    }

    public ScrollableFrame(Colour background, Colour topBorder, Colour bottomBorder) {
        super(0.0, 0.0, 0.0, 0.0);
        this.setBackgroundColour(background);
        this.setBottomBorderColour(bottomBorder);
        this.setTopBorderColour(topBorder);
    }

    public ScrollableFrame(MusePoint2D topleft, MusePoint2D bottomright, Colour background, Colour topBorder, Colour bottomBorder) {
        super(topleft, bottomright);
        this.setBackgroundColour(background);
        this.setBottomBorderColour(bottomBorder);
        this.setTopBorderColour(topBorder);
    }

    @Override
    public int getButtonSize() {
        return this.buttonSize;
    }

    @Override
    public void setButtonSize(int buttonSize) {
        this.buttonSize = buttonSize;
    }

    void setDrawBackground(boolean drawBackground) {
        this.drawBackground = drawBackground;
    }

    void setDrawBorder(boolean drawBorder) {
        this.drawBorder = drawBorder;
    }

    @Override
    public RelativeRect getRect() {
        return this;
    }

    @Override
    public int getTotalSize() {
        return this.totalSize;
    }

    @Override
    public void setTotalSize(int totalSize) {
        this.totalSize = totalSize;
    }

    @Override
    public int getCurrentScrollPixels() {
        return this.currentScrollPixels;
    }

    @Override
    public void setCurrentScrollPixels(int scrollPixels) {
        this.currentScrollPixels = scrollPixels;
    }

    @Override
    public int getMaxScrollPixels() {
        return (int)Math.max((double)this.totalSize - this.height(), 0.0);
    }

    @Override
    public double getScrollAmount() {
        return 8.0;
    }

    @Override
    public void setScrollAmount(double scrollAmount) {
        this.currentScrollPixels = (int)MuseMathUtils.clampDouble(scrollAmount, 0.0, this.getMaxScrollPixels());
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return false;
    }

    @Override
    public void update(double mouseX, double mouseY) {
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float frameTime) {
        if (this.isVisible()) {
            if (this.drawBackground) {
                this.drawBackground(matrixStack);
            }
            if (this.drawBorder) {
                this.drawBorder(matrixStack, 0.0);
            }
            super.func_230430_a_(matrixStack, mouseX, mouseY, frameTime);
            this.preRender(matrixStack, mouseX, mouseY, frameTime);
            this.postRender(mouseX, mouseY, frameTime);
        }
    }

    @Override
    public List<ITextComponent> getToolTip(int x, int y) {
        return null;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }
}

