/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.client.gui.gemoetry;

import com.github.lehjr.numina.util.client.gui.gemoetry.IDrawable;
import com.github.lehjr.numina.util.client.gui.gemoetry.IDrawableRect;
import com.github.lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import com.github.lehjr.numina.util.client.gui.gemoetry.RelativeRect;
import com.github.lehjr.numina.util.math.Colour;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.nio.FloatBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.vector.Matrix4f;
import org.lwjgl.BufferUtils;

public class DrawableArrow
extends RelativeRect
implements IDrawableRect {
    Colour backgroundColour;
    Colour borderColour;
    boolean drawShaft = true;
    ArrowDirection facing = ArrowDirection.RIGHT;
    boolean shrinkBorder = true;
    boolean drawBorer = true;
    float zLevel;

    public DrawableArrow(float left, float top, float right, float bottom, boolean growFromMiddle, Colour backgroundColour, Colour borderColour) {
        super(left, top, right, bottom, growFromMiddle);
        this.backgroundColour = backgroundColour;
        this.borderColour = borderColour;
    }

    public DrawableArrow(float left, float top, float right, float bottom, Colour backgroundColour, Colour borderColour) {
        super(left, top, right, bottom, false);
        this.backgroundColour = backgroundColour;
        this.borderColour = borderColour;
    }

    public DrawableArrow(MusePoint2D ul, MusePoint2D br, Colour backgroundColour, Colour borderColour) {
        super(ul, br);
        this.backgroundColour = backgroundColour;
        this.borderColour = borderColour;
    }

    public DrawableArrow(RelativeRect ref, Colour backgroundColour, Colour borderColour) {
        super(ref.left(), ref.top(), ref.right(), ref.bottom(), ref.growFromMiddle());
        this.backgroundColour = backgroundColour;
        this.borderColour = borderColour;
    }

    public void setShrinkBorder(boolean shrinkBorder) {
        this.shrinkBorder = shrinkBorder;
    }

    public void setBackgroundColour(Colour colour) {
        this.backgroundColour = colour;
    }

    public void setDirection(ArrowDirection facing) {
        this.facing = facing;
    }

    public void setDrawShaft(boolean drawShaft) {
        this.drawShaft = drawShaft;
    }

    public void setDrawBorer(boolean drawBorer) {
        this.drawBorer = drawBorer;
    }

    FloatBuffer getVertexA(float shrinkBy, FloatBuffer buffer) {
        switch (this.facing) {
            case RIGHT: {
                buffer.put((float)(this.right() - (double)shrinkBy));
                buffer.put((float)this.centery());
                break;
            }
            case LEFT: {
                buffer.put((float)(this.left() + (double)shrinkBy));
                buffer.put((float)this.centery());
                break;
            }
            case UP: {
                buffer.put((float)this.centerx());
                buffer.put((float)(this.top() + (double)shrinkBy));
                break;
            }
            case DOWN: {
                buffer.put((float)this.centerx());
                buffer.put((float)(this.bottom() - (double)shrinkBy));
            }
        }
        return buffer;
    }

    FloatBuffer getVertexB(float shrinkBy, FloatBuffer buffer) {
        switch (this.facing) {
            case RIGHT: {
                buffer.put((float)((this.drawShaft ? this.centerx() + this.width() * (double)0.15f : this.left()) + (double)shrinkBy * 0.5));
                buffer.put((float)(this.centery() - this.height() * (double)0.4f + (this.drawShaft ? (double)shrinkBy * 2.5 : (double)shrinkBy)));
                break;
            }
            case LEFT: {
                buffer.put((float)((this.drawShaft ? (double)((float)(this.centerx() - this.width() * 0.15)) : this.right()) - (double)shrinkBy * 0.5));
                buffer.put((float)(this.centery() + this.height() * (double)0.4f - (this.drawShaft ? (double)shrinkBy * 2.5 : (double)shrinkBy)));
                break;
            }
            case UP: {
                buffer.put((float)(this.centerx() - this.width() * (double)0.4f + (this.drawShaft ? (double)shrinkBy * 2.5 : (double)shrinkBy)));
                buffer.put((float)((this.drawShaft ? this.centery() - this.height() * (double)0.15f : this.bottom()) - (double)shrinkBy * 0.5));
                break;
            }
            case DOWN: {
                buffer.put((float)(this.centerx() + this.width() * (double)0.4f - (this.drawShaft ? (double)shrinkBy * 2.5 : (double)shrinkBy)));
                buffer.put((float)((this.drawShaft ? this.centery() + this.height() * (double)0.15f : this.top()) + (double)shrinkBy * 0.5));
            }
        }
        return buffer;
    }

    FloatBuffer getVertexC(float shrinkBy, FloatBuffer buffer) {
        switch (this.facing) {
            case RIGHT: {
                buffer.put((float)(this.centerx() + this.width() * (double)0.15f + (double)shrinkBy));
                buffer.put((float)(this.centery() - this.height() * (double)0.15f + (double)shrinkBy));
                break;
            }
            case LEFT: {
                buffer.put((float)(this.centerx() - this.width() * (double)0.15f - (double)shrinkBy));
                buffer.put((float)(this.centery() + this.height() * (double)0.15f - (double)shrinkBy));
                break;
            }
            case UP: {
                buffer.put((float)(this.centerx() - this.width() * (double)0.15f + (double)shrinkBy));
                buffer.put((float)(this.centery() - this.height() * (double)0.15f - (double)shrinkBy));
                break;
            }
            case DOWN: {
                buffer.put((float)(this.centerx() + this.width() * (double)0.15f - (double)shrinkBy));
                buffer.put((float)(this.centery() + this.height() * (double)0.15f + (double)shrinkBy));
            }
        }
        return buffer;
    }

    FloatBuffer getVertexD(float shrinkBy, FloatBuffer buffer) {
        switch (this.facing) {
            case RIGHT: {
                buffer.put((float)(this.left() + (double)shrinkBy));
                buffer.put((float)(this.centery() - this.height() * (double)0.15f + (double)shrinkBy));
                break;
            }
            case LEFT: {
                buffer.put((float)(this.right() - (double)shrinkBy));
                buffer.put((float)(this.centery() + this.height() * (double)0.15f - (double)shrinkBy));
                break;
            }
            case UP: {
                buffer.put((float)(this.centerx() - this.width() * (double)0.15f + (double)shrinkBy));
                buffer.put((float)(this.bottom() - (double)shrinkBy));
                break;
            }
            case DOWN: {
                buffer.put((float)(this.centerx() + this.width() * (double)0.15f - (double)shrinkBy));
                buffer.put((float)(this.top() + (double)shrinkBy));
            }
        }
        return buffer;
    }

    FloatBuffer getVertexE(float shrinkBy, FloatBuffer buffer) {
        switch (this.facing) {
            case RIGHT: {
                buffer.put((float)(this.left() + (double)shrinkBy));
                buffer.put((float)(this.centery() + this.height() * (double)0.15f - (double)shrinkBy));
                break;
            }
            case LEFT: {
                buffer.put((float)(this.right() - (double)shrinkBy));
                buffer.put((float)(this.centery() - this.height() * (double)0.15f + (double)shrinkBy));
                break;
            }
            case UP: {
                buffer.put((float)(this.centerx() + this.width() * (double)0.15f - (double)shrinkBy));
                buffer.put((float)(this.bottom() - (double)shrinkBy));
                break;
            }
            case DOWN: {
                buffer.put((float)(this.centerx() - this.width() * (double)0.15f + (double)shrinkBy));
                buffer.put((float)(this.top() + (double)shrinkBy));
            }
        }
        return buffer;
    }

    FloatBuffer getVertexF(float shrinkBy, FloatBuffer buffer) {
        switch (this.facing) {
            case RIGHT: {
                buffer.put((float)(this.centerx() + this.width() * (double)0.15f + (double)shrinkBy));
                buffer.put((float)(this.centery() + this.height() * (double)0.15f - (double)shrinkBy));
                break;
            }
            case LEFT: {
                buffer.put((float)(this.centerx() - this.width() * (double)0.15f - (double)shrinkBy));
                buffer.put((float)(this.centery() - this.height() * (double)0.15f + (double)shrinkBy));
                break;
            }
            case UP: {
                buffer.put((float)(this.centerx() + this.width() * (double)0.15f - (double)shrinkBy));
                buffer.put((float)(this.centery() - this.height() * (double)0.15f - (double)shrinkBy));
                break;
            }
            case DOWN: {
                buffer.put((float)(this.centerx() - this.width() * (double)0.15f + (double)shrinkBy));
                buffer.put((float)(this.centery() + this.height() * (double)0.15f + (double)shrinkBy));
            }
        }
        return buffer;
    }

    FloatBuffer getVertexG(float shrinkBy, FloatBuffer buffer) {
        switch (this.facing) {
            case RIGHT: {
                buffer.put((float)((this.drawShaft ? this.centerx() + this.width() * (double)0.15f : this.left()) + (double)shrinkBy * 0.5));
                buffer.put((float)(this.centery() + this.height() * (double)0.4f - (this.drawShaft ? (double)shrinkBy * 2.5 : (double)shrinkBy)));
                break;
            }
            case LEFT: {
                buffer.put((float)((this.drawShaft ? (double)((float)(this.centerx() - this.width() * 0.15)) : this.right()) - (double)shrinkBy * 0.5));
                buffer.put((float)(this.centery() - this.height() * (double)0.4f + (this.drawShaft ? (double)shrinkBy * 2.5 : (double)shrinkBy)));
                break;
            }
            case UP: {
                buffer.put((float)(this.centerx() + this.width() * (double)0.4f - (this.drawShaft ? (double)shrinkBy * 2.5 : (double)shrinkBy)));
                buffer.put((float)((this.drawShaft ? this.centery() - this.height() * (double)0.15f : this.bottom()) - (double)shrinkBy * 0.5));
                break;
            }
            case DOWN: {
                buffer.put((float)(this.centerx() - this.width() * (double)0.4f + (this.drawShaft ? (double)shrinkBy * 2.5 : (double)shrinkBy)));
                buffer.put((float)((this.drawShaft ? this.centery() + this.height() * (double)0.15f : this.top()) + (double)shrinkBy * 0.5));
            }
        }
        return buffer;
    }

    void drawBackground(MatrixStack matrixStack) {
        this.preDraw(9, DefaultVertexFormats.field_181706_f);
        Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
        FloatBuffer vertices = BufferUtils.createFloatBuffer((int)6);
        this.getVertexA(0.0f, vertices);
        this.getVertexB(0.0f, vertices);
        this.getVertexG(0.0f, vertices);
        vertices.flip();
        vertices.rewind();
        this.addVerticesToBuffer(matrix4f, vertices, this.backgroundColour);
        this.drawTesselator();
        if (this.drawShaft) {
            this.preDraw(9, DefaultVertexFormats.field_181706_f);
            vertices = BufferUtils.createFloatBuffer((int)8);
            this.getVertexC(0.0f, vertices);
            this.getVertexD(0.0f, vertices);
            this.getVertexE(0.0f, vertices);
            this.getVertexF(0.0f, vertices);
            vertices.flip();
            vertices.rewind();
            this.addVerticesToBuffer(matrix4f, vertices, this.backgroundColour);
            this.drawTesselator();
        }
        this.postDraw();
    }

    void drawBorder(MatrixStack matrixStack) {
        if (this.drawBorer) {
            FloatBuffer vertices = BufferUtils.createFloatBuffer((int)(6 + (this.drawShaft ? 8 : 0)));
            this.preDraw(2, DefaultVertexFormats.field_181706_f);
            Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
            this.getVertexA(this.shrinkBorder ? 2.0f : 0.0f, vertices);
            this.getVertexB(this.shrinkBorder ? 2.0f : 0.0f, vertices);
            if (this.drawShaft) {
                this.getVertexC(this.shrinkBorder ? 2.0f : 0.0f, vertices);
                this.getVertexD(this.shrinkBorder ? 2.0f : 0.0f, vertices);
                this.getVertexE(this.shrinkBorder ? 2.0f : 0.0f, vertices);
                this.getVertexF(this.shrinkBorder ? 2.0f : 0.0f, vertices);
            }
            this.getVertexG(this.shrinkBorder ? 2.0f : 0.0f, vertices);
            vertices.flip();
            vertices.rewind();
            this.addVerticesToBuffer(matrix4f, vertices, this.borderColour);
            this.drawTesselator();
            this.postDraw();
        }
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.drawBackground(matrixStack);
        this.drawBorder(matrixStack);
    }

    public void drawBackground(MatrixStack matrixStack, float zLevel) {
        this.zLevel = zLevel;
        this.drawBackground(matrixStack);
    }

    public void drawBorder(MatrixStack matrixStack, float zLevel) {
        this.zLevel = zLevel;
        this.drawBorder(matrixStack);
    }

    public ArrowDirection getFacing() {
        return this.facing;
    }

    @Override
    public float getZLevel() {
        return this.zLevel;
    }

    @Override
    public IDrawable setZLevel(float zLevelIn) {
        this.zLevel = zLevelIn;
        return this;
    }

    public static enum ArrowDirection {
        UP(270),
        DOWN(90),
        LEFT(180),
        RIGHT(0);

        int rotation;

        private ArrowDirection(int rotation) {
            this.rotation = rotation;
        }

        public int getRotation() {
            return this.rotation;
        }
    }
}

