/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.client.gui.gemoetry;

import com.github.lehjr.numina.util.client.gui.gemoetry.DrawableRelativeRect;
import com.github.lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import com.github.lehjr.numina.util.client.gui.gemoetry.RelativeRect;
import com.github.lehjr.numina.util.math.Colour;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.FloatBuffer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.vector.Matrix4f;

public class DrawableRectangularGrid
extends DrawableRelativeRect {
    Colour gridColour;
    int gridHeight;
    int gridWidth;
    Double horizontalSegmentSize;
    Double verticleSegmentSize;
    final RelativeRect[] boxes;

    public DrawableRectangularGrid(double left, double top, double right, double bottom, boolean growFromMiddle, Colour insideColour, Colour outsideColour, Colour gridColour, int gridHeight, int gridWidth) {
        super(left, top, right, bottom, growFromMiddle, insideColour, outsideColour);
        this.gridColour = gridColour;
        this.gridHeight = gridHeight;
        this.gridWidth = gridWidth;
        this.boxes = new RelativeRect[gridHeight * gridWidth];
        this.setBoxes();
    }

    public DrawableRectangularGrid(double left, double top, double right, double bottom, Colour insideColour, Colour outsideColour, Colour gridColour, int gridHeight, int gridWidth) {
        super(left, top, right, bottom, false, insideColour, outsideColour);
        this.gridColour = gridColour;
        this.gridHeight = gridHeight;
        this.gridWidth = gridWidth;
        this.boxes = new RelativeRect[gridHeight * gridWidth];
        this.setBoxes();
    }

    public DrawableRectangularGrid(MusePoint2D ul, MusePoint2D br, Colour insideColour, Colour outsideColour, Colour gridColour, int gridHeight, int gridWidth) {
        super(ul, br, insideColour, outsideColour);
        this.gridColour = gridColour;
        this.gridHeight = gridHeight;
        this.gridWidth = gridWidth;
        this.boxes = new RelativeRect[gridHeight * gridWidth];
        this.setBoxes();
    }

    public DrawableRectangularGrid(RelativeRect ref, Colour insideColour, Colour outsideColour, Colour gridColour, int gridHeight, int gridWidth) {
        super(ref.left(), ref.top(), ref.right(), ref.bottom(), ref.growFromMiddle(), insideColour, outsideColour);
        this.gridColour = gridColour;
        this.gridHeight = gridHeight;
        this.gridWidth = gridWidth;
        this.boxes = new RelativeRect[gridHeight * gridWidth];
        this.setBoxes();
    }

    void setBoxes() {
        for (int i = 0; i < this.boxes.length; ++i) {
            this.boxes[i] = new RelativeRect(0.0, 0.0, 0.0, 0.0);
        }
    }

    public RelativeRect[] getBoxes() {
        return this.boxes;
    }

    void setupGrid() {
        this.horizontalSegmentSize = this.width() / (double)this.gridWidth;
        this.verticleSegmentSize = this.height() / (double)this.gridHeight;
        int i = 0;
        for (int y = 0; y < this.gridHeight; ++y) {
            for (int x = 0; x < this.gridWidth; ++x) {
                this.boxes[i].setLeft(this.horizontalSegmentSize * (double)x);
                this.boxes[i].setTop(this.verticleSegmentSize * (double)y);
                this.boxes[i].setWidth(this.horizontalSegmentSize);
                this.boxes[i].setHeight(this.verticleSegmentSize);
                if (i > 0) {
                    if (x > 0) {
                        this.boxes[i].setMeRightOf(this.boxes[i - 1]);
                    }
                    if (y > 0) {
                        this.boxes[i].setMeBelow(this.boxes[i - this.gridWidth]);
                    }
                }
                ++i;
            }
        }
    }

    void drawGrid(MatrixStack matrixStack) {
        boolean needInt = false;
        for (int i = 0; i < this.boxes.length; ++i) {
            if (this.boxes[i] != null) continue;
            needInt = true;
            break;
        }
        if (needInt) {
            this.setBoxes();
        }
        if (this.horizontalSegmentSize == null || this.verticleSegmentSize == null || !this.doneGrowing()) {
            this.setupGrid();
        }
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
        if (this.gridHeight > 1) {
            for (double y = this.verticleSegmentSize + this.top(); y < this.bottom(); y += this.verticleSegmentSize.doubleValue()) {
                buffer.func_227888_a_(matrix4f, (float)this.left(), (float)y, this.zLevel).func_227885_a_(this.gridColour.r, this.gridColour.g, this.gridColour.b, this.gridColour.a).func_181675_d();
                buffer.func_227888_a_(matrix4f, (float)this.right(), (float)y, this.zLevel).func_227885_a_(this.gridColour.r, this.gridColour.g, this.gridColour.b, this.gridColour.a).func_181675_d();
            }
        }
        if (this.gridWidth > 1) {
            for (double x = this.horizontalSegmentSize + this.left(); x < this.right(); x += this.horizontalSegmentSize.doubleValue()) {
                buffer.func_227888_a_(matrix4f, (float)x, (float)this.top(), this.zLevel).func_227885_a_(this.gridColour.r, this.gridColour.g, this.gridColour.b, this.gridColour.a).func_181675_d();
                buffer.func_227888_a_(matrix4f, (float)x, (float)this.bottom(), this.zLevel).func_227885_a_(this.gridColour.r, this.gridColour.g, this.gridColour.b, this.gridColour.a).func_181675_d();
            }
        }
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    @Override
    public DrawableRelativeRect setLeft(double value) {
        double diff = value - this.left();
        super.setLeft(value);
        for (RelativeRect box : this.boxes) {
            if (box == null) continue;
            box.setLeft(box.left() + diff);
        }
        return this;
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float frameTime) {
        FloatBuffer vertices = this.preDraw(0.0);
        this.drawBackground(matrixStack, vertices);
        this.drawGrid(matrixStack);
        this.drawBorder(matrixStack, vertices);
    }
}

