/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.client.gui.gemoetry;

import com.github.lehjr.numina.util.client.gui.gemoetry.GradientAndArcCalculator;
import com.github.lehjr.numina.util.client.gui.gemoetry.IDrawable;
import com.github.lehjr.numina.util.client.gui.gemoetry.IDrawableRect;
import com.github.lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import com.github.lehjr.numina.util.client.gui.gemoetry.RelativeRect;
import com.github.lehjr.numina.util.math.Colour;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.nio.FloatBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import org.lwjgl.BufferUtils;

public class DrawableRelativeRect
extends RelativeRect
implements IDrawableRect {
    Colour backgroundColour;
    Colour borderColour;
    Colour backgroundColour2 = null;
    float cornerradius = 3.0f;
    float zLevel = 1.0f;
    boolean shrinkBorder = true;

    public DrawableRelativeRect(double left, double top, double right, double bottom, boolean growFromMiddle, Colour backgroundColour, Colour borderColour) {
        super(left, top, right, bottom, growFromMiddle);
        this.backgroundColour = backgroundColour;
        this.borderColour = borderColour;
    }

    public DrawableRelativeRect(RelativeRect ref, Colour backgroundColour, Colour borderColour) {
        super(ref.left(), ref.top(), ref.right(), ref.bottom(), ref.growFromMiddle());
        this.backgroundColour = backgroundColour;
        this.borderColour = borderColour;
    }

    public DrawableRelativeRect(double left, double top, double right, double bottom, Colour backgroundColour, Colour borderColour) {
        super(left, top, right, bottom, false);
        this.backgroundColour = backgroundColour;
        this.borderColour = borderColour;
    }

    public DrawableRelativeRect(MusePoint2D ul, MusePoint2D br, Colour backgroundColour, Colour borderColour) {
        super(ul, br);
        this.backgroundColour = backgroundColour;
        this.borderColour = borderColour;
    }

    public DrawableRelativeRect(Colour backgroundColour, Colour borderColour) {
        this.backgroundColour = backgroundColour;
        this.borderColour = borderColour;
    }

    public DrawableRelativeRect(Colour backgroundColour, Colour borderColour, boolean growFromMiddle) {
        super(growFromMiddle);
        this.backgroundColour = backgroundColour;
        this.borderColour = borderColour;
    }

    @Override
    public DrawableRelativeRect copyOf() {
        return new DrawableRelativeRect(super.left(), super.top(), super.right(), super.bottom(), this.growFromMiddle, this.backgroundColour, this.borderColour);
    }

    @Override
    public float getZLevel() {
        return this.zLevel;
    }

    @Override
    public IDrawable setZLevel(float zLevelIn) {
        this.zLevel = zLevelIn;
        return this;
    }

    public void setShrinkBorder(boolean shrinkBorder) {
        this.shrinkBorder = shrinkBorder;
    }

    public DrawableRelativeRect setBackgroundColour(Colour backgroundColour) {
        this.backgroundColour = backgroundColour;
        return this;
    }

    public DrawableRelativeRect setSecondBackgroundColour(Colour backgroundColour2In) {
        this.backgroundColour2 = backgroundColour2In;
        return this;
    }

    public DrawableRelativeRect setBorderColour(Colour borderColour) {
        this.borderColour = borderColour;
        return this;
    }

    public FloatBuffer preDraw(double shrinkBy) {
        return this.preDraw(this.left() + shrinkBy, this.top() + shrinkBy, this.right() - shrinkBy, this.bottom() - shrinkBy);
    }

    public FloatBuffer preDraw(double left, double top, double right, double bottom) {
        FloatBuffer corner = GradientAndArcCalculator.getArcPoints((float)Math.PI, 4.712389f, this.getCornerradius(), (float)(left + (double)this.getCornerradius()), (float)(top + (double)this.getCornerradius()));
        FloatBuffer vertices = BufferUtils.createFloatBuffer((int)(corner.limit() * 4));
        vertices.put(corner);
        corner = GradientAndArcCalculator.getArcPoints(4.712389f, (float)Math.PI * 2, this.getCornerradius(), (float)(left + (double)this.getCornerradius()), (float)(bottom - (double)this.getCornerradius()));
        vertices.put(corner);
        corner = GradientAndArcCalculator.getArcPoints(0.0f, 1.5707964f, this.getCornerradius(), (float)(right - (double)this.getCornerradius()), (float)(bottom - (double)this.getCornerradius()));
        vertices.put(corner);
        corner = GradientAndArcCalculator.getArcPoints(1.5707964f, (float)Math.PI, this.getCornerradius(), (float)(right - (double)this.getCornerradius()), (float)(top + (double)this.getCornerradius()));
        vertices.put(corner);
        vertices.flip();
        return vertices;
    }

    public void drawBackground(MatrixStack matrixStack, FloatBuffer vertices) {
        this.drawBuffer(matrixStack, vertices, this.backgroundColour, 6);
    }

    public void drawBackground(MatrixStack matrixStack, FloatBuffer vertices, FloatBuffer colours) {
        this.drawBuffer(matrixStack, vertices, colours, 6);
    }

    public void drawBorder(MatrixStack matrixStack, FloatBuffer vertices) {
        this.drawBuffer(matrixStack, vertices, this.borderColour, 2);
    }

    void drawBuffer(MatrixStack matrixStack, FloatBuffer vertices, Colour colour, int glMode) {
        this.preDraw(glMode, DefaultVertexFormats.field_181706_f);
        this.addVerticesToBuffer(matrixStack.func_227866_c_().func_227870_a_(), vertices, colour);
        this.drawTesselator();
        this.postDraw();
    }

    void drawBuffer(MatrixStack matrixStack, FloatBuffer vertices, FloatBuffer colours, int glMode) {
        this.preDraw(glMode, DefaultVertexFormats.field_181706_f);
        this.addVerticesToBuffer(matrixStack.func_227866_c_().func_227870_a_(), vertices, colours);
        this.drawTesselator();
        this.postDraw();
    }

    public float getCornerradius() {
        return this.cornerradius;
    }

    public DrawableRelativeRect setCornerradius(float cornerradiusIn) {
        this.cornerradius = cornerradiusIn;
        return this;
    }

    public FloatBuffer getVertices(double shrinkBy) {
        return this.getVertices(this.left() + shrinkBy, this.top() + shrinkBy, this.right() - shrinkBy, this.bottom() - shrinkBy);
    }

    public FloatBuffer getVertices(double left, double top, double right, double bottom) {
        FloatBuffer corner = GradientAndArcCalculator.getArcPoints((float)Math.PI, 4.712389f, this.getCornerradius(), (float)(left + (double)this.getCornerradius()), (float)(top + (double)this.getCornerradius()));
        FloatBuffer vertices = BufferUtils.createFloatBuffer((int)(corner.limit() * 4));
        vertices.put(corner);
        corner = GradientAndArcCalculator.getArcPoints(4.712389f, (float)Math.PI * 2, this.getCornerradius(), (float)(left + (double)this.getCornerradius()), (float)(bottom - (double)this.getCornerradius()));
        vertices.put(corner);
        corner = GradientAndArcCalculator.getArcPoints(0.0f, 1.5707964f, this.getCornerradius(), (float)(right - (double)this.getCornerradius()), (float)(bottom - (double)this.getCornerradius()));
        vertices.put(corner);
        corner = GradientAndArcCalculator.getArcPoints(1.5707964f, (float)Math.PI, this.getCornerradius(), (float)(right - (double)this.getCornerradius()), (float)(top + (double)this.getCornerradius()));
        vertices.put(corner);
        vertices.flip();
        return vertices;
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float frameTime) {
        FloatBuffer vertices = this.preDraw(0.0);
        if (this.backgroundColour2 != null) {
            FloatBuffer colours = GradientAndArcCalculator.getColourGradient(this.backgroundColour, this.backgroundColour2, vertices.limit() * 4);
            this.drawBackground(matrixStack, vertices, colours);
        } else {
            this.drawBackground(matrixStack, vertices);
        }
        if (this.shrinkBorder) {
            vertices = this.preDraw(1.0);
        } else {
            vertices.rewind();
        }
        this.drawBorder(matrixStack, vertices);
    }

    @Override
    public RelativeRect getRect() {
        return this;
    }

    @Override
    public String toString() {
        StringBuilder stringbuilder = new StringBuilder();
        stringbuilder.append(super.toString());
        stringbuilder.append("Background Colour: ").append(this.backgroundColour.toString()).append("\n");
        stringbuilder.append("Background Colour 2: ").append(this.backgroundColour2 == null ? "null" : this.backgroundColour2.toString()).append("\n");
        stringbuilder.append("Border Colour: ").append(this.borderColour.toString()).append("\n");
        return stringbuilder.toString();
    }
}

