/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.client.gui.gemoetry;

import com.github.lehjr.numina.util.client.gui.gemoetry.IDrawable;
import com.github.lehjr.numina.util.client.gui.gemoetry.IDrawableRect;
import com.github.lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import com.github.lehjr.numina.util.client.gui.gemoetry.RelativeRect;
import com.github.lehjr.numina.util.math.Colour;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.nio.FloatBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.vector.Matrix4f;
import org.lwjgl.BufferUtils;

public class DrawableTile
extends RelativeRect
implements IDrawableRect {
    final float lineWidth = 1.0f;
    Colour topBorderColour = new Colour(0.216f, 0.216f, 0.216f, 1.0f);
    Colour bottomBorderColour = Colour.WHITE.withAlpha(0.8f);
    Colour backgroundColour = new Colour(0.545f, 0.545f, 0.545f, 1.0f);
    float zLevel = 0.0f;
    float shrinkBoarderBy = 0.0f;

    public DrawableTile(double left, double top, double right, double bottom, boolean growFromMiddle) {
        super(left, top, right, bottom, growFromMiddle);
    }

    public DrawableTile(double left, double top, double right, double bottom) {
        super(left, top, right, bottom, false);
    }

    public DrawableTile(MusePoint2D ul, MusePoint2D br) {
        super(ul, br);
    }

    public DrawableTile setTopBorderColour(Colour topBorderColour) {
        this.topBorderColour = topBorderColour;
        return this;
    }

    public Colour getTopBorderColour() {
        return this.topBorderColour;
    }

    public DrawableTile setBottomBorderColour(Colour bottomBorderColour) {
        this.bottomBorderColour = bottomBorderColour;
        return this;
    }

    public Colour getBottomBorderColour() {
        return this.bottomBorderColour;
    }

    public DrawableTile setBackgroundColour(Colour insideColour) {
        this.backgroundColour = insideColour;
        return this;
    }

    public Colour getBackgroundColour() {
        return this.backgroundColour;
    }

    public DrawableTile setBorderShrinkValue(float shrinkBy) {
        this.shrinkBoarderBy = shrinkBy;
        return this;
    }

    @Override
    public DrawableTile copyOf() {
        return new DrawableTile(super.left(), super.top(), super.right(), super.bottom(), this.growFromMiddle).setBackgroundColour(this.backgroundColour).setTopBorderColour(this.topBorderColour).setBottomBorderColour(this.bottomBorderColour);
    }

    public void internalDraw(MatrixStack matrixStack, Colour colour, int glMode, double shrinkBy) {
        this.internalDrawRect(matrixStack, this.left() + shrinkBy, this.top() + shrinkBy, this.right() - shrinkBy, this.bottom() - shrinkBy, colour, glMode);
    }

    public void internalDrawRect(MatrixStack matrixStack, double left, double top, double right, double bottom, Colour colourIn, int glMode) {
        this.preDraw(glMode, DefaultVertexFormats.field_181706_f);
        FloatBuffer vertices = BufferUtils.createFloatBuffer((int)8);
        Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
        vertices.put((float)right);
        vertices.put((float)top);
        vertices.put((float)left);
        vertices.put((float)top);
        vertices.put((float)left);
        vertices.put((float)bottom);
        vertices.put((float)right);
        vertices.put((float)bottom);
        vertices.flip();
        vertices.rewind();
        this.addVerticesToBuffer(matrix4f, vertices, colourIn);
        this.drawTesselator();
        this.postDraw();
    }

    public void drawBackground(MatrixStack matrixStack) {
        this.internalDraw(matrixStack, this.backgroundColour, 7, 0.0);
    }

    public void drawBorder(MatrixStack matrixStack, double shrinkBy) {
        this.internalDraw(matrixStack, this.topBorderColour, 2, shrinkBy);
    }

    public void drawDualColourBorder(MatrixStack matrixStack, float shrinkBy) {
        float halfWidth = 0.5f;
        this.internalDrawRect(matrixStack, this.left() + (double)shrinkBy - (double)halfWidth, this.top() + (double)shrinkBy - (double)halfWidth, this.right() - (double)shrinkBy + (double)halfWidth, this.top() + (double)shrinkBy + (double)halfWidth, this.topBorderColour, 7);
        this.internalDrawRect(matrixStack, this.left() + (double)shrinkBy - (double)halfWidth, this.top() + (double)shrinkBy - (double)halfWidth, this.left() + (double)shrinkBy + (double)halfWidth, this.bottom() - (double)shrinkBy + (double)halfWidth, this.topBorderColour, 7);
        this.internalDrawRect(matrixStack, this.left() + (double)shrinkBy - (double)halfWidth, this.bottom() - (double)shrinkBy - (double)halfWidth, this.right() - (double)shrinkBy + (double)halfWidth, this.bottom() - (double)shrinkBy + (double)halfWidth, this.bottomBorderColour, 7);
        this.internalDrawRect(matrixStack, this.right() - (double)shrinkBy - (double)halfWidth, this.top() + (double)shrinkBy - (double)halfWidth, this.right() - (double)shrinkBy + (double)halfWidth, this.bottom() - (double)shrinkBy + (double)halfWidth, this.bottomBorderColour, 7);
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float frameTime) {
        this.drawBackground(matrixStack);
        if (this.topBorderColour.equals(this.bottomBorderColour)) {
            this.drawBorder(matrixStack, this.shrinkBoarderBy);
        } else {
            this.drawDualColourBorder(matrixStack, this.shrinkBoarderBy);
        }
    }

    @Override
    public float getZLevel() {
        return this.zLevel;
    }

    @Override
    public IDrawable setZLevel(float zLevelIn) {
        this.zLevel = zLevelIn;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder stringbuilder = new StringBuilder(super.toString());
        stringbuilder.append("Background Colour: ").append(this.backgroundColour).append("\n");
        stringbuilder.append("Top Border Colour: ").append(this.topBorderColour).append("\n");
        stringbuilder.append("Bottom Border Colour: ").append(this.bottomBorderColour).append("\n");
        return stringbuilder.toString();
    }
}

