/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.client.gui.gemoetry;

import com.github.lehjr.numina.util.client.gui.gemoetry.FlyFromPointToPoint2D;
import com.github.lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public interface IRect {
    default public MusePoint2D center() {
        return new MusePoint2D(this.centerx(), this.centery());
    }

    default public IRect init(double left, double top, double right, double bottom) {
        this.setLeft(left);
        this.setTop(top);
        this.setWidth(right - left);
        this.setHeight(bottom - top);
        return this;
    }

    public MusePoint2D getUL();

    public MusePoint2D getWH();

    public double left();

    public double finalLeft();

    public double top();

    public double finalTop();

    public double right();

    public double finalRight();

    public double bottom();

    public double finalBottom();

    public double width();

    public double finalWidth();

    public double height();

    public double finalHeight();

    public IRect setUL(MusePoint2D var1);

    public IRect setWH(MusePoint2D var1);

    public IRect setLeft(double var1);

    public IRect setRight(double var1);

    public IRect setTop(double var1);

    public IRect setBottom(double var1);

    public IRect setWidth(double var1);

    public IRect setHeight(double var1);

    public void move(MusePoint2D var1);

    public void move(double var1, double var3);

    public void setPosition(MusePoint2D var1);

    default public MusePoint2D getPosition() {
        return this.center();
    }

    public boolean growFromMiddle();

    default public boolean containsPoint(double x, double y) {
        return x > this.left() && x < this.right() && y > this.top() && y < this.bottom();
    }

    default public double centerx() {
        return this.finalLeft() + this.finalWidth() * 0.5;
    }

    default public double centery() {
        return this.finalTop() + this.finalHeight() * 0.5;
    }

    default public boolean doneGrowing() {
        if (this.growFromMiddle()) {
            if (this.getUL() instanceof FlyFromPointToPoint2D && ((FlyFromPointToPoint2D)this.getUL()).doneFlying()) {
                return true;
            }
            return this.getWH() instanceof FlyFromPointToPoint2D && ((FlyFromPointToPoint2D)this.getWH()).doneFlying();
        }
        return true;
    }

    public void initGrowth();

    public IRect setMeLeftOf(IRect var1);

    public IRect setMeRightOf(IRect var1);

    public IRect setMeAbove(IRect var1);

    public IRect setMeBelow(IRect var1);

    public void setOnInit(IInit var1);

    public void onInit();

    public void doThisOnChange();

    public void setDoThisOnChange(IDoThis var1);

    @OnlyIn(value=Dist.CLIENT)
    default public Minecraft getMinecraft() {
        return Minecraft.func_71410_x();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface IInit {
        public void onInit(IRect var1);
    }

    public static interface IDoThis {
        public void doThisOnChange(IRect var1);
    }
}

