/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.client.render;

import com.github.lehjr.numina.util.client.gui.GuiIcon;
import com.github.lehjr.numina.util.math.Colour;
import com.github.lehjr.numina.util.math.MuseMathUtils;
import com.google.common.base.Preconditions;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public enum MuseIconUtils {
    INSTANCE;

    protected static GuiIcon icon;

    public static GuiIcon getIcon() {
        Preconditions.checkState((icon != null ? 1 : 0) != 0, (Object)"Calling icons too early.");
        return icon;
    }

    public static void setIconInstance(GuiIcon iconIn) {
        icon = iconIn;
    }

    static TextureAtlasSprite getMissingIcon() {
        return (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(MissingTextureSprite.func_195675_b());
    }

    public static void drawIconAt(float x, float y, TextureAtlasSprite icon, Colour colour) {
        MuseIconUtils.drawIconPartial(x, y, icon, colour, 0.0f, 0.0f, 16.0f, 16.0f);
    }

    public static void drawIconPartialOccluded(float x, float y, TextureAtlasSprite icon, Colour colour, float left, float top, float right, float bottom) {
        float xmin = MuseMathUtils.clampFloat(left - x, 0.0f, 16.0f);
        float ymin = MuseMathUtils.clampFloat(top - y, 0.0f, 16.0f);
        float xmax = MuseMathUtils.clampFloat(right - x, 0.0f, 16.0f);
        float ymax = MuseMathUtils.clampFloat(bottom - y, 0.0f, 16.0f);
        MuseIconUtils.drawIconPartial(x, y, icon, colour, xmin, ymin, xmax, ymax);
    }

    public static void drawIconPartial(double x, double y, TextureAtlasSprite icon, Colour colour, float left, float top, float right, float bottom) {
        if (icon == null) {
            icon = MuseIconUtils.getMissingIcon();
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        TextureManager textureManager = minecraft.func_110434_K();
        textureManager.func_110577_a(icon.func_229241_m_().func_229223_g_());
        RenderSystem.shadeModel((int)7425);
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tess.func_178180_c();
        if (colour != null) {
            colour.doGL();
        }
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float u0 = icon.func_94209_e();
        float v0 = icon.func_94206_g();
        float u1 = icon.func_94212_f();
        float v1 = icon.func_94210_h();
        float xoffset1 = left * (u1 - u0) / 16.0f;
        float yoffset1 = top * (v1 - v0) / 16.0f;
        float xoffset2 = right * (u1 - u0) / 16.0f;
        float yoffset2 = bottom * (v1 - v0) / 16.0f;
        bufferBuilder.func_225582_a_(x + (double)left, y + (double)top, 0.0);
        bufferBuilder.func_225583_a_(u0 + xoffset1, v0 + yoffset1);
        bufferBuilder.func_181675_d();
        bufferBuilder.func_225582_a_(x + (double)left, y + (double)bottom, 0.0);
        bufferBuilder.func_225583_a_(u0 + xoffset1, v0 + yoffset2);
        bufferBuilder.func_181675_d();
        bufferBuilder.func_225582_a_(x + (double)right, y + (double)bottom, 0.0);
        bufferBuilder.func_225583_a_(u0 + xoffset2, v0 + yoffset2);
        bufferBuilder.func_181675_d();
        bufferBuilder.func_225582_a_(x + (double)right, y + (double)top, 0.0);
        bufferBuilder.func_225583_a_(u0 + xoffset2, v0 + yoffset1);
        bufferBuilder.func_181675_d();
        tess.func_78381_a();
        RenderSystem.shadeModel((int)7424);
    }
}

