/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.client.render;

import com.github.lehjr.numina.constants.NuminaConstants;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public final class NuminaRenderState {
    public static final RenderState.TransparencyState TRANSLUCENT_TRANSPARENCY = new RenderState.TransparencyState("translucent_transparency_numina", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    public static final RenderState.DiffuseLightingState DIFFUSE_LIGHTING_ENABLED = new RenderState.DiffuseLightingState(true);
    public static final RenderState.AlphaState DEFAULT_ALPHA = new RenderState.AlphaState(0.003921569f);
    public static final RenderState.LightmapState LIGHTMAP_ENABLED = new RenderState.LightmapState(true);
    public static final RenderState.OverlayState OVERLAY_ENABLED = new RenderState.OverlayState(true);
    private static float lightmapLastX = 0.0f;
    private static float lightmapLastY = 0.0f;

    public static RenderType LIGHTNING_TEST() {
        RenderType.State state = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(NuminaConstants.LOCATION_NUMINA_GUI_TEXTURE_ATLAS, false, false)).func_228726_a_(TRANSLUCENT_TRANSPARENCY).func_228716_a_(DIFFUSE_LIGHTING_ENABLED).func_228713_a_(DEFAULT_ALPHA).func_228719_a_(LIGHTMAP_ENABLED).func_228722_a_(OVERLAY_ENABLED).func_228728_a_(true);
        return RenderType.func_228633_a_((String)"lighting_test", (VertexFormat)DefaultVertexFormats.field_227852_q_, (int)7, (int)256, (boolean)true, (boolean)true, (RenderType.State)state);
    }

    public static void on2D() {
        NuminaRenderState.glPushAttrib(8192);
        RenderSystem.disableDepthTest();
        RenderSystem.disableCull();
        RenderSystem.disableLighting();
    }

    public static void off2D() {
        RenderSystem.popAttributes();
    }

    public static void arraysOnColor() {
        GlStateManager.func_227770_y_((int)32884);
        GlStateManager.func_227770_y_((int)32886);
    }

    public static void arraysOnTexture() {
        GlStateManager.func_227770_y_((int)32884);
        GlStateManager.func_227770_y_((int)32888);
    }

    public static void arraysOff() {
        GlStateManager.func_227772_z_((int)32884);
        GlStateManager.func_227772_z_((int)32886);
        GlStateManager.func_227772_z_((int)32888);
    }

    public static void texturelessOn() {
        RenderSystem.disableTexture();
    }

    public static void texturelessOff() {
        RenderSystem.enableTexture();
    }

    public static void blendingOn() {
        RenderSystem.enableBlend();
    }

    public static void blendingOff() {
        RenderSystem.disableBlend();
    }

    public static void glPushAttrib(int mask) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GL11.glPushAttrib((int)mask);
    }

    public static void glEnable(int target) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GL11.glEnable((int)target);
    }

    private static void glScissor(int newx, int newy, int neww, int newh) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GL11.glScissor((int)newx, (int)newy, (int)neww, (int)newh);
    }

    public static void scissorsOn(double x, double y, double w, double h) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        NuminaRenderState.glPushAttrib(532480);
        RenderSystem.pushMatrix();
        Minecraft mc = Minecraft.func_71410_x();
        int dh = mc.func_228018_at_().func_198091_l();
        double scaleFactor = mc.func_228018_at_().func_198100_s();
        double newx = x * scaleFactor;
        double newy = (double)dh - h * scaleFactor - y * scaleFactor;
        double neww = w * scaleFactor;
        double newh = h * scaleFactor;
        NuminaRenderState.glEnable(3089);
        NuminaRenderState.glScissor((int)newx, (int)newy, (int)neww, (int)newh);
    }

    public static void scissorsOff() {
        RenderSystem.popMatrix();
        RenderSystem.popAttributes();
    }

    @Deprecated
    public static void glowOn() {
        NuminaRenderState.glPushAttrib(64);
        lightmapLastX = GlStateManager.lastBrightnessX;
        lightmapLastY = GlStateManager.lastBrightnessY;
        RenderHelper.func_74518_a();
        GlStateManager.func_227640_a_((int)33985, (float)240.0f, (float)240.0f);
    }

    @Deprecated
    public static void glowOff() {
        GlStateManager.func_227640_a_((int)33985, (float)lightmapLastX, (float)lightmapLastY);
        RenderHelper.func_227780_a_();
        RenderSystem.popAttributes();
    }
}

