/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.math;

import com.github.lehjr.numina.basemod.MuseLogger;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.minecraft.util.math.vector.Vector4f;
import org.lwjgl.opengl.GL11;

public class Colour {
    static final float div255 = 0.003921569f;
    public static final Colour WHITE = new Colour(1.0f, 1.0f, 1.0f, 1.0f);
    public static final Colour LIGHT_GREY = new Colour(0.753f, 0.753f, 0.753f, 1.0f);
    public static final Colour GREY = new Colour(0.502f, 0.502f, 0.502f, 1.0f);
    public static final Colour DARK_GREY = new Colour(0.251f, 0.251f, 0.251f, 1.0f);
    public static final Colour GREY_GUI_BACKGROUND = new Colour(0.776f, 0.776f, 0.776f, 1.0f);
    public static final Colour BLACK = new Colour(0.0f, 0.0f, 0.0f, 1.0f);
    public static final Colour RED = new Colour(1.0f, 0.0f, 0.0f, 1.0f);
    public static final Colour PINK = new Colour(1.0f, 0.686f, 0.686f, 1.0f);
    public static final Colour ORANGE = new Colour(1.0f, 0.7843f, 0.0f, 1.0f);
    public static final Colour YELLOW = new Colour(1.0f, 1.0f, 0.0f, 1.0f);
    public static final Colour GREEN = new Colour(0.0f, 1.0f, 0.0f, 1.0f);
    public static final Colour LIGHT_GREEN = new Colour(0.5f, 1.0f, 0.5f, 1.0f);
    public static final Colour DARK_GREEN = new Colour(0.0f, 0.8f, 0.2f, 1.0f);
    public static final Colour MAGENTA = new Colour(1.0f, 0.0f, 1.0f, 1.0f);
    public static final Colour CYAN = new Colour(0.0f, 1.0f, 1.0f, 1.0f);
    public static final Colour BLUE = new Colour(0.0f, 0.0f, 1.0f, 1.0f);
    public static final Colour LIGHT_BLUE = new Colour(0.5f, 0.5f, 1.0f, 1.0f);
    public static final Colour DARKBLUE = new Colour(0.0f, 0.0f, 0.5f, 1.0f);
    public static final Colour PURPLE = new Colour(0.6f, 0.1f, 0.9f, 1.0f);
    public float r;
    public float g;
    public float b;
    public float a;

    public Colour(float r, float g, float b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    public Colour(float r, float g, float b) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = 1.0f;
    }

    public Colour(int r, int g, int b) {
        this.r = (float)r * 0.003921569f;
        this.g = (float)g * 0.003921569f;
        this.b = (float)b * 0.003921569f;
        this.a = 1.0f;
    }

    public Vector4f getVec4F() {
        return new Vector4f(this.r, this.g, this.b, this.a);
    }

    public Colour(int c) {
        this.a = (float)(c >> 24 & 0xFF) * 0.003921569f;
        this.r = (float)(c >> 16 & 0xFF) * 0.003921569f;
        this.g = (float)(c >> 8 & 0xFF) * 0.003921569f;
        this.b = (float)(c & 0xFF) * 0.003921569f;
    }

    public Colour lighten(float amount) {
        this.r = Math.min(this.r + amount, 1.0f);
        this.g = Math.min(this.g + amount, 1.0f);
        this.b = Math.min(this.b + amount, 1.0f);
        return this;
    }

    public Colour darken(float amount) {
        this.r = Math.max(this.r - amount, 0.0f);
        this.g = Math.max(this.g - amount, 0.0f);
        this.b = Math.max(this.b - amount, 0.0f);
        return this;
    }

    public static int getInt(float r, float g, float b, float a) {
        int val = 0;
        val |= (int)(a * 255.0f) << 24;
        val |= (int)(r * 255.0f) << 16;
        val |= (int)(g * 255.0f) << 8;
        return val |= (int)(b * 255.0f);
    }

    public void doGL() {
        RenderSystem.color4f((float)this.r, (float)this.g, (float)this.b, (float)this.a);
    }

    public static Colour getGreyscale(float value, float alpha) {
        return new Colour(value, value, value, alpha);
    }

    public static void doGLByInt(int c) {
        float a = (float)(c >> 24 & 0xFF) * 0.003921569f;
        float r = (float)(c >> 16 & 0xFF) * 0.003921569f;
        float g = (float)(c >> 8 & 0xFF) * 0.003921569f;
        float b = (float)(c & 0xFF) * 0.003921569f;
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
    }

    public static Colour fromHexString(String hexString) {
        try {
            if (hexString == null || hexString.isEmpty()) {
                return WHITE;
            }
            return new Colour((int)Long.parseLong(hexString, 16));
        }
        catch (Exception e) {
            MuseLogger.logException("Failed to generate colour from Hex: ", e);
            return WHITE;
        }
    }

    public int getInt() {
        int val = 0;
        val |= (int)(this.a * 255.0f) << 24;
        val |= (int)(this.r * 255.0f) << 16;
        val |= (int)(this.g * 255.0f) << 8;
        return val |= (int)(this.b * 255.0f);
    }

    public Colour interpolate(Colour target, float d) {
        float complement = 1.0f - d;
        return new Colour(this.r * complement + target.r * d, this.g * complement + target.g * d, this.b * complement + target.b * d, this.a * complement + target.a * d);
    }

    public Colour withAlpha(float newalpha) {
        return new Colour(this.r, this.g, this.b, newalpha);
    }

    public float[] asArray() {
        return new float[]{this.r, this.g, this.b, this.a};
    }

    public double[] asDoubleArray() {
        return new double[]{this.r, this.g, this.b, this.a};
    }

    public String hexColour() {
        return Colour.hexDigits(this.r) + Colour.hexDigits(this.g) + Colour.hexDigits(this.b) + (this.a > 0.0f ? Colour.hexDigits(this.a) : "");
    }

    public static String hexDigits(float x) {
        int y = (int)(x * 255.0f);
        String hexDigits = "0123456789ABCDEF";
        return hexDigits.charAt(y / 16) + "" + hexDigits.charAt(y % 16);
    }

    public String toString() {
        return "Colour{r=" + this.r + ", g=" + this.g + ", b=" + this.b + ", a=" + this.a + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Colour colour = (Colour)o;
        return Double.compare(colour.r, this.r) == 0 && Double.compare(colour.g, this.g) == 0 && Double.compare(colour.b, this.b) == 0 && Double.compare(colour.a, this.a) == 0;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b), Float.valueOf(this.a));
    }

    public Colour copy() {
        return new Colour(this.r, this.g, this.b, this.a);
    }
}

