/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.string;

import com.github.lehjr.numina.util.capabilities.inventory.modechanging.IModeChangingItem;
import com.github.lehjr.numina.util.capabilities.inventory.modularitem.IModularItem;
import com.github.lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import com.github.lehjr.numina.util.string.MuseStringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.util.InputMappings;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

@OnlyIn(value=Dist.CLIENT)
public class AdditionalInfo {
    public static void appendHoverText(@Nonnull ItemStack stack, World worldIn, List currentTipList, ITooltipFlag advancedToolTips) {
        if (worldIn == null) {
            return;
        }
        stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModularItem.class::isInstance).map(IModularItem.class::cast).ifPresent(iItemHandler -> {
            if (iItemHandler instanceof IModeChangingItem) {
                ItemStack activeModule = ((IModeChangingItem)iItemHandler).getActiveModule();
                if (!activeModule.func_190926_b()) {
                    IFormattableTextComponent localizedName = (IFormattableTextComponent)activeModule.func_151000_E();
                    currentTipList.add(new TranslationTextComponent("tooltip.numina.mode").func_230529_a_((ITextComponent)new StringTextComponent(" ")).func_230529_a_((ITextComponent)localizedName.func_230530_a_(Style.field_240709_b_.func_240721_b_(TextFormatting.RED))));
                } else {
                    currentTipList.add(new TranslationTextComponent("tooltip.numina.changeModes"));
                }
            }
            if (AdditionalInfo.doAdditionalInfo()) {
                ArrayList<IFormattableTextComponent> installed = new ArrayList<IFormattableTextComponent>();
                HashMap fluids = new HashMap();
                for (ItemStack module : iItemHandler.getInstalledModules()) {
                    installed.add(((IFormattableTextComponent)module.func_151000_E()).func_230530_a_(Style.field_240709_b_.func_240721_b_(TextFormatting.LIGHT_PURPLE)));
                    module.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(fluidHandler -> {
                        int numTanks = fluidHandler.getTanks();
                        for (int i = 0; i < numTanks; ++i) {
                            FluidStack fluidStack = fluidHandler.getFluidInTank(i);
                            if (fluidStack.isEmpty()) continue;
                            int capacity = fluidHandler.getTankCapacity(i);
                            ITextComponent fluidName = fluidHandler.getFluidInTank(i).getDisplayName();
                            FluidInfo fluidInfo = fluids.getOrDefault(fluidName, new FluidInfo(fluidName)).addAmmount(fluidStack.getAmount()).addMax(capacity);
                            fluids.put(fluidName, fluidInfo);
                        }
                    });
                }
                if (fluids.size() > 0) {
                    for (FluidInfo info : fluids.values()) {
                        currentTipList.add(info.getOutput());
                    }
                }
                if (installed.size() == 0) {
                    String message = I18n.func_135052_a((String)"tooltip.numina.noModules", (Object[])new Object[0]);
                    currentTipList.addAll(MuseStringUtils.wrapStringToLength(message, 30));
                } else {
                    currentTipList.add(new TranslationTextComponent("tooltip.numina.installedModules"));
                    currentTipList.addAll(installed);
                }
            } else {
                currentTipList.add(AdditionalInfo.additionalInfoInstructions());
            }
        });
        stack.getCapability(PowerModuleCapability.POWER_MODULE).ifPresent(iPowerModule -> {
            if (AdditionalInfo.doAdditionalInfo()) {
                String description = I18n.func_135052_a((String)(stack.func_77973_b().func_77658_a() + ".desc"), (Object[])new Object[0]);
                currentTipList.addAll(MuseStringUtils.wrapStringToLength(description, 30));
            } else {
                currentTipList.add(AdditionalInfo.additionalInfoInstructions());
            }
        });
        stack.getCapability(CapabilityEnergy.ENERGY).ifPresent(energyCap -> currentTipList.add(new StringTextComponent(I18n.func_135052_a((String)"tooltip.numina.battery.energy", (Object[])new Object[]{MuseStringUtils.formatNumberShort(energyCap.getEnergyStored()), MuseStringUtils.formatNumberShort(energyCap.getMaxEnergyStored())})).func_230530_a_(Style.field_240709_b_.func_240721_b_(TextFormatting.AQUA).func_240722_b_(Boolean.valueOf(true)))));
    }

    public static ITextComponent additionalInfoInstructions() {
        return new TranslationTextComponent("tooltip.numina.pressShift").func_230530_a_(Style.field_240709_b_.func_240721_b_(TextFormatting.GRAY).func_240722_b_(Boolean.valueOf(true)));
    }

    public static List<ITextComponent> getItemInstalledModules(@Nonnull ItemStack stack) {
        return stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModularItem.class::isInstance).map(IModularItem.class::cast).map(iItemHandler -> {
            ArrayList<IFormattableTextComponent> moduleNames = new ArrayList<IFormattableTextComponent>();
            for (ItemStack module : iItemHandler.getInstalledModules()) {
                moduleNames.add(((IFormattableTextComponent)module.func_151000_E()).func_230530_a_(Style.field_240709_b_.func_240721_b_(TextFormatting.LIGHT_PURPLE)));
            }
            return moduleNames;
        }).orElse(new ArrayList());
    }

    public static boolean doAdditionalInfo() {
        return InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)340);
    }

    static class FluidInfo {
        TranslationTextComponent displayName;
        int currentAmount = 0;
        int maxAmount = 0;

        FluidInfo(ITextComponent displayName) {
            this.displayName = (TranslationTextComponent)displayName;
        }

        public ITextComponent getDisplayName() {
            return this.displayName;
        }

        public int getMaxAmount() {
            return this.maxAmount;
        }

        public int getCurrentAmount() {
            return this.currentAmount;
        }

        public FluidInfo addMax(int maxAmountIn) {
            this.maxAmount += maxAmountIn;
            return this;
        }

        public FluidInfo addAmmount(int currentAmountIn) {
            this.currentAmount += currentAmountIn;
            return this;
        }

        public ITextComponent getOutput() {
            return this.displayName.func_230529_a_((ITextComponent)new StringTextComponent(": ")).func_230529_a_((ITextComponent)new StringTextComponent(new StringBuilder(this.currentAmount).append("/").append(this.maxAmount).toString())).func_230530_a_(Style.field_240709_b_.func_240721_b_(TextFormatting.DARK_AQUA).func_240722_b_(Boolean.valueOf(true)));
        }
    }
}

