/*
 * Decompiled with CFR 0.152.
 */
package io.karma.calcium;

import codechicken.lib.render.block.BlockRenderingRegistry;
import codechicken.lib.render.block.ICCBlockRenderer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IRegistryDelegate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="calcium")
public final class CalciumMod {
    public static final String MODID = "calcium";
    public static final Logger LOGGER = LogManager.getLogger((String)"calcium");
    @OnlyIn(value=Dist.CLIENT)
    private static Map<IRegistryDelegate<Block>, ICCBlockRenderer> customBlockRenderers;
    @OnlyIn(value=Dist.CLIENT)
    private static Map<IRegistryDelegate<Fluid>, ICCBlockRenderer> customFluidRenderers;
    @OnlyIn(value=Dist.CLIENT)
    private static List<ICCBlockRenderer> customGlobalRenderers;

    public CalciumMod() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> bus.addListener(this::onClientSetup));
    }

    @Nonnull
    public static List<ICCBlockRenderer> getCustomRenderers(@Nonnull IBlockDisplayReader world, @Nonnull BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        FluidState fluidState = state.func_204520_s();
        Fluid fluid = fluidState.func_206886_c();
        ArrayList<ICCBlockRenderer> renderers = new ArrayList<ICCBlockRenderer>(customGlobalRenderers);
        for (Map.Entry<IRegistryDelegate<Block>, ICCBlockRenderer> entry : customBlockRenderers.entrySet()) {
            Block entryBlock = (Block)entry.getKey().get();
            if (!entryBlock.func_235332_a_(block)) continue;
            renderers.add(entry.getValue());
        }
        for (Map.Entry<IRegistryDelegate<Block>, ICCBlockRenderer> entry : customFluidRenderers.entrySet()) {
            Fluid entryFluid = (Fluid)entry.getKey().get();
            if (!entryFluid.func_207187_a(fluid)) continue;
            renderers.add(entry.getValue());
        }
        return renderers;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void onClientSetup(@Nonnull FMLClientSetupEvent e) {
        try {
            Field blockRenderersField = BlockRenderingRegistry.class.getDeclaredField("blockRenderers");
            blockRenderersField.setAccessible(true);
            customBlockRenderers = (Map)blockRenderersField.get(null);
            Field fluidRenderersField = BlockRenderingRegistry.class.getDeclaredField("fluidRenderers");
            fluidRenderersField.setAccessible(true);
            customFluidRenderers = (Map)fluidRenderersField.get(null);
            Field globalRenderersField = BlockRenderingRegistry.class.getDeclaredField("globalRenderers");
            globalRenderersField.setAccessible(true);
            customGlobalRenderers = (List)globalRenderersField.get(null);
        }
        catch (Throwable t) {
            LOGGER.error("Could not retrieve custom renderers");
        }
    }
}

