/*
 * Decompiled with CFR 0.152.
 */
package io.karma.calcium.client.mixins;

import codechicken.lib.render.block.ICCBlockRenderer;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import io.karma.calcium.CalciumMod;
import io.karma.calcium.client.render.SinkingVertexBuilder;
import java.util.Random;
import javax.annotation.Nonnull;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuffers;
import me.jellysquid.mods.sodium.client.render.pipeline.BlockRenderer;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.model.data.IModelData;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockRenderer.class}, remap=false)
public class BlockRendererMixin {
    private static final ThreadLocal<MatrixStack> matrixStack = ThreadLocal.withInitial(MatrixStack::new);
    @Shadow
    @Final
    private Random random;

    @Inject(method={"renderModel"}, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/client/renderer/model/IBakedModel;getModelData(Lnet/minecraft/world/IBlockDisplayReader;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;Lnet/minecraftforge/client/model/data/IModelData;)Lnet/minecraftforge/client/model/data/IModelData;", shift=At.Shift.AFTER)}, cancellable=true)
    private void onRenderModel(IBlockDisplayReader world, BlockState state, BlockPos pos, IBakedModel model, ChunkModelBuffers buffers, boolean cull, long seed, IModelData modelData, @Nonnull CallbackInfoReturnable<Boolean> cbi) {
        MatrixStack mStack = matrixStack.get();
        SinkingVertexBuilder builder = SinkingVertexBuilder.getInstance();
        for (ICCBlockRenderer renderer : CalciumMod.getCustomRenderers(world, pos)) {
            if (!renderer.canHandleBlock(world, pos, state)) continue;
            mStack.func_227867_d_();
            builder.reset();
            cbi.setReturnValue((Object)renderer.renderBlock(state, pos, world, mStack, (IVertexBuilder)builder, this.random, modelData));
            builder.flush(buffers);
            cbi.cancel();
        }
    }
}

