/*
 * Decompiled with CFR 0.152.
 */
package io.karma.calcium.client.render;

import codechicken.lib.colour.Colour;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import javax.annotation.Nonnull;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuffers;
import me.jellysquid.mods.sodium.client.render.chunk.format.ModelVertexSink;
import net.minecraft.util.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class SinkingVertexBuilder
implements IVertexBuilder {
    private static final ThreadLocal<SinkingVertexBuilder> instance = ThreadLocal.withInitial(SinkingVertexBuilder::new);
    private final ByteBuffer buffer = ByteBuffer.allocateDirect(0x200000).order(ByteOrder.nativeOrder());
    private final int[] sideCount = new int[ModelQuadFacing.values().length];
    private int currentVertex;
    private float x;
    private float y;
    private float z;
    private float nx;
    private float ny;
    private float nz;
    private float u;
    private float v;
    private int color;
    private int light;

    @Nonnull
    public static SinkingVertexBuilder getInstance() {
        return instance.get();
    }

    @Nonnull
    public IVertexBuilder func_225582_a_(double x, double y, double z) {
        this.x = (float)x;
        this.y = (float)y;
        this.z = (float)z;
        return this;
    }

    @Nonnull
    public IVertexBuilder func_225586_a_(int r, int g, int b, int a) {
        this.color = Colour.flipABGR((int)Colour.packRGBA((int)r, (int)g, (int)b, (int)a));
        return this;
    }

    @Nonnull
    public IVertexBuilder func_225583_a_(float u, float v) {
        this.u = u;
        this.v = v;
        return this;
    }

    @Nonnull
    public IVertexBuilder func_225585_a_(int u, int v) {
        return this;
    }

    @Nonnull
    public IVertexBuilder func_225587_b_(int u, int v) {
        this.light = v << 16 | u;
        return this;
    }

    @Nonnull
    public IVertexBuilder func_225584_a_(float x, float y, float z) {
        this.nx = x;
        this.ny = y;
        this.nz = z;
        return this;
    }

    public void func_181675_d() {
        Direction dir = Direction.func_218383_a((int)((int)this.nx), (int)((int)this.ny), (int)((int)this.nz));
        int normal = dir != null ? dir.ordinal() : -1;
        this.buffer.putInt(normal);
        this.buffer.putFloat(this.x);
        this.buffer.putFloat(this.y);
        this.buffer.putFloat(this.z);
        this.buffer.putFloat(this.u);
        this.buffer.putFloat(this.v);
        this.buffer.putInt(this.color);
        this.buffer.putInt(this.light);
        this.resetCurrentVertex();
        ++this.currentVertex;
    }

    public void reset() {
        this.buffer.rewind();
        this.currentVertex = 0;
        Arrays.fill(this.sideCount, 0);
        this.resetCurrentVertex();
    }

    public void flush(@Nonnull ChunkModelBuffers buffers) {
        ModelQuadFacing[] facings = ModelQuadFacing.values();
        int numQuads = this.currentVertex >> 2;
        for (int quadIdx = 0; quadIdx < numQuads; ++quadIdx) {
            int normal = this.buffer.getInt(quadIdx << 2 << 5);
            Direction dir = normal != -1 ? Direction.values()[normal] : null;
            ModelQuadFacing facing = dir != null ? ModelQuadFacing.fromDirection((Direction)dir) : ModelQuadFacing.UNASSIGNED;
            int n = facing.ordinal();
            this.sideCount[n] = this.sideCount[n] + 1;
        }
        for (ModelQuadFacing facing : facings) {
            int count = this.sideCount[facing.ordinal()];
            if (count == 0) continue;
            buffers.getSink(facing).ensureCapacity(count << 2);
        }
        int byteSize = this.currentVertex << 5;
        int sideMask = 0;
        this.buffer.rewind();
        while (this.buffer.position() < byteSize) {
            int normal = this.buffer.getInt();
            Direction dir = normal != -1 ? Direction.values()[normal] : null;
            ModelQuadFacing facing = dir != null ? ModelQuadFacing.fromDirection((Direction)dir) : ModelQuadFacing.UNASSIGNED;
            int facingIdx = facing.ordinal();
            ModelVertexSink sink = buffers.getSink(facing);
            this.writeQuadVertex(sink);
            this.buffer.getInt();
            this.writeQuadVertex(sink);
            this.buffer.getInt();
            this.writeQuadVertex(sink);
            this.buffer.getInt();
            this.writeQuadVertex(sink);
            sideMask = (byte)(sideMask | 1 << facingIdx);
        }
        for (ModelQuadFacing facing : facings) {
            if ((sideMask >> facing.ordinal() & 1) == 0) continue;
            buffers.getSink(facing).flush();
        }
    }

    private void writeQuadVertex(@Nonnull ModelVertexSink sink) {
        float x = this.buffer.getFloat();
        float y = this.buffer.getFloat();
        float z = this.buffer.getFloat();
        float u = this.buffer.getFloat();
        float v = this.buffer.getFloat();
        int color = this.buffer.getInt();
        int light = this.buffer.getInt();
        sink.writeQuad(x, y, z, color, u, v, light);
    }

    private void resetCurrentVertex() {
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
        this.nz = 0.0f;
        this.ny = 0.0f;
        this.nx = 0.0f;
        this.v = 0.0f;
        this.u = 0.0f;
        this.color = -1;
        this.light = 0;
    }
}

