/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.forge.event;

import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.api.event.DeathWaypointEvent;
import journeymap.client.api.impl.ClientAPI;
import journeymap.client.forge.event.EventHandlerManager;
import journeymap.client.properties.WaypointProperties;
import journeymap.client.waypoint.Waypoint;
import journeymap.client.waypoint.WaypointStore;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class StateTickHandler
implements EventHandlerManager.EventHandler {
    static boolean javaChecked = false;
    Minecraft mc = Minecraft.func_71410_x();
    int counter = 0;
    private boolean deathpointCreated;

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        this.mc.func_213239_aq().func_76320_a("journeymap");
        if (this.mc.field_71439_g != null && !this.mc.field_71439_g.func_70089_S()) {
            if (!this.deathpointCreated) {
                this.deathpointCreated = true;
                this.createDeathpoint();
            }
        } else {
            this.deathpointCreated = false;
        }
        if (!javaChecked && this.mc.field_71439_g != null && this.mc.field_71439_g.func_70089_S()) {
            this.checkJava();
        }
        try {
            if (this.counter == 20) {
                this.mc.func_213239_aq().func_76320_a("mainTasks");
                JourneymapClient.getInstance().performMainThreadTasks();
                this.counter = 0;
                this.mc.func_213239_aq().func_76319_b();
            } else if (this.counter == 10) {
                this.mc.func_213239_aq().func_76320_a("multithreadTasks");
                if (JourneymapClient.getInstance().isMapping().booleanValue() && this.mc.field_71441_e != null) {
                    JourneymapClient.getInstance().performMultithreadTasks();
                }
                ++this.counter;
                this.mc.func_213239_aq().func_76319_b();
            } else if (this.counter == 5 || this.counter == 15) {
                this.mc.func_213239_aq().func_76320_a("clientApiEvents");
                ClientAPI.INSTANCE.getClientEventManager().fireNextClientEvents();
                ++this.counter;
                this.mc.func_213239_aq().func_76319_b();
            } else {
                ++this.counter;
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().warn("Error during onClientTick: " + LogFormatter.toPartialString(t));
        }
        finally {
            this.mc.func_213239_aq().func_76319_b();
        }
    }

    private void createDeathpoint() {
        try {
            ClientPlayerEntity player = this.mc.field_71439_g;
            if (player == null) {
                Journeymap.getLogger().error("Lost reference to player before Deathpoint could be created");
                return;
            }
            WaypointProperties waypointProperties = JourneymapClient.getInstance().getWaypointProperties();
            boolean enabled = waypointProperties.managerEnabled.get() != false && waypointProperties.createDeathpoints.get() != false && JourneymapClient.getInstance().getStateHandler().isAllowDeathPoints();
            boolean cancelled = false;
            double playerY = MathHelper.func_76128_c((double)player.func_226278_cu_()) > 2 ? (double)MathHelper.func_76128_c((double)player.func_226278_cu_()) : 2.0;
            BlockPos pos = new BlockPos((double)MathHelper.func_76128_c((double)player.func_226277_ct_()), playerY, (double)MathHelper.func_76128_c((double)player.func_226281_cx_()));
            if (enabled) {
                RegistryKey dim = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_234923_W_();
                DeathWaypointEvent event = new DeathWaypointEvent(pos, (RegistryKey<World>)dim);
                ClientAPI.INSTANCE.getClientEventManager().fireDeathpointEvent(event);
                if (!event.isCancelled()) {
                    Waypoint deathpoint = Waypoint.at(pos, Waypoint.Type.Death, dim.func_240901_a_().toString());
                    WaypointStore.INSTANCE.save(deathpoint);
                } else {
                    cancelled = true;
                }
            }
            Journeymap.getLogger().info(String.format("%s died at %s. Deathpoints enabled: %s. Deathpoint created: %s", player.func_200200_C_(), pos, enabled, cancelled ? "cancelled" : Boolean.valueOf(true)));
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Unexpected Error in createDeathpoint(): " + LogFormatter.toString(t));
        }
    }

    private void checkJava() {
        javaChecked = true;
        try {
            Class.forName("java.util.Objects");
        }
        catch (ClassNotFoundException e) {
            try {
                String error = I18n.func_135052_a((String)"jm.error.java6", (Object[])new Object[0]);
                Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((ITextComponent)Constants.getStringTextComponent(error));
                Journeymap.getLogger().fatal("JourneyMap requires Java 7 or Java 8. Update your launcher profile to use a newer version of Java.");
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            JourneymapClient.getInstance().disable();
        }
    }
}

