/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model;

import com.google.common.cache.CacheLoader;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.UUID;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.api.model.WrappedEntity;
import journeymap.client.model.EntityHelper;
import journeymap.client.properties.CoreProperties;
import journeymap.common.Journeymap;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.Entity;
import net.minecraft.entity.INPC;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class EntityDTO
implements WrappedEntity,
Serializable {
    public final String entityId;
    public transient WeakReference<LivingEntity> entityLivingRef;
    public transient ResourceLocation entityIconLocation;
    public String iconLocation;
    public Boolean hostile;
    public double posX;
    public double posY;
    public double posZ;
    public int chunkCoordX;
    public int chunkCoordY;
    public int chunkCoordZ;
    private BlockPos chunkPos;
    public double heading;
    public ITextComponent customName;
    public String owner;
    public String profession;
    public String username;
    public String biome;
    public RegistryKey<World> dimension;
    public Boolean underground;
    public boolean invisible;
    public boolean sneaking;
    public boolean passiveAnimal;
    public boolean npc;
    public int color;
    private List<ITextComponent> entityToolTips;
    private boolean disabled = false;

    private EntityDTO(LivingEntity entity) {
        this.entityLivingRef = new WeakReference<LivingEntity>(entity);
        this.entityId = entity.func_110124_au().toString();
    }

    public void update(LivingEntity entity, boolean hostile) {
        LivingEntity attackTarget;
        Entity ownerEntity;
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity currentPlayer = Minecraft.func_71410_x().field_71439_g;
        this.dimension = DimensionHelper.getDimension((Entity)entity);
        this.posX = entity.func_213303_ch().func_82615_a();
        this.posY = entity.func_213303_ch().func_82617_b();
        this.posZ = entity.func_213303_ch().func_82616_c();
        this.chunkCoordX = entity.field_70176_ah;
        this.chunkCoordY = entity.field_70162_ai;
        this.chunkCoordZ = entity.field_70164_aj;
        this.chunkPos = new BlockPos(this.chunkCoordX, this.chunkCoordY, this.chunkCoordZ);
        this.heading = Math.round(entity.field_70177_z % 360.0f);
        this.disabled = false;
        this.entityToolTips = null;
        this.invisible = currentPlayer != null ? entity.func_98034_c((PlayerEntity)currentPlayer) : false;
        this.sneaking = entity.func_225608_bj_();
        CoreProperties coreProperties = JourneymapClient.getInstance().getCoreProperties();
        ResourceLocation entityIcon = null;
        int playerColor = coreProperties.getColor(coreProperties.colorPlayer);
        ScorePlayerTeam team = null;
        try {
            team = mc.field_71441_e.func_96441_U().func_96509_i(entity.func_189512_bd());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (entity instanceof PlayerEntity) {
            this.username = StringUtils.func_76338_a((String)entity.func_200200_C_().getString());
            try {
                playerColor = team != null ? team.func_178775_l().func_175746_b() : (currentPlayer.equals((Object)entity) ? coreProperties.getColor(coreProperties.colorSelf) : coreProperties.getColor(coreProperties.colorPlayer));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            entityIcon = DefaultPlayerSkin.func_177335_a();
            try {
                ClientPlayNetHandler client = Minecraft.func_71410_x().func_147114_u();
                NetworkPlayerInfo info = client.func_175102_a(entity.func_110124_au());
                if (info != null) {
                    entityIcon = info.func_178837_g();
                }
            }
            catch (Throwable t) {
                Journeymap.getLogger().error("Error looking up player skin: " + LogFormatter.toPartialString(t));
            }
        } else {
            this.username = null;
            entityIcon = EntityHelper.getIconTextureLocation((Entity)entity);
        }
        if (entityIcon != null) {
            this.entityIconLocation = entityIcon;
            this.iconLocation = entityIcon.toString();
        }
        if ((ownerEntity = this.getTamedOwner(entity)) != null) {
            this.owner = ownerEntity.func_200200_C_().getString();
        }
        ITextComponent customName = null;
        boolean passive = false;
        LivingEntity entityLiving = entity;
        if (entity.func_145818_k_() && entityLiving.func_94059_bO()) {
            customName = entity.func_200201_e();
        }
        if (!hostile && currentPlayer != null && (attackTarget = entity.func_94060_bK()) != null && attackTarget.func_110124_au().equals(currentPlayer.func_110124_au())) {
            hostile = true;
        }
        if (EntityHelper.isPassive(entity)) {
            passive = true;
        }
        if (entity instanceof VillagerEntity) {
            VillagerEntity villager = (VillagerEntity)entity;
            this.profession = villager.func_213700_eh().func_221130_b().func_221149_b().getRegistryName().func_110623_a();
        } else if (entity instanceof INPC) {
            this.npc = true;
            this.profession = null;
            this.passiveAnimal = false;
        } else {
            this.profession = null;
            this.passiveAnimal = passive;
        }
        this.customName = customName;
        this.hostile = hostile;
        this.color = entity instanceof PlayerEntity ? playerColor : (team != null ? team.func_178775_l().func_175746_b() : (this.owner != null ? coreProperties.getColor(coreProperties.colorPet) : (this.profession != null || this.npc ? coreProperties.getColor(coreProperties.colorVillager) : (hostile ? coreProperties.getColor(coreProperties.colorHostile) : coreProperties.getColor(coreProperties.colorPassive)))));
    }

    private Entity getTamedOwner(LivingEntity livingEntity) {
        ClientPlayerEntity currentPlayer = Minecraft.func_71410_x().field_71439_g;
        if (livingEntity instanceof TameableEntity) {
            LivingEntity ownerEntity = ((TameableEntity)livingEntity).func_70902_q();
            if (ownerEntity != null) {
                return ownerEntity;
            }
        } else if (livingEntity instanceof HorseEntity) {
            UUID ownerUuid = ((HorseEntity)livingEntity).func_184780_dh();
            if (currentPlayer != null && ownerUuid != null) {
                try {
                    String playerUuid = currentPlayer.func_110124_au().toString();
                    if (playerUuid.equals(ownerUuid.toString())) {
                        return currentPlayer;
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        return null;
    }

    @Override
    public String getEntityId() {
        return this.entityId;
    }

    @Override
    public WeakReference<LivingEntity> getEntityLivingRef() {
        return this.entityLivingRef;
    }

    @Override
    public ResourceLocation getEntityIconLocation() {
        return this.entityIconLocation;
    }

    @Override
    public Boolean getHostile() {
        return this.hostile;
    }

    @Override
    public Vector3d getPosition() {
        return ((LivingEntity)this.entityLivingRef.get()).func_213303_ch();
    }

    @Override
    public BlockPos getChunkPos() {
        return this.chunkPos;
    }

    @Override
    public double getHeading() {
        return this.heading;
    }

    @Override
    public ITextComponent getCustomName() {
        return this.customName;
    }

    @Override
    public Entity getOwner() {
        return this.getTamedOwner((LivingEntity)this.entityLivingRef.get());
    }

    @Override
    public String getProfession() {
        return this.profession;
    }

    @Override
    public String getPlayerName() {
        return this.username;
    }

    @Override
    public Biome getBiome() {
        return Minecraft.func_71410_x().field_71441_e.func_226691_t_(((LivingEntity)this.entityLivingRef.get()).func_233580_cy_());
    }

    @Override
    public RegistryKey<World> getDimension() {
        return this.dimension;
    }

    @Override
    public Boolean getUnderground() {
        return this.underground;
    }

    @Override
    public boolean isInvisible() {
        return this.invisible;
    }

    @Override
    public boolean isSneaking() {
        return this.sneaking;
    }

    @Override
    public boolean isPassiveAnimal() {
        return this.passiveAnimal;
    }

    @Override
    public boolean isNpc() {
        return this.npc;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public void setCustomName(String customName) {
        this.customName = Constants.getStringTextComponent(customName);
    }

    @Override
    public void setCustomName(TextComponent customName) {
        this.customName = customName;
    }

    @Override
    public void setColor(int color) {
        this.color = color;
    }

    @Override
    public void setDisable(boolean disable) {
        this.disabled = disable;
    }

    @Override
    public void setEntityIconLocation(ResourceLocation entityIconLocation) {
        this.entityIconLocation = entityIconLocation;
    }

    @Override
    public List<ITextComponent> getEntityToolTips() {
        return this.entityToolTips;
    }

    @Override
    public void setEntityToolTips(List<ITextComponent> entityToolTips) {
        this.entityToolTips = entityToolTips;
    }

    public static class SimpleCacheLoader
    extends CacheLoader<LivingEntity, EntityDTO> {
        public EntityDTO load(LivingEntity entity) throws Exception {
            return new EntityDTO(entity);
        }
    }
}

