/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model;

import com.google.common.collect.ImmutableSortedMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import journeymap.client.JourneymapClient;
import journeymap.client.api.event.forge.EntityRadarUpdateEvent;
import journeymap.client.api.impl.ClientAPI;
import journeymap.client.data.DataCache;
import journeymap.client.log.JMLogger;
import journeymap.client.log.StatTimer;
import journeymap.client.mod.impl.Pixelmon;
import journeymap.client.model.EntityDTO;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.common.util.PlayerRadarManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.HorseRenderer;
import net.minecraft.client.renderer.entity.RenderFacade;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.INPC;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class EntityHelper {
    public static EntityDistanceComparator entityDistanceComparator = new EntityDistanceComparator();
    public static EntityDTODistanceComparator entityDTODistanceComparator = new EntityDTODistanceComparator();
    public static EntityMapComparator entityMapComparator = new EntityMapComparator();
    private static final String[] HORSE_TEXTURES = new String[]{"textures/entity/horse/horse_white.png", "textures/entity/horse/horse_creamy.png", "textures/entity/horse/horse_chestnut.png", "textures/entity/horse/horse_brown.png", "textures/entity/horse/horse_black.png", "textures/entity/horse/horse_gray.png", "textures/entity/horse/horse_darkbrown.png"};

    public static List<EntityDTO> getEntitiesNearby(String timerName, int maxEntities, boolean hostile, Class ... entityClasses) {
        StatTimer timer = StatTimer.get("EntityHelper." + timerName);
        timer.start();
        Minecraft mc = Minecraft.func_71410_x();
        List<EntityDTO> list = new ArrayList<EntityDTO>();
        ArrayList allEntities = new ArrayList();
        mc.field_71441_e.func_217416_b().forEach(allEntities::add);
        AxisAlignedBB bb = EntityHelper.getBB((PlayerEntity)mc.field_71439_g);
        try {
            block2: for (Entity entity : allEntities) {
                if (!(entity instanceof LivingEntity) || !entity.func_70089_S() || !entity.field_70175_ag || !bb.func_72326_a(entity.func_174813_aQ())) continue;
                for (Class entityClass : entityClasses) {
                    if (!entityClass.isAssignableFrom(entity.getClass()) || !EntityHelper.isSpecialCreature(entity, hostile)) continue;
                    LivingEntity entityLivingBase = (LivingEntity)entity;
                    EntityDTO dto = DataCache.INSTANCE.getEntityDTO(entityLivingBase);
                    dto.update(entityLivingBase, hostile);
                    EntityRadarUpdateEvent event = new EntityRadarUpdateEvent(ClientAPI.INSTANCE.getLastUIState(), EntityRadarUpdateEvent.EntityType.MOB, dto);
                    MinecraftForge.EVENT_BUS.post((Event)event);
                    if (dto.isDisabled() || event.isCanceled()) continue block2;
                    list.add(dto);
                    continue block2;
                }
            }
            if (list.size() > maxEntities) {
                int before2 = list.size();
                EntityHelper.entityDTODistanceComparator.player = mc.field_71439_g;
                Collections.sort(list, entityDTODistanceComparator);
                list = list.subList(0, maxEntities);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().warn("Failed to " + timerName + ": " + LogFormatter.toString(t));
        }
        timer.stop();
        return list;
    }

    private static boolean isSpecialCreature(Entity entity, boolean hostile) {
        if (CreatureEntity.class.isAssignableFrom(entity.getClass())) {
            if (hostile && entity.func_200600_R().func_220339_d().equals((Object)EntityClassification.MONSTER)) {
                return true;
            }
            return !hostile && entity.func_200600_R().func_220339_d().equals((Object)EntityClassification.CREATURE);
        }
        return true;
    }

    public static List<EntityDTO> getMobsNearby() {
        return EntityHelper.getEntitiesNearby("getMobsNearby", JourneymapClient.getInstance().getCoreProperties().maxMobsData.get(), true, IMob.class, CreatureEntity.class);
    }

    public static List<EntityDTO> getVillagersNearby() {
        return EntityHelper.getEntitiesNearby("getVillagersNearby", JourneymapClient.getInstance().getCoreProperties().maxVillagersData.get(), false, VillagerEntity.class, INPC.class);
    }

    public static List<EntityDTO> getAnimalsNearby() {
        return EntityHelper.getEntitiesNearby("getAnimalsNearby", JourneymapClient.getInstance().getCoreProperties().maxAnimalsData.get(), false, AnimalEntity.class, GolemEntity.class, WaterMobEntity.class, CreatureEntity.class);
    }

    public static boolean isPassive(LivingEntity entityLiving) {
        if (entityLiving == null) {
            return false;
        }
        if (entityLiving instanceof IMob) {
            return false;
        }
        LivingEntity attackTarget = entityLiving.func_94060_bK();
        return attackTarget == null || !(attackTarget instanceof PlayerEntity) && !(attackTarget instanceof TameableEntity);
    }

    public static List<EntityDTO> getPlayersNearby() {
        StatTimer timer = StatTimer.get("EntityHelper.getPlayersNearby");
        timer.start();
        Minecraft mc = Minecraft.func_71410_x();
        List<PlayerEntity> allPlayers = new ArrayList();
        if (JourneymapClient.getInstance().getStateHandler().isPlayerTrackingEnabled()) {
            if (mc.func_147114_u().func_175106_d() != null && mc.func_147114_u().func_175106_d().size() > 1) {
                for (NetworkPlayerInfo onlinePlayer : mc.func_147114_u().func_175106_d()) {
                    PlayerEntity networkedPlayer;
                    if (onlinePlayer.func_178845_a().getId().equals(mc.field_71439_g.func_110124_au()) || (networkedPlayer = PlayerRadarManager.getInstance().getPlayers().get(onlinePlayer.func_178845_a().getId())) == null || networkedPlayer.field_70170_p.func_234923_W_() != Minecraft.func_71410_x().field_71439_g.field_70170_p.func_234923_W_()) continue;
                    allPlayers.add(networkedPlayer);
                }
            }
        } else {
            allPlayers.addAll(mc.field_71441_e.func_217369_A());
            allPlayers.remove(mc.field_71439_g);
        }
        int max = JourneymapClient.getInstance().getCoreProperties().maxPlayersData.get();
        if (allPlayers.size() > max) {
            EntityHelper.entityDistanceComparator.player = mc.field_71439_g;
            Collections.sort(allPlayers, entityDistanceComparator);
            allPlayers = allPlayers.subList(0, max);
        }
        ArrayList<EntityDTO> playerDTOs = new ArrayList<EntityDTO>(allPlayers.size());
        for (PlayerEntity player : allPlayers) {
            EntityDTO dto = DataCache.INSTANCE.getEntityDTO((LivingEntity)player);
            dto.update((LivingEntity)player, false);
            EntityRadarUpdateEvent event = new EntityRadarUpdateEvent(ClientAPI.INSTANCE.getLastUIState(), EntityRadarUpdateEvent.EntityType.PLAYER, dto);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (dto.isDisabled() || event.isCanceled()) continue;
            playerDTOs.add(dto);
        }
        timer.stop();
        return playerDTOs;
    }

    private static AxisAlignedBB getBB(PlayerEntity player) {
        int lateralDistance = JourneymapClient.getInstance().getCoreProperties().radarLateralDistance.get();
        int verticalDistance = JourneymapClient.getInstance().getCoreProperties().radarVerticalDistance.get();
        return EntityHelper.getBoundingBox(player, lateralDistance, verticalDistance);
    }

    public static AxisAlignedBB getBoundingBox(PlayerEntity player, double lateralDistance, double verticalDistance) {
        return player.func_174813_aQ().func_72314_b(lateralDistance, verticalDistance, lateralDistance);
    }

    public static Map<String, EntityDTO> buildEntityIdMap(List<? extends EntityDTO> list, boolean sort) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyMap();
        }
        if (sort) {
            Collections.sort(list, new EntityMapComparator());
        }
        LinkedHashMap<String, EntityDTO> idMap = new LinkedHashMap<String, EntityDTO>(list.size());
        for (EntityDTO entityDTO : list) {
            idMap.put("id" + entityDTO.entityId, entityDTO);
        }
        return ImmutableSortedMap.copyOf(idMap);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ResourceLocation getIconTextureLocation(Entity entity) {
        try {
            EntityRenderer entityRender = Minecraft.func_71410_x().func_175598_ae().func_78713_a(entity);
            ResourceLocation original = null;
            if (entityRender instanceof HorseRenderer) {
                HorseEntity horse = (HorseEntity)entity;
                original = ((HorseRenderer)entityRender).func_110775_a(horse);
            } else if (Pixelmon.loaded) {
                original = Pixelmon.INSTANCE.getPixelmonResource(entity);
                if (original != null) return original;
                original = RenderFacade.getEntityTexture(entityRender, entity);
            } else {
                original = RenderFacade.getEntityTexture(entityRender, entity);
            }
            if (original == null) {
                JMLogger.logOnce("Can't get entityTexture for " + entity.getClass() + " via " + entityRender.getClass(), null);
                return null;
            }
            if (original.func_110623_a().contains("/entity/")) return new ResourceLocation(original.func_110624_b(), original.func_110623_a().replace("/entity/", "/entity_icon/"));
            return null;
        }
        catch (Throwable t) {
            JMLogger.logOnce("Can't get entityTexture for " + entity.func_200200_C_(), t);
            return null;
        }
    }

    private static class EntityDTODistanceComparator
    implements Comparator<EntityDTO> {
        PlayerEntity player;

        private EntityDTODistanceComparator() {
        }

        @Override
        public int compare(EntityDTO o1, EntityDTO o2) {
            LivingEntity e1 = (LivingEntity)o1.entityLivingRef.get();
            LivingEntity e2 = (LivingEntity)o2.entityLivingRef.get();
            if (e1 == null || e2 == null) {
                return 0;
            }
            return Double.compare(e1.func_70068_e((Entity)this.player), e2.func_70068_e((Entity)this.player));
        }
    }

    private static class EntityDistanceComparator
    implements Comparator<Entity> {
        PlayerEntity player;

        private EntityDistanceComparator() {
        }

        @Override
        public int compare(Entity o1, Entity o2) {
            return Double.compare(o1.func_70068_e((Entity)this.player), o2.func_70068_e((Entity)this.player));
        }
    }

    private static class EntityMapComparator
    implements Comparator<EntityDTO> {
        private EntityMapComparator() {
        }

        @Override
        public int compare(EntityDTO o1, EntityDTO o2) {
            Integer n;
            Integer n2;
            Integer o1rank = 0;
            Integer o2rank = 0;
            if (o1.customName != null) {
                n2 = o1rank;
                n = o1rank = Integer.valueOf(o1rank + 1);
            } else if (o1.username != null) {
                o1rank = o1rank + 2;
            }
            if (o2.customName != null) {
                n2 = o2rank;
                n = o2rank = Integer.valueOf(o2rank + 1);
            } else if (o2.username != null) {
                o2rank = o2rank + 2;
            }
            return o1rank.compareTo(o2rank);
        }
    }
}

