/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.draw;

import com.mojang.blaze3d.matrix.MatrixStack;
import info.journeymap.shaded.earcut4j.Earcut;
import info.journeymap.shaded.org.jetbrains.annotations.NotNull;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import journeymap.client.api.display.PolygonOverlay;
import journeymap.client.api.model.MapPolygon;
import journeymap.client.api.model.TextProperties;
import journeymap.client.render.draw.BaseOverlayDrawStep;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.map.GridRenderer;
import net.minecraft.util.math.BlockPos;

public class DrawPolygonStep
extends BaseOverlayDrawStep<PolygonOverlay> {
    protected List<Point2D.Double> fillPoints = new ArrayList<Point2D.Double>();
    protected List<List<Point2D.Double>> strokePoints = new ArrayList<List<Point2D.Double>>();
    boolean onScreen;

    public DrawPolygonStep(PolygonOverlay polygon) {
        super(polygon);
    }

    @Override
    public void draw(MatrixStack mStack, DrawStep.Pass pass, double xOffset, double yOffset, GridRenderer gridRenderer, double fontScale, double rotation) {
        if (pass == DrawStep.Pass.Object) {
            if (((PolygonOverlay)this.overlay).getOuterArea().getPoints().isEmpty()) {
                this.onScreen = false;
                return;
            }
            this.onScreen = this.isOnScreen(xOffset, yOffset, gridRenderer, rotation);
            if (this.onScreen) {
                DrawUtil.drawPolygon(mStack, xOffset, yOffset, this.fillPoints, this.strokePoints, ((PolygonOverlay)this.overlay).getShapeProperties());
            }
        } else if (this.onScreen) {
            super.drawText(mStack, pass, xOffset, yOffset, gridRenderer, fontScale, rotation);
        }
    }

    @Override
    protected void updatePositions(GridRenderer gridRenderer, double rotation) {
        if (((PolygonOverlay)this.overlay).getOuterArea().getPoints().isEmpty()) {
            this.onScreen = false;
            return;
        }
        List points = DrawPolygonStep.triangulate((PolygonOverlay)this.overlay).stream().flatMap(poly -> poly.getPoints().stream()).collect(Collectors.toList());
        this.fillPoints.clear();
        for (BlockPos pos : points) {
            Point2D.Double pixel = gridRenderer.getBlockPixelInGrid(pos);
            if (this.fillPoints.isEmpty()) {
                this.screenBounds.setRect(pixel.x, pixel.y, 1.0, 1.0);
            } else {
                this.screenBounds.add(pixel);
            }
            this.fillPoints.add(pixel);
        }
        this.strokePoints.clear();
        this.strokePoints.add(DrawPolygonStep.toScreen(gridRenderer, ((PolygonOverlay)this.overlay).getOuterArea()));
        if (((PolygonOverlay)this.overlay).getHoles() != null) {
            for (MapPolygon hole : ((PolygonOverlay)this.overlay).getHoles()) {
                this.strokePoints.add(DrawPolygonStep.toScreen(gridRenderer, hole));
            }
        }
        TextProperties textProperties = ((PolygonOverlay)this.overlay).getTextProperties();
        this.labelPosition.setLocation(this.screenBounds.getCenterX() + (double)textProperties.getOffsetX(), this.screenBounds.getCenterY() + (double)textProperties.getOffsetY());
    }

    private static List<Point2D.Double> toScreen(@NotNull GridRenderer gridRenderer, @NotNull MapPolygon polygon) {
        ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>();
        for (BlockPos pos : polygon.getPoints()) {
            points.add(gridRenderer.getBlockPixelInGrid(pos));
        }
        return points;
    }

    public static List<MapPolygon> triangulate(@NotNull PolygonOverlay overlay) {
        List holesList = Optional.ofNullable(overlay.getHoles()).orElse(new ArrayList());
        List blockPoints = Stream.concat(overlay.getOuterArea().getPoints().stream(), holesList.stream().flatMap(hole -> hole.getPoints().stream())).collect(Collectors.toList());
        double[] points = new double[blockPoints.size() * 2];
        for (int index = 0; index < blockPoints.size(); ++index) {
            points[index * 2] = ((BlockPos)blockPoints.get(index)).func_177958_n();
            points[index * 2 + 1] = ((BlockPos)blockPoints.get(index)).func_177952_p();
        }
        int[] holes = new int[holesList.size()];
        int holeIndex = overlay.getOuterArea().getPoints().size();
        for (int index = 0; index < holesList.size(); ++index) {
            holes[index] = holeIndex;
            holeIndex += ((MapPolygon)holesList.get(index)).getPoints().size();
        }
        List<Integer> triangles = Earcut.earcut(points, holes, 2);
        ArrayList<MapPolygon> trianglePolys = new ArrayList<MapPolygon>();
        for (int index = 0; index < triangles.size(); index += 3) {
            ArrayList<BlockPos> trianglePoints = new ArrayList<BlockPos>();
            trianglePoints.add((BlockPos)blockPoints.get(triangles.get(index + 2)));
            trianglePoints.add((BlockPos)blockPoints.get(triangles.get(index + 1)));
            trianglePoints.add((BlockPos)blockPoints.get(triangles.get(index)));
            trianglePolys.add(new MapPolygon(trianglePoints));
        }
        return trianglePolys;
    }
}

