/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import journeymap.client.Constants;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.DropDownItem;
import journeymap.client.ui.component.Removable;
import journeymap.client.ui.component.ScrollPaneScreen;
import journeymap.client.ui.component.SelectableParent;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;

public class DropDownButton
extends Button
implements Removable,
SelectableParent {
    private static final int MAX_DISPLAY_SIZE = 6;
    private boolean visible = false;
    protected DropDownItem selected;
    protected List<DropDownItem> items;
    protected int paneWidth;
    protected Button.IPressable field_230697_t_;
    protected Glyph activeGlyph = Glyph.DOWN;
    protected int panelMargin = 2;
    protected ScrollPaneScreen paneScreen;
    protected int buttonBuffer = 50;

    public DropDownButton(String label, Button.IPressable onPress) {
        super(label, DropDownButton.emptyPressable());
        this.field_230697_t_ = onPress;
    }

    public void setItems(List<DropDownItem> items) {
        this.items = items;
        this.paneWidth = this.func_230998_h_();
        this.paneScreen = new ScrollPaneScreen(this, items, this.paneWidth, this.getPaneHeight(), this.getX(), this.getPanelLocation());
    }

    protected void setRenderSolidBackground(boolean value) {
        this.paneScreen.setRenderSolidBackground(value);
    }

    protected void setRenderDecorations(boolean value) {
        this.paneScreen.setRenderDecorations(value);
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        boolean buttonClicked = super.func_231044_a_(mouseX, mouseY, button);
        if (buttonClicked && !this.visible) {
            this.visible = true;
            this.setEnabled(false);
            this.paneScreen.setPaneX(this.getX());
            this.paneScreen.setPaneY(this.getPanelLocation());
            this.paneScreen.display();
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    @Override
    public void func_230430_a_(MatrixStack mStack, int mouseX, int mouseY, float partialTicks) {
        DrawUtil.drawLabel(mStack, (ITextComponent)Constants.getStringTextComponent(this.visible ? this.activeGlyph.getCode() : Glyph.CLOSED.getCode()), this.getX() + 16, this.getMiddleY() - 1, DrawUtil.HAlign.Left, DrawUtil.VAlign.Middle, 0, 0.0f, this.visible ? this.disabledLabelColor : this.getLabelColor(), this.visible ? 0.25f : 1.0f, 1.5, true);
        super.func_230430_a_(mStack, mouseX, mouseY, partialTicks);
    }

    protected int getPanelLocation() {
        MainWindow window = Minecraft.func_71410_x().func_228018_at_();
        int panelHeight = this.getPaneHeight();
        int windowBottom = window.func_198087_p();
        if (this.field_230691_m_ - (this.panelMargin + panelHeight) <= 0) {
            this.activeGlyph = Glyph.DOWN;
            return this.field_230691_m_ + this.panelMargin + this.field_230689_k_;
        }
        if (this.field_230691_m_ + (this.panelMargin + panelHeight) > windowBottom) {
            this.activeGlyph = Glyph.UP;
            return this.field_230691_m_ - panelHeight - this.panelMargin;
        }
        this.activeGlyph = Glyph.DOWN;
        return this.field_230691_m_ + this.panelMargin + this.field_230689_k_;
    }

    protected int getPaneHeight() {
        int size = Math.min(this.items.size(), 6);
        return size * (this.items.get(0).func_238483_d_() + 5);
    }

    @Override
    public void onRemove() {
        this.visible = false;
        this.setEnabled(true);
    }

    public int func_230998_h_() {
        int width = 0;
        if (this.items != null) {
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            for (DropDownItem item : this.items) {
                width = Math.max(width, fontRenderer.func_78256_a(this.getLabel(item)));
            }
            this.field_230688_j_ = width + this.buttonBuffer;
        }
        return this.field_230688_j_;
    }

    protected String getLabel(DropDownItem item) {
        return item.getLabel();
    }

    @Override
    public void setSelected(DropDownItem selected) {
        this.selected = selected;
        this.field_230697_t_.onPress((net.minecraft.client.gui.widget.button.Button)selected);
        this.func_238482_a_((ITextComponent)Constants.getStringTextComponent(selected.getLabel()));
    }

    protected DropDownItem getSelected() {
        return this.selected;
    }

    protected String getSelectedLabel() {
        return this.getLabel(this.selected);
    }

    public static enum Glyph {
        CLOSED("\u25b6"),
        UP("\u25b2"),
        DOWN("\u25bc");

        String code;

        private Glyph(String code) {
            this.code = code;
        }

        String getCode() {
            return this.code;
        }

        public String toString() {
            return this.code;
        }
    }
}

