/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;
import journeymap.client.Constants;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.texture.TextureCache;
import journeymap.client.render.texture.TextureImpl;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.Button;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;

public abstract class JmUI
extends Screen {
    protected final ITextComponent field_230704_d_;
    protected final int headerHeight = 35;
    protected final Logger logger = Journeymap.getLogger();
    protected int scaleFactor = 1;
    protected TextureImpl logo = TextureCache.getTexture(TextureCache.Logo);
    protected static Stack<Screen> returnDisplayStack = new Stack();
    protected boolean renderBottomBar = false;

    public JmUI(String title) {
        this(title, null);
    }

    public JmUI(String title, Screen returnDisplay) {
        super((ITextComponent)Constants.getStringTextComponent(title));
        this.field_230704_d_ = Constants.getStringTextComponent(title);
        returnDisplayStack.push(returnDisplay);
    }

    public Minecraft getMinecraft() {
        this.field_230706_i_ = Minecraft.func_71410_x();
        return this.field_230706_i_;
    }

    public void func_231158_b_(Minecraft minecraft, int width, int height) {
        super.func_231158_b_(minecraft, width, height);
        this.scaleFactor = (int)minecraft.func_228018_at_().func_198100_s();
    }

    public boolean func_231177_au__() {
        return true;
    }

    public FontRenderer getFontRenderer() {
        return this.field_230712_o_;
    }

    public void sizeDisplay(boolean scaled) {
        int glwidth = scaled ? this.field_230708_k_ : this.field_230706_i_.func_228018_at_().func_198105_m();
        int glheight = scaled ? this.field_230709_l_ : this.field_230706_i_.func_228018_at_().func_198083_n();
        DrawUtil.sizeDisplay(glwidth, glheight);
    }

    protected boolean isMouseOverButton(double mouseX, double mouseY) {
        for (int k = 0; k < this.field_230710_m_.size(); ++k) {
            Button button;
            net.minecraft.client.gui.widget.button.Button guibutton = (net.minecraft.client.gui.widget.button.Button)this.field_230710_m_.get(k);
            if (!(guibutton instanceof Button) || !(button = (Button)guibutton).mouseOver(mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int mouseEvent) {
        return super.func_231048_c_(mouseX, mouseY, mouseEvent);
    }

    protected void drawLogo(MatrixStack mStack) {
        if (this.logo.isDefunct()) {
            this.logo = TextureCache.getTexture(TextureCache.Logo);
        }
        DrawUtil.sizeDisplay(this.field_230706_i_.func_228018_at_().func_198109_k(), this.field_230706_i_.func_228018_at_().func_198091_l());
        DrawUtil.drawImage(mStack, this.logo, 8.0, 8.0, false, 0.5f, 0.0);
        DrawUtil.sizeDisplay(this.field_230708_k_, this.field_230709_l_);
    }

    protected void renderBottomBar(MatrixStack stack) {
        if (this.renderBottomBar) {
            int x0 = 0;
            int x1 = this.field_230708_k_;
            int y0 = 0;
            int y1 = this.field_230709_l_ - 30;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            this.field_230706_i_.func_110434_K().func_110577_a(AbstractGui.field_230663_f_);
            RenderSystem.enableDepthTest();
            RenderSystem.depthFunc((int)519);
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            bufferbuilder.func_225582_a_((double)x0, (double)y0, -100.0).func_225583_a_(0.0f, (float)y0 / 32.0f).func_225586_a_(64, 64, 64, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)(x0 + this.field_230708_k_), (double)y0, -100.0).func_225583_a_((float)this.field_230708_k_ / 32.0f, (float)y0 / 32.0f).func_225586_a_(64, 64, 64, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)(x0 + this.field_230708_k_), 0.0, -100.0).func_225583_a_((float)this.field_230708_k_ / 32.0f, 0.0f).func_225586_a_(64, 64, 64, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)x0, 0.0, -100.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(64, 64, 64, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)x0, (double)this.field_230709_l_, -100.0).func_225583_a_(0.0f, (float)this.field_230709_l_ / 32.0f).func_225586_a_(64, 64, 64, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)(x0 + this.field_230708_k_), (double)this.field_230709_l_, -100.0).func_225583_a_((float)this.field_230708_k_ / 32.0f, (float)this.field_230709_l_ / 32.0f).func_225586_a_(64, 64, 64, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)(x0 + this.field_230708_k_), (double)y1, -100.0).func_225583_a_((float)this.field_230708_k_ / 32.0f, (float)y1 / 32.0f).func_225586_a_(64, 64, 64, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)x0, (double)y1, -100.0).func_225583_a_(0.0f, (float)y1 / 32.0f).func_225586_a_(64, 64, 64, 255).func_181675_d();
            tessellator.func_78381_a();
            RenderSystem.depthFunc((int)515);
            RenderSystem.disableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.disableAlphaTest();
            RenderSystem.shadeModel((int)7425);
            RenderSystem.disableTexture();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            bufferbuilder.func_225582_a_((double)x0, (double)(y0 + 4), 0.0).func_225586_a_(0, 0, 0, 0).func_181675_d();
            bufferbuilder.func_225582_a_((double)x1, (double)(y0 + 4), 0.0).func_225586_a_(0, 0, 0, 0).func_181675_d();
            bufferbuilder.func_225582_a_((double)x1, (double)y0, 0.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)x0, (double)y0, 0.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)x0, (double)y1, 0.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)x1, (double)y1, 0.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)x1, (double)(y1 - 4), 0.0).func_225586_a_(0, 0, 0, 0).func_181675_d();
            bufferbuilder.func_225582_a_((double)x0, (double)(y1 - 4), 0.0).func_225586_a_(0, 0, 0, 0).func_181675_d();
            tessellator.func_78381_a();
        }
    }

    protected void drawTitle(MatrixStack mStack) {
        DrawUtil.drawRectangle(mStack, 0.0, 0.0, this.field_230708_k_, 35.0, 0, 0.4f);
        DrawUtil.drawLabel(mStack, this.field_230704_d_, this.field_230708_k_ / 2, 17.0, DrawUtil.HAlign.Center, DrawUtil.VAlign.Middle, 0, 0.0f, Color.CYAN.getRGB(), 1.0f, 1.0, true, 0.0);
        StringTextComponent apiVersion = Constants.getStringTextComponent("API v1.8-SNAPSHOT");
        DrawUtil.drawLabel(mStack, (ITextComponent)apiVersion, this.field_230708_k_ - 10, 17.0, DrawUtil.HAlign.Left, DrawUtil.VAlign.Middle, 0, 0.0f, 0xCCCCCC, 1.0f, 0.5, true, 0.0);
    }

    public void func_231160_c_() {
        this.field_230710_m_.clear();
    }

    public void func_230446_a_(MatrixStack mStack) {
        if (Minecraft.func_71410_x().field_71441_e == null) {
            this.drawGradientRect(mStack, 0, 0, this.field_230708_k_, this.field_230709_l_, -1072689136, -804253680);
        } else {
            super.func_230446_a_(mStack);
        }
    }

    protected abstract void layoutButtons(MatrixStack var1);

    public List getButtonList() {
        return this.field_230710_m_;
    }

    public void func_230430_a_(MatrixStack mStack, int x, int y, float par3) {
        try {
            this.func_230446_a_(mStack);
            this.renderBottomBar(mStack);
            this.layoutButtons(mStack);
            this.drawTitle(mStack);
            this.drawLogo(mStack);
            List<IReorderingProcessor> tooltip = null;
            for (int k = 0; k < this.field_230710_m_.size(); ++k) {
                Button button;
                net.minecraft.client.gui.widget.button.Button guibutton = (net.minecraft.client.gui.widget.button.Button)this.field_230710_m_.get(k);
                guibutton.func_230430_a_(mStack, x, y, 0.0f);
                if (tooltip != null || !(guibutton instanceof Button) || !(button = (Button)guibutton).mouseOver(x, y)) continue;
                tooltip = button.getTooltip();
            }
            if (tooltip != null && !tooltip.isEmpty()) {
                this.renderWrappedToolTip(mStack, tooltip, x, y, this.getFontRenderer());
                RenderHelper.func_74518_a();
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Error in UI: " + LogFormatter.toString(t));
            this.closeAndReturn();
        }
    }

    public void drawGradientRect(MatrixStack mStack, int p_73733_1_, int p_73733_2_, int p_73733_3_, int p_73733_4_, int p_73733_5_, int p_73733_6_) {
        super.func_238468_a_(mStack, p_73733_1_, p_73733_2_, p_73733_3_, p_73733_4_, p_73733_5_, p_73733_6_);
    }

    public void close() {
    }

    protected void closeAndReturn() {
        if (returnDisplayStack == null || returnDisplayStack.peek() == null) {
            if (this.field_230706_i_.field_71441_e != null) {
                UIManager.INSTANCE.openFullscreenMap();
            } else {
                UIManager.INSTANCE.closeAll();
            }
        } else {
            UIManager.INSTANCE.open(returnDisplayStack.pop());
        }
    }

    public boolean func_231042_a_(char c, int i) {
        return super.func_231042_a_(c, i);
    }

    public void setRenderBottomBar(boolean renderBottomBar) {
        this.renderBottomBar = renderBottomBar;
    }

    public boolean func_231046_a_(int key, int value, int modifier) {
        switch (key) {
            case 256: {
                this.closeAndReturn();
                return true;
            }
        }
        return super.func_231046_a_(key, value, modifier);
    }

    public void renderTooltip(MatrixStack mStack, String[] tooltip, int mouseX, int mouseY) {
        List tooltips = Arrays.stream(tooltip).map(e -> IReorderingProcessor.func_242239_a((String)e, (Style)Style.field_240709_b_)).collect(Collectors.toList());
        this.renderWrappedToolTip(mStack, tooltips, mouseX, mouseY, this.getFontRenderer());
    }

    public Screen getReturnDisplay() {
        return returnDisplayStack.peek();
    }

    public void renderWrappedToolTip(MatrixStack mStack, List tooltip, int mouseX, int mouseY, FontRenderer fontRenderer) {
        if (!tooltip.isEmpty() && tooltip.get(0) instanceof IReorderingProcessor) {
            GL11.glDisable((int)32826);
            RenderHelper.func_74518_a();
            RenderSystem.disableLighting();
            RenderSystem.disableDepthTest();
            int maxLineWidth = 0;
            for (IReorderingProcessor line : tooltip) {
                int lineWidth = fontRenderer.func_243245_a(line);
                if (fontRenderer.func_78260_a()) {
                    lineWidth = (int)Math.ceil((double)lineWidth * 1.25);
                }
                if (lineWidth <= maxLineWidth) continue;
                maxLineWidth = lineWidth;
            }
            int drawX = mouseX + 12;
            int drawY = mouseY - 12;
            int boxHeight = 8;
            if (tooltip.size() > 1) {
                boxHeight += 2 + (tooltip.size() - 1) * 10;
            }
            if (drawX + maxLineWidth > this.field_230708_k_) {
                drawX -= 28 + maxLineWidth;
            }
            if (drawY + boxHeight + 6 > this.field_230709_l_) {
                drawY = this.field_230709_l_ - boxHeight - 6;
            }
            this.func_230926_e_(300);
            this.field_230707_j_.field_77023_b = 300.0f;
            int j1 = -267386864;
            this.drawGradientRect(mStack, drawX - 3, drawY - 4, drawX + maxLineWidth + 3, drawY - 3, j1, j1);
            this.drawGradientRect(mStack, drawX - 3, drawY + boxHeight + 3, drawX + maxLineWidth + 3, drawY + boxHeight + 4, j1, j1);
            this.drawGradientRect(mStack, drawX - 3, drawY - 3, drawX + maxLineWidth + 3, drawY + boxHeight + 3, j1, j1);
            this.drawGradientRect(mStack, drawX - 4, drawY - 3, drawX - 3, drawY + boxHeight + 3, j1, j1);
            this.drawGradientRect(mStack, drawX + maxLineWidth + 3, drawY - 3, drawX + maxLineWidth + 4, drawY + boxHeight + 3, j1, j1);
            int k1 = 0x505000FF;
            int l1 = (k1 & 0xFEFEFE) >> 1 | k1 & 0xFF000000;
            this.drawGradientRect(mStack, drawX - 3, drawY - 3 + 1, drawX - 3 + 1, drawY + boxHeight + 3 - 1, k1, l1);
            this.drawGradientRect(mStack, drawX + maxLineWidth + 2, drawY - 3 + 1, drawX + maxLineWidth + 3, drawY + boxHeight + 3 - 1, k1, l1);
            this.drawGradientRect(mStack, drawX - 3, drawY - 3, drawX + maxLineWidth + 3, drawY - 3 + 1, k1, k1);
            this.drawGradientRect(mStack, drawX - 3, drawY + boxHeight + 2, drawX + maxLineWidth + 3, drawY + boxHeight + 3, l1, l1);
            for (int i2 = 0; i2 < tooltip.size(); ++i2) {
                IReorderingProcessor line = (IReorderingProcessor)tooltip.get(i2);
                if (fontRenderer.func_78260_a()) {
                    int lineWidth = (int)Math.ceil((double)fontRenderer.func_243245_a(line) * 1.1);
                    fontRenderer.func_238407_a_(mStack, line, (float)(drawX + maxLineWidth - lineWidth), (float)drawY, -1);
                } else {
                    fontRenderer.func_238407_a_(mStack, line, (float)drawX, (float)drawY, -1);
                }
                if (i2 == 0) {
                    drawY += 2;
                }
                drawY += 10;
            }
            this.func_230926_e_(0);
            this.field_230707_j_.field_77023_b = 0.0f;
            RenderSystem.enableLighting();
            RenderSystem.enableDepthTest();
            RenderHelper.func_227780_a_();
            GL11.glEnable((int)32826);
        }
    }
}

