/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.minimap;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import journeymap.client.JourneymapClient;
import journeymap.client.api.display.Context;
import journeymap.client.api.impl.ClientAPI;
import journeymap.client.api.util.UIState;
import journeymap.client.data.DataCache;
import journeymap.client.feature.Feature;
import journeymap.client.feature.FeatureManager;
import journeymap.client.forge.event.MiniMapOverlayHandler;
import journeymap.client.log.JMLogger;
import journeymap.client.log.StatTimer;
import journeymap.client.model.EntityDTO;
import journeymap.client.model.MapState;
import journeymap.client.model.MapType;
import journeymap.client.properties.CoreProperties;
import journeymap.client.properties.MiniMapProperties;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.draw.DrawWayPointStep;
import journeymap.client.render.draw.RadarDrawStepFactory;
import journeymap.client.render.draw.WaypointDrawStepFactory;
import journeymap.client.render.map.GridRenderer;
import journeymap.client.render.texture.TextureCache;
import journeymap.client.render.texture.TextureImpl;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.minimap.DisplayVars;
import journeymap.client.ui.minimap.Position;
import journeymap.client.ui.minimap.ReticleOrientation;
import journeymap.client.ui.minimap.Selectable;
import journeymap.client.ui.minimap.Shape;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class MiniMap
implements Selectable {
    private static final MapState state = new MapState();
    private static final float lightmapS = 240.0f;
    private static final float lightmapT = 240.0f;
    private static final GridRenderer gridRenderer = new GridRenderer(Context.UI.Minimap);
    private final Minecraft mc = Minecraft.func_71410_x();
    private final WaypointDrawStepFactory waypointRenderer = new WaypointDrawStepFactory();
    private final RadarDrawStepFactory radarRenderer = new RadarDrawStepFactory();
    private TextureImpl playerArrowFg;
    private TextureImpl playerArrowBg;
    private int playerArrowColor;
    private MiniMapProperties miniMapProperties;
    private StatTimer drawTimer;
    private StatTimer refreshStateTimer;
    private DisplayVars dv;
    private boolean minimapDragging = false;
    private int mouseDragOffsetX = 0;
    private int mouseDragOffsetY = 0;
    private Point2D.Double centerPoint;
    private Rectangle2D.Double centerRect;
    private long initTime;
    private long lastAutoDayNightTime = -1L;
    private Boolean lastPlayerUnderground;

    public MiniMap(MiniMapProperties miniMapProperties) {
        gridRenderer.setGridSize(3);
        this.initTime = System.currentTimeMillis();
        this.setMiniMapProperties(miniMapProperties);
    }

    public static synchronized MapState state() {
        return state;
    }

    public static synchronized UIState uiState() {
        return gridRenderer.getUIState();
    }

    public static void updateUIState(boolean isActive) {
        if (Minecraft.func_71410_x().field_71441_e != null) {
            gridRenderer.updateUIState(isActive);
        }
    }

    public DisplayVars getDisplayVars() {
        return this.dv;
    }

    public boolean withinBounds(double mouseX, double mouseY) {
        double scale = Minecraft.func_71410_x().func_228018_at_().func_198100_s();
        double posX = mouseX * scale;
        double posY = mouseY * scale;
        DisplayVars vars = UIManager.INSTANCE.getMiniMap().getDisplayVars();
        return posX > (double)vars.textureX && posX < (double)(vars.textureX + vars.minimapWidth) && posY > (double)vars.textureY && posY < (double)(vars.textureY + vars.minimapHeight);
    }

    private void initGridRenderer() {
        gridRenderer.clear();
        state.requireRefresh();
        if (this.mc.field_71439_g == null || !this.mc.field_71439_g.func_70089_S()) {
            return;
        }
        state.refresh(this.mc, (PlayerEntity)this.mc.field_71439_g, this.miniMapProperties);
        MapType mapType = state.getMapType();
        int gridSize = this.miniMapProperties.getSize() <= 768 ? 3 : 5;
        gridRenderer.setGridSize(gridSize);
        gridRenderer.setContext(state.getWorldDir(), mapType);
        gridRenderer.center(state.getWorldDir(), mapType, this.mc.field_71439_g.func_226277_ct_(), this.mc.field_71439_g.func_226281_cx_(), this.miniMapProperties.zoomLevel.get());
        boolean highQuality = JourneymapClient.getInstance().getCoreProperties().tileHighDisplayQuality.get();
        gridRenderer.updateTiles(state.getMapType(), state.getZoom(), highQuality, this.mc.func_228018_at_().func_198105_m(), this.mc.func_228018_at_().func_198083_n(), true, 0.0, 0.0);
    }

    public void resetInitTime() {
        this.initTime = System.currentTimeMillis();
    }

    public void setMiniMapProperties(MiniMapProperties miniMapProperties) {
        this.miniMapProperties = miniMapProperties;
        MiniMap.state().requireRefresh();
        this.reset();
    }

    public MiniMapProperties getCurrentMinimapProperties() {
        return this.miniMapProperties;
    }

    public void drawMap(MatrixStack mStack) {
        this.drawMap(mStack, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawMap(MatrixStack mStack, boolean preview) {
        StatTimer timer = this.drawTimer;
        RenderHelper.func_74518_a();
        try {
            if (this.mc.field_71439_g == null || !this.mc.field_71439_g.func_70089_S()) {
                return;
            }
            gridRenderer.clearGlErrors(false);
            boolean doStateRefresh = state.shouldRefresh(this.mc, this.miniMapProperties);
            if (doStateRefresh) {
                timer = this.refreshStateTimer.start();
                this.autoDayNight();
                gridRenderer.setContext(state.getWorldDir(), state.getMapType());
                if (!preview) {
                    state.refresh(this.mc, (PlayerEntity)this.mc.field_71439_g, this.miniMapProperties);
                }
                ClientAPI.INSTANCE.flagOverlaysForRerender();
            } else {
                timer.start();
            }
            int height = this.mc.func_228018_at_().func_198105_m();
            int width = this.mc.func_228018_at_().func_198083_n();
            if (height == 0 || width == 0) {
                return;
            }
            boolean moved = gridRenderer.center(state.getWorldDir(), state.getMapType(), this.mc.field_71439_g.func_226277_ct_(), this.mc.field_71439_g.func_226281_cx_(), this.miniMapProperties.zoomLevel.get());
            if (moved || doStateRefresh) {
                gridRenderer.updateTiles(state.getMapType(), state.getZoom(), state.isHighQuality(), this.mc.func_228018_at_().func_198105_m(), this.mc.func_228018_at_().func_198083_n(), doStateRefresh || preview, 0.0, 0.0);
            }
            if (doStateRefresh) {
                boolean checkWaypointDistance = JourneymapClient.getInstance().getWaypointProperties().maxDistance.get() > 0;
                state.generateDrawSteps(this.mc, gridRenderer, this.waypointRenderer, this.radarRenderer, this.miniMapProperties, checkWaypointDistance);
                state.updateLastRefresh();
            }
            this.updateDisplayVars(false);
            long now = System.currentTimeMillis();
            DrawUtil.sizeDisplay(height, width);
            RenderSystem.glMultiTexCoord2f((int)33985, (float)240.0f, (float)240.0f);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)0);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableDepthTest();
            this.beginStencil(mStack);
            double rotation = 0.0;
            switch (this.dv.orientation) {
                case North: {
                    rotation = 0.0;
                    break;
                }
                case OldNorth: {
                    rotation = 90.0;
                    break;
                }
                case PlayerHeading: {
                    if (this.dv.shape != Shape.Circle) break;
                    rotation = 180.0f - this.mc.field_71439_g.field_70177_z;
                }
            }
            this.startMapRotation(mStack, rotation);
            try {
                Point2D.Double windowCenter;
                float alpha;
                long lastMapChangeTime;
                GL11.glTranslatef((float)this.dv.translateX, (float)this.dv.translateY, (float)0.0f);
                gridRenderer.draw(mStack, this.dv.terrainAlpha, this.miniMapProperties.backgroundAlpha.get().floatValue(), 0.0, 0.0, this.miniMapProperties.showGrid.get());
                gridRenderer.draw(mStack, state.getDrawSteps(), 0.0, 0.0, this.dv.fontScale, rotation);
                this.centerPoint = gridRenderer.getPixel(this.mc.field_71439_g.func_226277_ct_(), this.mc.field_71439_g.func_226281_cx_());
                this.centerRect = new Rectangle2D.Double(this.centerPoint.x - (double)(this.dv.minimapWidth / 2), this.centerPoint.y - (double)(this.dv.minimapHeight / 2), this.dv.minimapWidth, this.dv.minimapHeight);
                this.drawOnMapWaypoints(mStack, rotation);
                if (this.miniMapProperties.showSelf.get().booleanValue() && this.playerArrowFg != null) {
                    float playerArrowScale = this.miniMapProperties.selfDisplayScale.get().floatValue();
                    if (this.centerPoint != null) {
                        DrawUtil.drawColoredEntity(mStack, this.centerPoint.getX(), this.centerPoint.getY(), this.playerArrowBg, 0xFFFFFF, 1.0f, playerArrowScale, this.mc.field_71439_g.field_70177_z);
                        DrawUtil.drawColoredEntity(mStack, this.centerPoint.getX(), this.centerPoint.getY(), this.playerArrowFg, this.playerArrowColor, 1.0f, playerArrowScale, this.mc.field_71439_g.field_70177_z);
                    }
                }
                GL11.glTranslatef((float)(-this.dv.translateX), (float)(-this.dv.translateY), (float)0.0f);
                ReticleOrientation reticleOrientation = null;
                if (this.dv.showReticle) {
                    reticleOrientation = this.dv.minimapFrame.getReticleOrientation();
                    if (reticleOrientation == ReticleOrientation.Compass) {
                        this.dv.minimapFrame.drawReticle(mStack);
                    } else {
                        this.startMapRotation(mStack, this.mc.field_71439_g.field_70177_z);
                        this.dv.minimapFrame.drawReticle(mStack);
                        this.stopMapRotation(mStack, this.mc.field_71439_g.field_70177_z);
                    }
                }
                if (now - (lastMapChangeTime = state.getLastMapTypeChange()) <= 1000L) {
                    this.stopMapRotation(mStack, rotation);
                    GL11.glTranslatef((float)this.dv.translateX, (float)this.dv.translateY, (float)0.0f);
                    alpha = (float)Math.min(255L, Math.max(0L, 1100L - (now - lastMapChangeTime))) / 255.0f;
                    windowCenter = gridRenderer.getWindowPosition(this.centerPoint);
                    this.dv.getMapTypeStatus(state.getMapType()).draw(mStack, windowCenter, alpha, 0.0);
                    GL11.glTranslatef((float)(-this.dv.translateX), (float)(-this.dv.translateY), (float)0.0f);
                    this.startMapRotation(mStack, rotation);
                }
                if (now - this.initTime <= 1000L) {
                    this.stopMapRotation(mStack, rotation);
                    GL11.glTranslatef((float)this.dv.translateX, (float)this.dv.translateY, (float)1000.0f);
                    alpha = (float)Math.min(255L, Math.max(0L, 1100L - (now - this.initTime))) / 255.0f;
                    windowCenter = gridRenderer.getWindowPosition(this.centerPoint);
                    this.dv.getMapPresetStatus(state.getMapType(), this.miniMapProperties.getId()).draw(mStack, windowCenter, alpha, 0.0);
                    GL11.glTranslatef((float)(-this.dv.translateX), (float)(-this.dv.translateY), (float)-1000.0f);
                    this.startMapRotation(mStack, rotation);
                }
                this.endStencil();
                if (!this.dv.frameRotates && rotation != 0.0) {
                    this.stopMapRotation(mStack, rotation);
                }
                this.dv.minimapFrame.drawFrame(mStack);
                if (!this.dv.frameRotates && rotation != 0.0) {
                    this.startMapRotation(mStack, rotation);
                }
                if (this.dv.showCompass) {
                    this.dv.minimapCompassPoints.drawPoints(mStack, rotation);
                }
                GL11.glTranslatef((float)this.dv.translateX, (float)this.dv.translateY, (float)0.0f);
                this.drawOffMapWaypoints(mStack, rotation);
                if (this.dv.showCompass) {
                    GL11.glTranslatef((float)(-this.dv.translateX), (float)(-this.dv.translateY), (float)0.0f);
                    this.dv.minimapCompassPoints.drawLabels(mStack, rotation);
                }
            }
            finally {
                GL11.glPopMatrix();
            }
            this.dv.drawInfoLabels(mStack, now);
            DrawUtil.sizeDisplay((double)this.dv.mainWindow.func_198109_k() / this.dv.mainWindow.func_198100_s(), (double)this.dv.mainWindow.func_198091_l() / this.dv.mainWindow.func_198100_s());
        }
        catch (Throwable t) {
            JMLogger.logOnce("Error during MiniMap.drawMap(): " + t.getMessage(), t);
        }
        finally {
            this.cleanup();
            timer.stop();
            gridRenderer.clearGlErrors(true);
        }
    }

    private void drawOnMapWaypoints(MatrixStack mStack, double rotation) {
        boolean showLabel = this.miniMapProperties.showWaypointLabels.get();
        for (DrawStep.Pass pass : DrawStep.Pass.values()) {
            for (DrawWayPointStep drawWayPointStep : state.getDrawWaypointSteps()) {
                boolean onScreen = false;
                if (pass == DrawStep.Pass.Object) {
                    Point2D.Double waypointPos = drawWayPointStep.getPosition(0.0, 0.0, gridRenderer, true);
                    onScreen = this.isOnScreen(waypointPos, this.centerPoint, this.centerRect);
                    drawWayPointStep.setOnScreen(onScreen);
                } else {
                    onScreen = drawWayPointStep.isOnScreen();
                }
                if (!onScreen) continue;
                drawWayPointStep.setlabelScale(this.miniMapProperties.waypointLabelScale.get().floatValue());
                drawWayPointStep.setShowLabel(showLabel);
                drawWayPointStep.draw(mStack, pass, 0.0, 0.0, gridRenderer, this.dv.fontScale, rotation);
            }
        }
    }

    private void drawOffMapWaypoints(MatrixStack mStack, double rotation) {
        for (DrawWayPointStep drawWayPointStep : state.getDrawWaypointSteps()) {
            if (drawWayPointStep.isOnScreen()) continue;
            Point2D.Double point = this.getPointOnFrame(drawWayPointStep.getPosition(0.0, 0.0, gridRenderer, false), this.centerPoint, this.dv.minimapSpec.waypointOffset);
            drawWayPointStep.drawOffscreen(mStack, DrawStep.Pass.Object, point, rotation);
        }
    }

    private void startMapRotation(MatrixStack mStack, double rotation) {
        GL11.glPushMatrix();
        if (rotation % 360.0 != 0.0) {
            double width = this.dv.displayWidth / 2 + this.dv.translateX;
            double height = this.dv.displayHeight / 2 + this.dv.translateY;
            RenderSystem.translated((double)width, (double)height, (double)0.0);
            RenderSystem.rotatef((float)((float)rotation), (float)0.0f, (float)0.0f, (float)1.0f);
            RenderSystem.translated((double)(-width), (double)(-height), (double)0.0);
        }
        gridRenderer.updateRotation(rotation);
    }

    private void stopMapRotation(MatrixStack mStack, double rotation) {
        GL11.glPopMatrix();
        gridRenderer.updateRotation(rotation);
    }

    private boolean isOnScreen(Point2D.Double objectPixel, Point2D centerPixel, Rectangle2D.Double centerRect) {
        if (this.dv.shape == Shape.Circle) {
            return centerPixel.distance(objectPixel) < (double)(this.dv.minimapWidth / 2);
        }
        return centerRect.contains(gridRenderer.getWindowPosition(objectPixel));
    }

    private Point2D.Double getPointOnFrame(Point2D.Double objectPixel, Point2D centerPixel, double offset) {
        if (this.dv.shape == Shape.Circle) {
            double bearing = Math.atan2(objectPixel.getY() - centerPixel.getY(), objectPixel.getX() - centerPixel.getX());
            Point2D.Double framePos = new Point2D.Double((double)(this.dv.minimapWidth / 2) * Math.cos(bearing) + centerPixel.getX(), (double)(this.dv.minimapHeight / 2) * Math.sin(bearing) + centerPixel.getY());
            return framePos;
        }
        Rectangle2D.Double rect = new Rectangle2D.Double(this.dv.textureX - this.dv.translateX, this.dv.textureY - this.dv.translateY, this.dv.minimapWidth, this.dv.minimapHeight);
        if (objectPixel.x > rect.getMaxX()) {
            objectPixel.x = rect.getMaxX();
        } else if (objectPixel.x < rect.getMinX()) {
            objectPixel.x = rect.getMinX();
        }
        if (objectPixel.y > rect.getMaxY()) {
            objectPixel.y = rect.getMaxY();
        } else if (objectPixel.y < rect.getMinY()) {
            objectPixel.y = rect.getMinY();
        }
        return objectPixel;
    }

    private void beginStencil(MatrixStack mStack) {
        try {
            this.cleanup();
            DrawUtil.zLevel = 1000.0;
            RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            this.dv.minimapFrame.drawMask(mStack);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            DrawUtil.zLevel = 0.0;
            RenderSystem.depthMask((boolean)false);
            RenderSystem.depthFunc((int)516);
        }
        catch (Throwable t) {
            JMLogger.logOnce("Error during MiniMap.beginStencil()", t);
        }
    }

    private void endStencil() {
        try {
            RenderSystem.disableDepthTest();
        }
        catch (Throwable t) {
            JMLogger.logOnce("Error during MiniMap.endStencil()", t);
        }
    }

    private void cleanup() {
        try {
            DrawUtil.zLevel = 0.0;
            RenderSystem.depthMask((boolean)true);
            GL11.glClear((int)256);
            RenderSystem.enableDepthTest();
            RenderSystem.depthFunc((int)515);
            RenderSystem.enableAlphaTest();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.clearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        catch (Throwable t) {
            JMLogger.logOnce("Error during MiniMap.cleanup()", t);
        }
    }

    private void autoDayNight() {
        if (this.mc.field_71441_e != null) {
            boolean wasInCaves = false;
            if (this.miniMapProperties.showCaves.get().booleanValue() && FeatureManager.getInstance().isAllowed(Feature.MapCaves)) {
                EntityDTO player = DataCache.getPlayer();
                boolean neverChecked = this.lastPlayerUnderground == null;
                boolean playerUnderground = player.underground;
                if (neverChecked || playerUnderground != this.lastPlayerUnderground) {
                    this.lastPlayerUnderground = playerUnderground;
                    if (playerUnderground) {
                        state.setMapType(MapType.underground(player));
                    } else {
                        state.setMapType(MapType.from((MapType.Name)((Object)this.miniMapProperties.preferredMapType.get()), player));
                        wasInCaves = true;
                    }
                }
                MapType currentMapType = state.getMapType();
                if (playerUnderground && currentMapType.isUnderground() && currentMapType.vSlice != player.chunkCoordY) {
                    state.setMapType(MapType.underground(player));
                }
            }
            if (this.miniMapProperties.showDayNight.get().booleanValue() && (wasInCaves || state.getMapType().isDayOrNight())) {
                boolean neverChecked;
                long NIGHT = 13800L;
                long worldTime = this.mc.field_71441_e.func_72820_D() % 24000L;
                boolean bl = neverChecked = this.lastAutoDayNightTime == -1L;
                if (worldTime >= 13800L && (neverChecked || this.lastAutoDayNightTime < 13800L)) {
                    this.lastAutoDayNightTime = worldTime;
                    state.setMapType(MapType.night((RegistryKey<World>)this.mc.field_71441_e.func_234923_W_()));
                } else if (worldTime < 13800L && (neverChecked || this.lastAutoDayNightTime >= 13800L)) {
                    this.lastAutoDayNightTime = worldTime;
                    state.setMapType(MapType.day((RegistryKey<World>)this.mc.field_71441_e.func_234923_W_()));
                }
            }
        }
    }

    public void resetState() {
        state.setMapType(MapType.day((RegistryKey<World>)this.mc.field_71441_e.func_234923_W_()));
    }

    public void reset() {
        this.initTime = System.currentTimeMillis();
        this.lastAutoDayNightTime = -1L;
        this.initGridRenderer();
        this.updateDisplayVars((Shape)this.miniMapProperties.shape.get(), this.miniMapProperties.positionX.get().floatValue(), this.miniMapProperties.positionY.get().floatValue(), (Position)this.miniMapProperties.position.get(), true, true);
        MiniMapOverlayHandler.checkEventConfig();
        GridRenderer.clearDebugMessages();
        CoreProperties coreProperties = JourneymapClient.getInstance().getCoreProperties();
        this.playerArrowColor = coreProperties.getColor(coreProperties.colorSelf);
        this.playerArrowBg = TextureCache.getTexture(TextureCache.PlayerArrowBG);
        this.playerArrowFg = TextureCache.getTexture(TextureCache.PlayerArrow);
    }

    public void updateDisplayVars(boolean force) {
        this.updateDisplayVars(force, true);
    }

    public void updateDisplayVars(boolean force, boolean save) {
        if (this.dv != null) {
            this.updateDisplayVars(this.dv.shape, this.dv.positionX, this.dv.positionY, this.dv.position, force, save);
        }
    }

    public void updateDisplayVars(Shape shape, float posX, float posY, Position position, boolean force, boolean save) {
        if (this.dv != null && !force && this.mc.func_228018_at_().func_198083_n() == this.dv.displayHeight && this.mc.func_228018_at_().func_198105_m() == this.dv.displayWidth && this.dv.shape == shape && this.dv.positionX == posX && this.dv.positionY == posY && this.dv.position == position && this.dv.fontScale == (double)this.miniMapProperties.fontScale.get().floatValue()) {
            return;
        }
        if (save) {
            this.initGridRenderer();
        }
        if (force) {
            shape = (Shape)this.miniMapProperties.shape.get();
            posX = this.miniMapProperties.positionX.get().floatValue();
            posY = this.miniMapProperties.positionY.get().floatValue();
            position = (Position)this.miniMapProperties.position.get();
        }
        this.miniMapProperties.shape.set(shape);
        this.miniMapProperties.positionX.set(Float.valueOf(posX));
        this.miniMapProperties.position.set(position);
        this.miniMapProperties.positionY.set(Float.valueOf(posY));
        if (save) {
            this.miniMapProperties.save();
        }
        DisplayVars oldDv = this.dv;
        this.dv = new DisplayVars(this.mc, this.miniMapProperties);
        if (oldDv == null || oldDv.shape != this.dv.shape) {
            String timerName = String.format("MiniMap%s.%s", this.miniMapProperties.getId(), shape.name());
            this.drawTimer = StatTimer.get(timerName, 100);
            this.drawTimer.reset();
            this.refreshStateTimer = StatTimer.get(timerName + "+refreshState", 5);
            this.refreshStateTimer.reset();
        }
        double xpad = 0.0;
        double ypad = 0.0;
        Rectangle2D.Double viewPort = new Rectangle2D.Double((double)this.dv.textureX + xpad, (double)this.dv.textureY + ypad, (double)this.dv.minimapWidth - 2.0 * xpad, (double)this.dv.minimapHeight - 2.0 * ypad);
        gridRenderer.setViewPort(viewPort);
        MiniMap.updateUIState(true);
    }

    public String getLocation() {
        int playerX = MathHelper.func_76128_c((double)this.mc.field_71439_g.func_226277_ct_());
        int playerZ = MathHelper.func_76128_c((double)this.mc.field_71439_g.func_226281_cx_());
        int playerY = MathHelper.func_76128_c((double)this.mc.field_71439_g.func_174813_aQ().field_72338_b);
        return this.dv.locationFormatKeys.format(this.dv.locationFormatVerbose, playerX, playerZ, playerY, this.mc.field_71439_g.field_70162_ai);
    }

    public String getBiome() {
        return state.getPlayerBiome();
    }

    @Override
    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (this.withinBounds(pMouseX, pMouseY) && !this.minimapDragging) {
            this.minimapDragging = true;
            double scale = Minecraft.func_71410_x().func_228018_at_().func_198100_s();
            double posX = pMouseX * scale;
            double posY = pMouseY * scale;
            this.mouseDragOffsetX = (int)(posX - (double)this.getDisplayVars().textureX);
            this.mouseDragOffsetY = (int)(posY - (double)this.getDisplayVars().textureY);
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.minimapDragging) {
            int screenHeight = Minecraft.func_71410_x().func_228018_at_().func_198083_n();
            int screenWidth = Minecraft.func_71410_x().func_228018_at_().func_198105_m();
            Vector2f vec2 = this.validateScreenBounds(pMouseX, pMouseY);
            this.miniMapProperties.positionX.set(Float.valueOf(vec2.field_189982_i / (float)screenWidth));
            this.miniMapProperties.positionY.set(Float.valueOf(vec2.field_189983_j / (float)screenHeight));
            this.updateDisplayVars(true, false);
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        if (this.minimapDragging) {
            this.mouseDragOffsetX = 0;
            this.mouseDragOffsetY = 0;
            this.minimapDragging = false;
            this.updateDisplayVars(true);
            return true;
        }
        return false;
    }

    @Override
    public void tick() {
        long windowId = Minecraft.func_71410_x().func_228018_at_().func_198092_i();
        float speed = JourneymapClient.getInstance().getActiveMiniMapProperties().minimapKeyMovementSpeed.get().floatValue();
        if (InputMappings.func_216506_a((long)windowId, (int)265)) {
            this.moveMiniMapOnKey(0.0f, -speed);
        } else if (InputMappings.func_216506_a((long)windowId, (int)264)) {
            this.moveMiniMapOnKey(0.0f, speed);
        } else if (InputMappings.func_216506_a((long)windowId, (int)263)) {
            this.moveMiniMapOnKey(-speed, 0.0f);
        } else if (InputMappings.func_216506_a((long)windowId, (int)262)) {
            this.moveMiniMapOnKey(speed, 0.0f);
        }
    }

    private void moveMiniMapOnKey(float incX, float incY) {
        float x;
        float pX = this.miniMapProperties.positionX.get().floatValue();
        float pY = this.miniMapProperties.positionY.get().floatValue();
        int screenHeight = Minecraft.func_71410_x().func_228018_at_().func_198091_l();
        int screenWidth = Minecraft.func_71410_x().func_228018_at_().func_198109_k();
        float texX = (float)screenWidth * (pX + incX);
        float texY = (float)screenHeight * (pY + incY);
        DisplayVars vars = UIManager.INSTANCE.getMiniMap().getDisplayVars();
        float f = texX < 0.0f ? 0.0f : (x = texX + (float)vars.minimapWidth > (float)screenWidth ? pX : pX + incX);
        float y = texY < 0.0f ? 0.0f : (texY + (float)vars.minimapHeight > (float)screenHeight ? pY : pY + incY);
        this.miniMapProperties.positionX.set(Float.valueOf(x));
        this.miniMapProperties.positionY.set(Float.valueOf(y));
        this.updateDisplayVars(true);
    }

    @Override
    public void renderBorder(MatrixStack stack, int color) {
        int scaleFactor = (int)this.mc.func_228018_at_().func_198100_s();
        int startX = this.getDisplayVars().textureX / scaleFactor;
        int startY = this.getDisplayVars().textureY / scaleFactor;
        int width = this.getDisplayVars().minimapWidth / scaleFactor;
        int height = this.getDisplayVars().minimapHeight / scaleFactor;
        int endX = startX + width;
        int endY = startY + height;
        color = Position.Custom.equals(this.miniMapProperties.position.get()) ? color : -65536;
        AbstractGui.func_238467_a_((MatrixStack)stack, (int)startX, (int)(startY - 1), (int)(endX + 1), (int)(startY + 1), (int)color);
        AbstractGui.func_238467_a_((MatrixStack)stack, (int)(startX - 1), (int)(startY - 1), (int)(startX + 1), (int)(endY + 2), (int)color);
        AbstractGui.func_238467_a_((MatrixStack)stack, (int)startX, (int)endY, (int)(endX + 1), (int)(endY + 2), (int)color);
        AbstractGui.func_238467_a_((MatrixStack)stack, (int)endX, (int)(startY - 1), (int)(endX + 2), (int)(endY + 2), (int)color);
    }

    public Vector2f validateScreenBounds(double pMouseX, double pMouseY) {
        float x;
        int screenHeight = Minecraft.func_71410_x().func_228018_at_().func_198091_l();
        int screenWidth = Minecraft.func_71410_x().func_228018_at_().func_198109_k();
        int scale = (int)Minecraft.func_71410_x().func_228018_at_().func_198100_s();
        float posX = (float)(pMouseX * (double)scale - (double)this.mouseDragOffsetX);
        float posY = (float)(pMouseY * (double)scale - (double)this.mouseDragOffsetY);
        DisplayVars vars = UIManager.INSTANCE.getMiniMap().getDisplayVars();
        float f = posX < 0.0f ? 0.0f : (x = posX + (float)vars.minimapWidth > (float)screenWidth ? (float)(screenWidth - vars.minimapWidth) : posX);
        float y = posY < 0.0f ? 0.0f : (posY + (float)vars.minimapHeight > (float)screenHeight ? (float)(screenHeight - vars.minimapHeight) : posY);
        return new Vector2f(x, y);
    }
}

