/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.waypoint;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Since;
import java.awt.Color;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.color.RGB;
import journeymap.client.properties.WaypointProperties;
import journeymap.client.render.texture.TextureCache;
import journeymap.client.render.texture.TextureImpl;
import journeymap.client.waypoint.WaypointGroup;
import journeymap.client.waypoint.WaypointGroupStore;
import journeymap.client.waypoint.WaypointParser;
import journeymap.common.Journeymap;
import journeymap.common.helper.DimensionHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.apache.logging.log4j.util.Strings;

public class Waypoint
implements Serializable {
    public static final int VERSION = 4;
    public static final Gson GSON = new GsonBuilder().setVersion(4.0).create();
    protected static final String ICON_NORMAL = "journeymap:ui/img/waypoint-icon.png";
    protected static final String ICON_DEATH = "journeymap:ui/img/waypoint-death-icon.png";
    @Since(value=1.0)
    protected String id;
    @Since(value=1.0)
    protected String name;
    @Since(value=3.0)
    protected String groupName;
    @Since(value=2.0)
    protected String displayId;
    @Since(value=1.0)
    protected String icon;
    @Since(value=1.0)
    protected int x;
    @Since(value=1.0)
    protected int y;
    @Since(value=1.0)
    protected int z;
    @Since(value=1.0)
    protected int r;
    @Since(value=1.0)
    protected int g;
    @Since(value=1.0)
    protected int b;
    @Since(value=1.0)
    protected boolean enable;
    @Since(value=1.0)
    protected Type type;
    @Since(value=1.0)
    protected String origin;
    @Since(value=1.0)
    protected TreeSet<String> dimensions;
    @Since(value=2.0)
    protected boolean persistent;
    @Since(value=3.0)
    protected boolean showDeviation;
    @Since(value=3.0)
    protected int iconColor;
    protected transient WaypointGroup group;
    protected transient boolean dirty;

    public Waypoint() {
    }

    public Waypoint(Waypoint original) {
        this(original.name, original.x, original.y, original.z, original.enable, original.r, original.g, original.b, original.type, original.origin, original.dimensions == null || original.dimensions.isEmpty() ? null : original.dimensions.first(), original.dimensions, original.showDeviation);
        this.x = original.x;
        this.y = original.y;
        this.z = original.z;
        this.iconColor = original.iconColor;
    }

    public Waypoint(journeymap.client.api.display.Waypoint modWaypoint) {
        this(modWaypoint.getName(), modWaypoint.getPosition(), modWaypoint.getColor() == null ? Color.WHITE : new Color(modWaypoint.getColor()), Type.Normal, modWaypoint.getDimension(), false);
        String[] prim = modWaypoint.getDisplayDimensions();
        ArrayList<String> dims = new ArrayList<String>(prim.length);
        for (String aPrim : prim) {
            dims.add(aPrim);
        }
        this.setDimensions(dims);
        this.setOrigin(modWaypoint.getModId());
        this.displayId = modWaypoint.getId();
        this.setPersistent(modWaypoint.isPersistent());
        if (modWaypoint.getGroup() != null) {
            this.setGroupName(modWaypoint.getGroup().getName());
        }
    }

    public Waypoint(String name, BlockPos pos, Color color, Type type, String currentDimension, boolean showDeviation) {
        this(name, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), true, color.getRed(), color.getGreen(), color.getBlue(), type, "journeymap", currentDimension, Arrays.asList(currentDimension), showDeviation);
    }

    public Waypoint(String name, int x, int y, int z, boolean enable, int red, int green, int blue, Type type, String origin, String currentDimension, Collection<String> dimensions, boolean showDeviation) {
        if (name == null) {
            name = Waypoint.createName(x, z);
        }
        if (dimensions == null || dimensions.size() == 0) {
            dimensions = new TreeSet<String>();
            dimensions.add(DimensionHelper.getDimKeyName((RegistryKey<World>)Minecraft.func_71410_x().field_71439_g.field_70170_p.func_234923_W_()));
        }
        this.dimensions = new TreeSet<String>(dimensions);
        if (currentDimension != null) {
            this.dimensions.add(currentDimension);
        }
        this.name = name;
        this.setLocation(x, y, z, currentDimension);
        this.r = red;
        this.g = green;
        this.b = blue;
        this.enable = enable;
        this.type = type;
        this.origin = origin;
        this.persistent = true;
        this.showDeviation = showDeviation;
        this.iconColor = RGB.toInteger(red, green, blue);
        switch (type) {
            case Normal: {
                this.icon = ICON_NORMAL;
                break;
            }
            case Death: {
                this.icon = ICON_DEATH;
            }
        }
    }

    public static Waypoint of(Entity player) {
        BlockPos blockPos = new BlockPos(MathHelper.func_76128_c((double)player.func_226277_ct_()), MathHelper.func_76128_c((double)player.func_226278_cu_()), MathHelper.func_76128_c((double)player.func_226281_cx_()));
        return Waypoint.at(blockPos, Type.Normal, Minecraft.func_71410_x().field_71439_g.func_130014_f_().func_234923_W_().func_240901_a_().toString());
    }

    public static Waypoint at(BlockPos blockPos, Type type, String dimension) {
        String name;
        if (type == Type.Death) {
            Date now = new Date();
            WaypointProperties properties = JourneymapClient.getInstance().getWaypointProperties();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(properties.timeFormat.get() + " " + properties.dateFormat.get());
            String timeDate = simpleDateFormat.format(now);
            name = String.format("%s %s", Constants.getString("jm.waypoint.deathpoint"), timeDate);
        } else {
            name = Waypoint.createName(blockPos.func_177958_n(), blockPos.func_177952_p());
        }
        Waypoint waypoint = new Waypoint(name, blockPos, Color.white, type, dimension, false);
        waypoint.setRandomColor();
        return waypoint;
    }

    private static String createName(int x, int z) {
        return String.format("%s, %s", x, z);
    }

    public static Waypoint fromString(String json) {
        return (Waypoint)GSON.fromJson(json, Waypoint.class);
    }

    public static journeymap.client.api.display.Waypoint toApiWaypoint(Waypoint waypoint) {
        journeymap.client.api.display.Waypoint wp = new journeymap.client.api.display.Waypoint(waypoint.getOrigin(), waypoint.getId(), waypoint.getName(), waypoint.dimensions.first(), waypoint.getBlockPos());
        wp.setDisplayDimensions(waypoint.getDimensions().toArray(new String[0]));
        return wp;
    }

    public Waypoint setLocation(int x, int y, int z, String currentDimension) {
        this.x = "minecraft:the_nether".equalsIgnoreCase(currentDimension) ? x * 8 : x;
        this.y = y;
        this.z = "minecraft:the_nether".equalsIgnoreCase(currentDimension) ? z * 8 : z;
        this.updateId();
        return this.setDirty();
    }

    public String updateId() {
        String oldId = this.id;
        this.id = String.format("%s_%s,%s,%s", this.name, this.x, this.y, this.z);
        return oldId;
    }

    public boolean isDeathPoint() {
        return this.type == Type.Death;
    }

    public TextureImpl getTexture() {
        return this.isDeathPoint() ? TextureCache.getTexture(TextureCache.Deathpoint) : TextureCache.getTexture(TextureCache.waypointIconCache.get(this.icon));
    }

    public ResourceLocation getTextureResource() {
        return this.isDeathPoint() ? TextureCache.Deathpoint : TextureCache.waypointIconCache.get(this.icon);
    }

    public ChunkPos getChunkCoordIntPair() {
        return new ChunkPos(this.x >> 4, this.z >> 4);
    }

    public Waypoint setGroup(WaypointGroup group) {
        this.setOrigin(group.getOrigin());
        this.groupName = group.getName();
        this.group = group;
        return this.setDirty();
    }

    public Waypoint setGroupName(String groupName) {
        WaypointGroup group = WaypointGroupStore.INSTANCE.get(this.origin, groupName);
        this.setGroup(group);
        return this;
    }

    public WaypointGroup getGroup() {
        if (this.group == null) {
            if (Strings.isEmpty((CharSequence)this.origin) || Strings.isEmpty((CharSequence)this.groupName)) {
                this.setGroup(WaypointGroup.DEFAULT);
            } else {
                this.setGroup(WaypointGroupStore.INSTANCE.get(this.origin, this.groupName));
            }
        }
        return this.group;
    }

    public Waypoint setRandomColor() {
        return this.setColor(RGB.randomColor());
    }

    public Integer getColor() {
        return RGB.toInteger(this.r, this.g, this.b);
    }

    public String getPrettyName() {
        TextFormatting textFormatting = TextFormatting.WHITE;
        for (TextFormatting tf : TextFormatting.values()) {
            if (tf.func_211163_e() == null || !tf.func_211163_e().equals((this.r & 0xFF) << 16 | (this.g & 0xFF) << 8 | this.b & 0xFF)) continue;
            textFormatting = tf;
        }
        return textFormatting.toString() + this.name + TextFormatting.WHITE;
    }

    public void setIconColor(int iconColor) {
        this.iconColor = iconColor;
    }

    public int getIconColor() {
        if (this.useCustomColor()) {
            return this.iconColor;
        }
        return this.getColor();
    }

    private boolean useCustomColor() {
        return RGB.toInteger(this.r, this.g, this.b) != this.iconColor && !ICON_NORMAL.equals(this.icon) && !ICON_DEATH.equals(this.icon);
    }

    public Waypoint setColor(Integer color) {
        int[] c = RGB.ints(color);
        this.r = c[0];
        this.g = c[1];
        this.b = c[2];
        return this.setDirty();
    }

    public Integer getSafeColor() {
        if (this.r + this.g + this.b >= 100) {
            return this.getColor();
        }
        return 0x404040;
    }

    public Collection<String> getDimensions() {
        return this.dimensions;
    }

    public Waypoint setDimensions(Collection<String> dims) {
        this.dimensions = new TreeSet<String>(dims);
        return this.setDirty();
    }

    public boolean isTeleportReady() {
        return this.y >= 0 && this.isInPlayerDimension();
    }

    public boolean isInPlayerDimension() {
        return this.dimensions.contains(Minecraft.func_71410_x().field_71439_g.field_70170_p.func_234923_W_().func_240901_a_().toString());
    }

    public String getId() {
        return this.displayId != null ? this.getGuid() : this.id;
    }

    public String getGuid() {
        return this.origin + ":" + this.displayId;
    }

    public String getName() {
        return this.name;
    }

    public Waypoint setName(String name) {
        this.name = name;
        return this.setDirty();
    }

    public ResourceLocation getIcon() {
        return TextureCache.waypointIconCache.get(this.icon);
    }

    public Waypoint setIcon(ResourceLocation iconResource) {
        this.icon = iconResource.toString();
        TextureCache.waypointIconCache.put(this.icon, iconResource);
        return this.setDirty();
    }

    public int getX() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc != null && mc.field_71439_g != null && DimensionHelper.isNetherWorld((World)mc.field_71441_e)) {
            return this.x >> 3;
        }
        return this.x;
    }

    public double getRawCenterX() {
        return (double)this.x + 0.5;
    }

    public double getRawCenterZ() {
        return (double)this.z + 0.5;
    }

    public double getBlockCenteredX() {
        return (double)this.getX() + 0.5;
    }

    public int getY() {
        return this.y;
    }

    public double getBlockCenteredY() {
        return (double)this.getY() + 0.5;
    }

    public int getZ() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc != null && mc.field_71439_g != null && DimensionHelper.isNetherWorld((World)mc.field_71441_e)) {
            return this.z >> 3;
        }
        return this.z;
    }

    public double getBlockCenteredZ() {
        return (double)this.getZ() + 0.5;
    }

    public Vector3d getPosition() {
        return new Vector3d(this.getBlockCenteredX(), this.getBlockCenteredY(), this.getBlockCenteredZ());
    }

    public BlockPos getBlockPos() {
        return new BlockPos(this.getX(), this.getY(), this.getZ());
    }

    public int getR() {
        return this.r;
    }

    public Waypoint setR(int r) {
        this.r = r;
        return this.setDirty();
    }

    public int getG() {
        return this.g;
    }

    public Waypoint setG(int g) {
        this.g = g;
        return this.setDirty();
    }

    public int getB() {
        return this.b;
    }

    public Waypoint setB(int b) {
        this.b = b;
        return this.setDirty();
    }

    public boolean isEnable() {
        return this.enable;
    }

    public Waypoint setEnable(boolean enable) {
        if (enable != this.enable) {
            this.enable = enable;
            this.setDirty();
        }
        return this;
    }

    public Type getType() {
        return this.type;
    }

    public Waypoint setType(Type type) {
        this.type = type;
        return this.setDirty();
    }

    public String getOrigin() {
        return this.origin;
    }

    public Waypoint setOrigin(String origin) {
        this.origin = origin;
        return this.setDirty();
    }

    public String getFileName() {
        String fileName = this.id.replaceAll("[\\\\/:\"*?<>|]", "_").concat(".json");
        if (fileName.equals("waypoint_groups.json")) {
            fileName = "_" + fileName;
        }
        return fileName;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public Waypoint setDirty() {
        return this.setDirty(true);
    }

    public Waypoint setDirty(boolean dirty) {
        if (this.isPersistent()) {
            this.dirty = dirty;
        }
        return this;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public Waypoint setPersistent(boolean persistent) {
        this.persistent = persistent;
        this.dirty = persistent;
        return this;
    }

    public String toChatString() {
        boolean useName = !this.getName().equals(String.format("%s, %s", this.getX(), this.getZ()));
        return this.toChatString(useName);
    }

    public String toChatString(boolean useName) {
        String format;
        String result;
        boolean useDim = !"overworld".equalsIgnoreCase(this.dimensions.first());
        ArrayList<String> parts = new ArrayList<String>();
        ArrayList<Object> args2 = new ArrayList<Object>();
        if (useName) {
            parts.add("name:\"%s\"");
            args2.add(this.getName().replaceAll("\"", " "));
        }
        parts.add("x:%s, y:%s, z:%s");
        args2.add(this.getX());
        args2.add(this.getY());
        args2.add(this.getZ());
        if (useDim) {
            parts.add("dim:%s");
            args2.add(this.dimensions.first());
        }
        if (WaypointParser.parse(result = String.format(format = "[" + Joiner.on((String)", ").join(parts) + "]", args2.toArray())) == null) {
            Journeymap.getLogger().warn("Couldn't produce parsable chat string from Waypoint: " + this);
            if (useName) {
                return this.toChatString(false);
            }
        }
        return result;
    }

    public String toString() {
        return GSON.toJson((Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Waypoint waypoint = (Waypoint)o;
        if (this.b != waypoint.b) {
            return false;
        }
        if (this.enable != waypoint.enable) {
            return false;
        }
        if (this.g != waypoint.g) {
            return false;
        }
        if (this.r != waypoint.r) {
            return false;
        }
        if (this.x != waypoint.x) {
            return false;
        }
        if (this.y != waypoint.y) {
            return false;
        }
        if (this.z != waypoint.z) {
            return false;
        }
        if (!this.dimensions.equals(waypoint.dimensions)) {
            return false;
        }
        if (!this.icon.equals(waypoint.icon)) {
            return false;
        }
        if (!this.id.equals(waypoint.id)) {
            return false;
        }
        if (!this.name.equals(waypoint.name)) {
            return false;
        }
        if (this.origin.equals(waypoint.origin)) {
            return false;
        }
        if (this.type != waypoint.type) {
            return false;
        }
        if (this.showDeviation != waypoint.showDeviation) {
            return false;
        }
        return this.iconColor == waypoint.iconColor;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean showDeviation() {
        return this.showDeviation;
    }

    public Waypoint setShowDeviation(Boolean toggled) {
        if (toggled != this.showDeviation) {
            this.showDeviation = toggled;
            this.setDirty();
        }
        return this;
    }

    public static enum Origin {
        SERVER("server"),
        COMMAND("command"),
        EXTERNAL("external"),
        EXTERNAL_FORCE("external-force");

        final String value;
        private static final List<String> values;

        private Origin(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static List<String> getValues() {
            return values;
        }

        static {
            values = Lists.newArrayList();
            for (Origin o : Origin.values()) {
                values.add(o.value);
            }
        }
    }

    public static enum Type {
        Normal,
        Death;

    }
}

