/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common;

import com.mojang.authlib.GameProfile;
import journeymap.client.JourneymapClient;
import journeymap.common.command.CommandRegistry;
import journeymap.common.config.ForgeConfig;
import journeymap.common.events.ForgeEvents;
import journeymap.common.nbt.WorldNbtIDSaveHandler;
import journeymap.common.network.dispatch.NetworkDispatcher;
import journeymap.common.network.dispatch.NetworkDispatcherImpl;
import journeymap.common.network.forge.PacketRegistry;
import journeymap.common.network.forge.dispatch.ForgeNetworkDispatcher;
import journeymap.common.network.handler.PacketHandler;
import journeymap.common.properties.PropertiesManager;
import journeymap.common.version.Version;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="journeymap")
@Mod.EventBusSubscriber(modid="journeymap")
public class Journeymap {
    public static final String MOD_ID = "journeymap";
    public static final String SHORT_MOD_NAME = "JourneyMap";
    public static boolean DEV_MODE = false;
    public static final Version JM_VERSION = Version.from("5", "8", "0", "beta10", new Version(5, 8, 0, "dev"));
    public static final String FORGE_VERSION = "1.16.5-36.2.22";
    public static final String MC_VERSION = "1.16.5";
    public static final String WEBSITE_URL = "http://journeymap.info/";
    public static final String DOWNLOAD_URL = "http://minecraft.curseforge.com/projects/journeymap/files/";
    public static final String VERSION_URL = "https://api.cfwidget.com/minecraft/mc-mods/journeymap";
    private static Journeymap instance;
    private NetworkDispatcher dispatcher;
    private PacketHandler handler;

    public Journeymap() {
        instance = this;
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> MinecraftForge.EVENT_BUS.register((Object)new JourneymapClient()));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetupEvent);
        MinecraftForge.EVENT_BUS.addListener(this::serverStartingEvent);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, ForgeConfig.SERVER_SPEC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::serverConfig);
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(() -> "", (a, b) -> true));
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
    }

    public static Journeymap getInstance() {
        return instance;
    }

    public static Logger getLogger() {
        return LogManager.getLogger((String)MOD_ID);
    }

    public static Logger getLogger(String name) {
        return LogManager.getLogger((String)("journeymap/" + name));
    }

    public void commonSetupEvent(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            Journeymap.getLogger().info("Initializing Packet Registries");
            PacketRegistry.init();
            PacketRegistry.initExternalPackets();
        });
        this.handler = new PacketHandler();
        this.dispatcher = new NetworkDispatcherImpl(new ForgeNetworkDispatcher());
        MinecraftForge.EVENT_BUS.register((Object)new ForgeEvents());
        MinecraftForge.EVENT_BUS.register(CommandRegistry.class);
    }

    @SubscribeEvent
    public void serverConfig(ModConfig.ModConfigEvent event) {
        if (event.getConfig().getType() == ModConfig.Type.SERVER) {
            ForgeConfig.load();
        }
    }

    @SubscribeEvent
    public void serverStartingEvent(FMLServerStartingEvent event) {
        new WorldNbtIDSaveHandler().getWorldID();
        PropertiesManager.getInstance();
    }

    public NetworkDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public PacketHandler getPacketHandler() {
        return this.handler;
    }

    public static boolean isOp(PlayerEntity player) {
        if (LogicalSide.CLIENT.equals((Object)EffectiveSide.get())) {
            MinecraftServer mcServer = ServerLifecycleHooks.getCurrentServer();
            boolean creative = player.field_71075_bZ.field_75098_d;
            boolean cheatMode = mcServer.func_184103_al().func_152596_g(new GameProfile(player.func_110124_au(), player.func_200200_C_().getString()));
            return creative || cheatMode;
        }
        return ServerLifecycleHooks.getCurrentServer().func_184103_al().func_152603_m().func_152683_b((Object)player.func_146103_bH()) != null;
    }
}

