/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.forge;

import java.util.function.Supplier;
import journeymap.client.JourneymapClient;
import journeymap.common.Journeymap;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class BiomePacket {
    private ResourceLocation biomeResource;
    private BlockPos pos;

    public BiomePacket() {
    }

    public BiomePacket(ResourceLocation biomeResource) {
        this.biomeResource = biomeResource;
        this.pos = BlockPos.field_177992_a;
    }

    public BiomePacket(BlockPos pos) {
        this.pos = pos;
        this.biomeResource = new ResourceLocation("");
    }

    public BiomePacket(PacketBuffer buf) {
        try {
            if (buf.capacity() > 1) {
                this.biomeResource = buf.func_192575_l();
                this.pos = buf.func_179259_c();
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(String.format("Failed to read message for teleport packet: %s", t));
        }
    }

    public void encode(PacketBuffer buf) {
        try {
            buf.func_192572_a(this.biomeResource);
            buf.func_179255_a(this.pos);
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("[toBytes]Failed to write message for teleport packet:" + t);
        }
    }

    public static void handle(BiomePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isServer()) {
                Journeymap.getInstance().getPacketHandler().handleBiomeRequest(((NetworkEvent.Context)ctx.get()).getSender(), packet.pos);
            } else {
                JourneymapClient.getInstance().getPacketHandler().handleBiomeResponse(packet.biomeResource);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

