/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.forge;

import java.util.function.Predicate;
import journeymap.common.Journeymap;
import journeymap.common.network.forge.BiomePacket;
import journeymap.common.network.forge.ClientPermissionsPacket;
import journeymap.common.network.forge.ServerAdminRequestPropPacket;
import journeymap.common.network.forge.ServerAdminSavePropPacket;
import journeymap.common.network.forge.ServerPlayerLocationPacket;
import journeymap.common.network.forge.TeleportPacket;
import journeymap.common.network.forge.VersionRequestPacket;
import journeymap.common.network.forge.WaypointPacket;
import journeymap.common.network.forge.WorldIdPacket;
import journeymap.common.version.Version;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class PacketRegistry {
    private static PacketRegistry INSTANCE;
    private static final Version MINIMUM_SERVER_ACCEPTABLE_VERSION;
    private static final Version MINIMUM_CLIENT_ACCEPTABLE_VERSION;
    private static final Version DEV_VERSION;
    private static final String MOD_VERSION;
    private static final String WORLD_INFO = "worldinfo";
    public static SimpleChannel EXTERNAL_WORLD_ID;
    public static SimpleChannel VERSION_REQUEST;
    public static SimpleChannel EXTERNAL_WAYPOINT;
    public static SimpleChannel COMMON_NETWORK;

    public static void init() {
        NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("journeymap", "channel")).clientAcceptedVersions(PacketRegistry.getClientAcceptedVersion()).serverAcceptedVersions(PacketRegistry.getServerAcceptedVersion()).networkProtocolVersion(() -> MOD_VERSION).simpleChannel();
        Journeymap.getLogger().debug("Registering internal Network handler.");
        INSTANCE = new PacketRegistry();
        COMMON_NETWORK = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("journeymap", "common")).clientAcceptedVersions(PacketRegistry.getClientAcceptedVersion()).serverAcceptedVersions(PacketRegistry.getServerAcceptedVersion()).networkProtocolVersion(() -> MOD_VERSION).simpleChannel();
        COMMON_NETWORK.registerMessage(0, ServerAdminRequestPropPacket.class, ServerAdminRequestPropPacket::encode, ServerAdminRequestPropPacket::new, ServerAdminRequestPropPacket::handle);
        COMMON_NETWORK.registerMessage(1, ServerAdminSavePropPacket.class, ServerAdminSavePropPacket::encode, ServerAdminSavePropPacket::new, ServerAdminSavePropPacket::handle);
        COMMON_NETWORK.registerMessage(2, ClientPermissionsPacket.class, ClientPermissionsPacket::encode, ClientPermissionsPacket::new, ClientPermissionsPacket::handle);
        COMMON_NETWORK.registerMessage(3, ServerPlayerLocationPacket.class, ServerPlayerLocationPacket::encode, ServerPlayerLocationPacket::new, ServerPlayerLocationPacket::handle);
        COMMON_NETWORK.registerMessage(4, TeleportPacket.class, TeleportPacket::encode, TeleportPacket::new, TeleportPacket::handle);
        COMMON_NETWORK.registerMessage(5, BiomePacket.class, BiomePacket::encode, BiomePacket::new, BiomePacket::handle);
    }

    public static void initExternalPackets() {
        Journeymap.getLogger().debug("Registering external WorldId packet handler on channel -> \"{}:{}\".", (Object)WORLD_INFO, (Object)"world_id");
        EXTERNAL_WORLD_ID = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation(WORLD_INFO, "world_id")).clientAcceptedVersions(a -> true).serverAcceptedVersions(a -> true).networkProtocolVersion(() -> "1").simpleChannel();
        EXTERNAL_WORLD_ID.registerMessage(0, WorldIdPacket.class, WorldIdPacket::encode, WorldIdPacket::new, WorldIdPacket::handle);
        Journeymap.getLogger().debug("Registering external waypoint crud listener handler on channel -> \"{}\".", (Object)WaypointPacket.CHANNEL.toString());
        EXTERNAL_WAYPOINT = NetworkRegistry.ChannelBuilder.named((ResourceLocation)WaypointPacket.CHANNEL).clientAcceptedVersions(a -> true).serverAcceptedVersions(a -> true).networkProtocolVersion(() -> "1").simpleChannel();
        EXTERNAL_WAYPOINT.registerMessage(0, WaypointPacket.class, WaypointPacket::encode, WaypointPacket::new, WaypointPacket::handle);
        VERSION_REQUEST = NetworkRegistry.ChannelBuilder.named((ResourceLocation)VersionRequestPacket.CHANNEL).clientAcceptedVersions(a -> true).serverAcceptedVersions(a -> true).networkProtocolVersion(() -> "1").simpleChannel();
        VERSION_REQUEST.registerMessage(0, VersionRequestPacket.class, VersionRequestPacket::encode, VersionRequestPacket::new, VersionRequestPacket::handle);
    }

    private static Predicate<String> getClientAcceptedVersion() {
        return server -> {
            if (server.equalsIgnoreCase(NetworkRegistry.ABSENT) || server.equalsIgnoreCase(NetworkRegistry.ACCEPTVANILLA)) {
                return true;
            }
            if (DEV_VERSION.equals(Version.from(server, null))) {
                Journeymap.getLogger().info("Dev Mode? " + server + " " + Journeymap.JM_VERSION.toString());
                return true;
            }
            if (MINIMUM_SERVER_ACCEPTABLE_VERSION.isNewerThan(Version.from(server.trim(), null))) {
                Journeymap.getLogger().info("Version Mismatch need " + MINIMUM_SERVER_ACCEPTABLE_VERSION.toString() + " or higher. Current server version attempt -> " + Version.from(server, null).toString());
                return false;
            }
            return true;
        };
    }

    private static Predicate<String> getServerAcceptedVersion() {
        return client -> {
            if (client.equalsIgnoreCase(NetworkRegistry.ABSENT) || client.equalsIgnoreCase(NetworkRegistry.ACCEPTVANILLA)) {
                return true;
            }
            if (DEV_VERSION.equals(Version.from(client, null))) {
                Journeymap.getLogger().info("Dev Mode? " + client + " " + Journeymap.JM_VERSION.toString());
                return true;
            }
            if (MINIMUM_CLIENT_ACCEPTABLE_VERSION.isNewerThan(Version.from(client.trim(), null))) {
                Journeymap.getLogger().info("Version Mismatch need " + MINIMUM_CLIENT_ACCEPTABLE_VERSION.toString() + " or higher. Current client version attempt -> " + Version.from(client, null).toString());
                return false;
            }
            return true;
        };
    }

    public static PacketRegistry getInstance() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        Journeymap.getLogger().error("Packet Handler not initialized before use.");
        throw new UnsupportedOperationException("Packet Handler not Initialized");
    }

    static {
        MINIMUM_SERVER_ACCEPTABLE_VERSION = new Version(5, 8, 0, "beta10");
        MINIMUM_CLIENT_ACCEPTABLE_VERSION = new Version(5, 8, 0, "beta10");
        DEV_VERSION = new Version(5, 8, 0, "dev");
        MOD_VERSION = Journeymap.JM_VERSION.toString();
    }
}

